% --- Source file: summary.trivPenal.Rd ---
\name{summary.trivPenal}
\Rdversion{1.1}
\alias{summary.trivPenal}
\alias{print.summary.trivPenal}


\title{Short summary of fixed covariates estimates of a joint model for longitudinal data, recurrent events and a terminal event}

\description{
  This function returns coefficients estimates and their standard error with p-values of the Wald test for the longitudinal outcome and hazard ratios (HR) and their confidence intervals for the terminal event.
}
\usage{
\method{summary}{trivPenal}(object, level = 0.95, len = 6, d = 2, lab=c("coef","hr"), ...)
}

\arguments{
  \item{object}{an object inheriting from \code{trivPenal} class}
  \item{level}{significance level of confidence interval. Default is 95\%.}
  \item{d}{the desired number of digits after the decimal point. Default of 6 digits is used.}
  \item{len}{the total field width for the terminal part. Default is 6.}
  \item{lab}{labels of printed results for the longitudinal outcome and the terminal event respectively.}
  \item{\dots}{ other unused arguments.}
}


\value{
  For the longitudinal outcome it prints the estimates of coefficients of the fixed covariates with their standard error and p-values of the Wald test. For the terminal event it prints HR and its confidence intervals for each covariate. Confidence level is allowed (level argument).
}


\seealso{
 \code{\link{trivPenal}}
}

\examples{

\dontrun{

###--- Trivariate joint model for longitudinal data, ---###
###--- recurrent events and a terminal event ---###

data(colorectal)
data(colorectalLongi)

# Weibull baseline hazard function
# Random effects as the link function, Gap timescale
# (computation takes around 30 minutes)
model.weib.RE.gap <-trivPenal(Surv(gap.time, new.lesions) ~ cluster(id)
+ age + treatment + who.PS + prev.resection + terminal(state),
formula.terminalEvent =~ age + treatment + who.PS + prev.resection, 
tumor.size ~ year * treatment + age + who.PS, data = colorectal,
data.Longi = colorectalLongi, random = c("1", "year"), id = "id", 
link = "Random-effects", left.censoring = -3.33, recurrentAG = FALSE,
hazard = "Weibull", method.GH="Pseudo-adaptive", n.nodes = 7)

summary(model.weib.RE.gap)
}

}

\keyword{methods}
