/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.xml.EdgeComparator;
import salvo.jesus.graph.xml.GraphToXMLEventGenerator;
import salvo.jesus.graph.xml.GraphToXMLHandler;

public class GraphToXMLEventGeneratorImpl
implements GraphToXMLEventGenerator {
    ArrayList handlers = new ArrayList();

    public void addHandler(GraphToXMLHandler handlerToAdd) {
        this.handlers.add(handlerToAdd);
    }

    public void removeHandler(GraphToXMLHandler handlerToRemove) {
        this.handlers.remove(handlerToRemove);
    }

    public void serialize(Graph graph) throws Exception {
        TreeSet edgeSet = new TreeSet(new EdgeComparator());
        Iterator vertexIterator = graph.getVerticesIterator();
        this.notifyStartSerialize(graph);
        while (vertexIterator.hasNext()) {
            Vertex vertex = (Vertex)vertexIterator.next();
            this.notifySerializeVertex(vertex);
            edgeSet.addAll(graph.getEdges(vertex));
        }
        Iterator edgeIterator = edgeSet.iterator();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            this.notifySerializeEdge(edge);
        }
        this.notifyEndSerialize();
    }

    public void serialize(VisualGraph vGraph) throws Exception {
        Graph graph = vGraph.getGraph();
        TreeSet edgeSet = new TreeSet(new EdgeComparator());
        Iterator vertexIterator = graph.getVerticesIterator();
        this.notifyStartSerialize(vGraph);
        while (vertexIterator.hasNext()) {
            Vertex vertex = (Vertex)vertexIterator.next();
            this.notifySerializeVertex(vertex);
            edgeSet.addAll(graph.getEdges(vertex));
        }
        Iterator edgeIterator = edgeSet.iterator();
        while (edgeIterator.hasNext()) {
            Edge edge = (Edge)edgeIterator.next();
            this.notifySerializeEdge(edge);
        }
        this.notifyEndSerialize();
    }

    public void notifyStartSerialize(Graph graph) throws Exception {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            GraphToXMLHandler handler = (GraphToXMLHandler)iterator.next();
            handler.startSerialize(graph);
        }
    }

    public void notifyStartSerialize(VisualGraph vGraph) throws Exception {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            GraphToXMLHandler handler = (GraphToXMLHandler)iterator.next();
            handler.startSerialize(vGraph);
        }
    }

    public void notifySerializeVertex(Vertex vertex) throws Exception {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            GraphToXMLHandler handler = (GraphToXMLHandler)iterator.next();
            handler.serializeVertex(vertex);
            handler.endSerializeVertex(vertex);
        }
    }

    public void notifySerializeEdge(Edge edge) throws Exception {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            GraphToXMLHandler handler = (GraphToXMLHandler)iterator.next();
            handler.serializeEdge(edge);
            handler.endSerializeEdge(edge);
        }
    }

    public void notifyEndSerialize() throws Exception {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            GraphToXMLHandler handler = (GraphToXMLHandler)iterator.next();
            handler.endSerialize();
        }
    }
}

