/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.io.IOException;
import org.jpmml.xgboost.BinaryLoadable;
import org.jpmml.xgboost.Node;
import org.jpmml.xgboost.XGBoostDataInput;

public class BinaryNode
extends Node
implements BinaryLoadable {
    private int parent;
    private int cleft;
    private int cright;
    private int sindex;
    private int info;

    @Override
    public void loadBinary(XGBoostDataInput input) throws IOException {
        this.parent = input.readInt();
        this.cleft = input.readInt();
        this.cright = input.readInt();
        this.sindex = input.readInt();
        this.info = input.readInt();
    }

    @Override
    public boolean is_leaf() {
        return this.cleft == -1;
    }

    @Override
    public int left_child() {
        return this.cleft;
    }

    @Override
    public int right_child() {
        return this.cright;
    }

    @Override
    public boolean default_left() {
        return this.sindex >> 31 != 0;
    }

    @Override
    public int split_index() {
        return (int)((long)this.sindex & Integer.MAX_VALUE);
    }

    @Override
    public int split_cond() {
        return this.info;
    }

    @Override
    public float leaf_value() {
        return Float.intBitsToFloat(this.info);
    }
}

