## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----install, eval=FALSE------------------------------------------------------
#  install.packages("heritEWAS")

## ----setup--------------------------------------------------------------------
library(heritEWAS)

## -----------------------------------------------------------------------------
head(ped)
unique(ped$family)

## -----------------------------------------------------------------------------
# Colnames are the individual IDs of the pedigree data
M_values[1:5, 1:5]

## -----------------------------------------------------------------------------
typed_genos <- genotype_combinations(ped)

## -----------------------------------------------------------------------------
str(typed_genos)

## -----------------------------------------------------------------------------
MLEs <- ML_estimates(typed_genos, M_values, ncores = 2)
head(MLEs)

