/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.task.profile;

import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveSModel;
import choco.cp.solver.constraints.global.scheduling.precedence.ITemporalSRelation;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.scheduling.IResource;
import choco.kernel.solver.variables.scheduling.ITask;
import gnu.trove.TIntIntHashMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ProbabilisticProfile {
    private final TIntIntHashMap indexMap = new TIntIntHashMap();
    private final List<EventRProf> function = new LinkedList<EventRProf>();
    private final EventDataStructure[] structList;
    private double slope;
    private double gap;
    private int coordinate;
    protected final BitSet involved = new BitSet();
    private final MaximumDataStruct max = new MaximumDataStruct();
    public final DisjunctiveSModel disjSModel;

    public ProbabilisticProfile(ITask[] tasks, DisjunctiveSModel disjSModel) {
        this(Arrays.asList(tasks), disjSModel);
    }

    public ProbabilisticProfile(List<? extends ITask> tasks, DisjunctiveSModel disjSModel) {
        this.disjSModel = disjSModel;
        this.structList = new EventDataStructure[tasks.size()];
        for (int i = 0; i < this.structList.length; ++i) {
            this.structList[i] = new EventDataStructure(tasks.get(i));
            this.indexMap.put(tasks.get(i).getID(), i);
        }
    }

    public ProbabilisticProfile(Solver solver, DisjunctiveSModel disjSModel) {
        this.disjSModel = disjSModel;
        this.structList = new EventDataStructure[solver.getNbTaskVars()];
        for (int i = 0; i < this.structList.length; ++i) {
            this.structList[i] = new EventDataStructure(solver.getTaskVar(i));
            this.indexMap.put(solver.getTaskVar(i).getID(), i);
        }
    }

    public final double getIndividualContribution(ITask task, int coordinate) {
        return this.getEDS(task).getIndividualContribution(coordinate);
    }

    protected EventDataStructure getEDS(ITask task) {
        return this.structList[this.indexMap.get(task.getID())];
    }

    public final void generateEventsList(IResource<? extends ITask> rsc) {
        this.function.clear();
        Iterator<? extends ITask> iter = rsc.getTaskIterator();
        while (iter.hasNext()) {
            this.function.addAll(Arrays.asList(this.getEDS((ITask)iter.next()).events));
        }
        Collections.sort(this.function);
    }

    protected void resetSweepData() {
        this.gap = 0.0;
        this.slope = 0.0;
        this.coordinate = Integer.MIN_VALUE;
        this.involved.clear();
    }

    protected void handleEvents(EventRProf e, ListIterator<EventRProf> iter) {
        this.handleEvent(e);
        while (iter.hasNext()) {
            EventRProf next = iter.next();
            if (next.coordinate > e.coordinate) {
                iter.previous();
                break;
            }
            this.handleEvent(next);
        }
    }

    protected void handleEvent(EventRProf e) {
        this.slope += e.slope;
        this.gap += e.gap;
        switch (e.type) {
            case START: {
                this.involved.set(e.task.getID());
                break;
            }
            case END: {
                this.involved.clear(e.task.getID());
            }
        }
    }

    public void initializeEvents() {
        for (EventDataStructure eds : this.structList) {
            eds.reset();
        }
    }

    protected final void sweep() {
        ListIterator<EventRProf> iter = this.function.listIterator();
        while (iter.hasNext()) {
            EventRProf e = iter.next();
            this.update(e.coordinate);
            this.handleEvents(e, iter);
            if (!(this.gap > this.max.value) || !this.isValidMaximum()) continue;
            this.max.value = this.gap;
            this.max.coordinate = e.coordinate;
            this.max.involved.clear();
            this.max.involved.or(this.involved);
        }
    }

    public final void computeMaximum(IResource<?> ... resources) {
        this.max.reset();
        for (IResource<?> rsc : resources) {
            this.generateEventsList(rsc);
            this.resetSweepData();
            this.sweep();
        }
    }

    protected boolean isValidMaximum() {
        int i = this.involved.nextSetBit(0);
        while (i >= 0) {
            int j = this.involved.nextSetBit(i + 1);
            while (j >= 0) {
                if (this.disjSModel.containsEdge(i, j) && !((ITemporalSRelation)this.disjSModel.getConstraint(i, j)).isFixed()) {
                    return true;
                }
                j = this.involved.nextSetBit(j + 1);
            }
            i = this.involved.nextSetBit(i + 1);
        }
        return false;
    }

    public double getMaxProfileValue() {
        return this.max.value;
    }

    public int getMaxProfileCoord() {
        return this.max.coordinate;
    }

    public BitSet getInvolvedInMaxProf() {
        return this.max.involved;
    }

    public double compute(int x) {
        this.resetSweepData();
        ListIterator<EventRProf> iter = this.function.listIterator();
        while (iter.hasNext()) {
            EventRProf e = iter.next();
            if (e.coordinate > x) break;
            this.update(e.coordinate);
            this.handleEvent(e);
        }
        this.update(x);
        return this.gap;
    }

    private double shift(int x) {
        return (double)(x - this.coordinate) * this.slope;
    }

    protected void update(int x) {
        this.gap += this.shift(x);
        this.coordinate = x;
    }

    private void drawPoint(StringBuilder buffer) {
        buffer.append(this.coordinate).append(' ').append(this.gap).append('\n');
    }

    public StringBuilder draw() {
        this.resetSweepData();
        StringBuilder buffer = new StringBuilder();
        ListIterator<EventRProf> iter = this.function.listIterator();
        while (iter.hasNext()) {
            EventRProf e = iter.next();
            this.update(e.coordinate);
            this.drawPoint(buffer);
            this.handleEvents(e, iter);
            this.drawPoint(buffer);
        }
        return buffer;
    }

    protected static class EventDataStructure {
        public static final int EST = 0;
        public static final int LST = 1;
        public static final int ECT = 2;
        public static final int LCT = 3;
        protected final ITask task;
        protected EventRProf[] events;

        public EventDataStructure(ITask task) {
            this.task = task;
            this.events = (EventRProf[])Array.newInstance(EventRProf.class, 4);
            this.events[0] = new EventRProf(EventType.START, task);
            this.events[1] = new EventRProf(EventType.MID);
            this.events[2] = new EventRProf(EventType.MID);
            this.events[3] = new EventRProf(EventType.END, task);
        }

        public double getIndividualContribution(int x) {
            double contrib = 0.0;
            if (x >= this.events[0].coordinate && x < this.events[3].coordinate) {
                contrib += this.events[0].gap;
                if (!this.task.isScheduled()) {
                    contrib += this.events[0].slope * (double)(Math.min(x, this.events[1].coordinate) - this.events[0].coordinate);
                    if (x >= this.events[2].coordinate) {
                        contrib += this.events[2].slope * (double)(x - this.events[2].coordinate);
                    }
                }
            }
            return contrib;
        }

        private void set(int idx, int x, double slope, double gap) {
            this.events[idx].coordinate = x;
            this.events[idx].gap = gap;
            this.events[idx].slope = slope;
        }

        public void reset() {
            int dur = this.task.getMinDuration();
            assert (dur > 0);
            int est = this.task.getEST();
            int lst = this.task.getLST();
            double std = lst - est + 1;
            double gap = 1.0 / std;
            double slope = std <= (double)dur ? 1.0 / std : (double)(dur - 1) / (std * (double)dur);
            this.set(0, est, slope, gap);
            this.set(1, lst, -slope, 0.0);
            this.set(2, this.task.getECT(), -slope, 0.0);
            this.set(3, this.task.getLCT(), slope, -gap);
        }
    }

    static class EventRProf
    implements Comparable<EventRProf> {
        public final EventType type;
        public final ITask task;
        public int coordinate;
        public double slope;
        public double gap;

        public EventRProf(EventType type) {
            this(type, null);
        }

        public EventRProf(EventType type, ITask task) {
            this(type, 0, 0.0, 0.0, task);
        }

        public EventRProf(EventType type, int coordinates, double slope, double gap, ITask task) {
            this.type = type;
            this.coordinate = coordinates;
            this.slope = slope;
            this.gap = gap;
            this.task = task;
        }

        public final int getCoordinates() {
            return this.coordinate;
        }

        public final void setCoordinates(int coordinates) {
            this.coordinate = coordinates;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append((Object)this.type);
            buffer.append(this.coordinate).append("(");
            buffer.append(this.slope).append(',').append(this.gap).append(')');
            return buffer.toString();
        }

        @Override
        public int compareTo(EventRProf o) {
            int x1 = this.coordinate;
            int x2 = o.getCoordinates();
            if (x1 < x2) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            return 0;
        }
    }

    static enum EventType {
        START,
        MID,
        END;

    }

    protected static class MaximumDataStruct {
        public int coordinate;
        public double value;
        public final BitSet involved = new BitSet();

        protected MaximumDataStruct() {
        }

        public void reset() {
            this.coordinate = Integer.MIN_VALUE;
            this.value = Double.MIN_VALUE;
            this.involved.clear();
        }
    }
}

