/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class MinOpImage
extends PointOpImage {
    private static long negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    private static byte[] byteTable = null;
    private static SoftReference softRef = null;

    private synchronized void allocByteTable() {
        if (softRef == null || softRef.get() == null) {
            byteTable = new byte[65536];
            softRef = new SoftReference<byte[]>(byteTable);
            boolean idx = false;
            for (int i1 = 0; i1 < 256; ++i1) {
                int i2;
                int base = i1 << 8;
                for (i2 = 0; i2 < i1; ++i2) {
                    MinOpImage.byteTable[base + i2] = (byte)i2;
                }
                for (i2 = i1; i2 < 256; ++i2) {
                    MinOpImage.byteTable[base + i2] = (byte)i1;
                }
            }
        }
    }

    public MinOpImage(RenderedImage source1, RenderedImage source2, Map config, ImageLayout layout) {
        super(source1, source2, layout, config, true);
        if (this.sampleModel.getTransferType() == 0) {
            this.allocByteTable();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSource(0).getColorModel());
        RasterAccessor s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSource(1).getColorModel());
        RasterAccessor d2 = new RasterAccessor(dest, destRect, formatTags[2], this.getColorModel());
        switch (d2.getDataType()) {
            case 0: {
                this.computeRectByte(s1, s2, d2);
                break;
            }
            case 1: {
                this.computeRectUShort(s1, s2, d2);
                break;
            }
            case 2: {
                this.computeRectShort(s1, s2, d2);
                break;
            }
            case 3: {
                this.computeRectInt(s1, s2, d2);
                break;
            }
            case 4: {
                this.computeRectFloat(s1, s2, d2);
                break;
            }
            case 5: {
                this.computeRectDouble(s1, s2, d2);
            }
        }
        if (d2.isDataCopy()) {
            d2.clampDataArrays();
            d2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        byte[][] s1Data = src1.getByteDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        byte[][] s2Data = src2.getByteDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            byte[] s1 = s1Data[b2];
            byte[] s2 = s2Data[b2];
            byte[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[b2];
            int s2LineOffset = s2BandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                int dstEnd = dPixelOffset + dwidth * dPixelStride;
                while (dPixelOffset < dstEnd) {
                    int i1 = s1[s1PixelOffset] & 0xFF;
                    int i2 = s2[s2PixelOffset] & 0xFF;
                    d2[dPixelOffset] = byteTable[(i1 << 8) + i2];
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            short[] s1 = s1Data[b2];
            short[] s2 = s2Data[b2];
            short[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[b2];
            int s2LineOffset = s2BandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = this.minUShort(s1[s1PixelOffset], s2[s2PixelOffset]);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        short[][] s1Data = src1.getShortDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        short[][] s2Data = src2.getShortDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            short[] s1 = s1Data[b2];
            short[] s2 = s2Data[b2];
            short[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[b2];
            int s2LineOffset = s2BandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = this.minShort(s1[s1PixelOffset], s2[s2PixelOffset]);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        int[][] s1Data = src1.getIntDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        int[][] s2Data = src2.getIntDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            int[] s1 = s1Data[b2];
            int[] s2 = s2Data[b2];
            int[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[b2];
            int s2LineOffset = s2BandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = this.minInt(s1[s1PixelOffset], s2[s2PixelOffset]);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        float[][] s1Data = src1.getFloatDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        float[][] s2Data = src2.getFloatDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            float[] s1 = s1Data[b2];
            float[] s2 = s2Data[b2];
            float[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[b2];
            int s2LineOffset = s2BandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = MinOpImage.minFloat(s1[s1PixelOffset], s2[s2PixelOffset]);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor src1, RasterAccessor src2, RasterAccessor dst) {
        int s1LineStride = src1.getScanlineStride();
        int s1PixelStride = src1.getPixelStride();
        int[] s1BandOffsets = src1.getBandOffsets();
        double[][] s1Data = src1.getDoubleDataArrays();
        int s2LineStride = src2.getScanlineStride();
        int s2PixelStride = src2.getPixelStride();
        int[] s2BandOffsets = src2.getBandOffsets();
        double[][] s2Data = src2.getDoubleDataArrays();
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        for (int b2 = 0; b2 < bands; ++b2) {
            double[] s1 = s1Data[b2];
            double[] s2 = s2Data[b2];
            double[] d2 = dData[b2];
            int s1LineOffset = s1BandOffsets[b2];
            int s2LineOffset = s2BandOffsets[b2];
            int dLineOffset = dBandOffsets[b2];
            for (int h2 = 0; h2 < dheight; ++h2) {
                int s1PixelOffset = s1LineOffset;
                int s2PixelOffset = s2LineOffset;
                int dPixelOffset = dLineOffset;
                s1LineOffset += s1LineStride;
                s2LineOffset += s2LineStride;
                dLineOffset += dLineStride;
                for (int w = 0; w < dwidth; ++w) {
                    d2[dPixelOffset] = MinOpImage.minDouble(s1[s1PixelOffset], s2[s2PixelOffset]);
                    s1PixelOffset += s1PixelStride;
                    s2PixelOffset += s2PixelStride;
                    dPixelOffset += dPixelStride;
                }
            }
        }
    }

    private final short minUShort(short a2, short b2) {
        return (a2 & 0xFFFF) < (b2 & 0xFFFF) ? a2 : b2;
    }

    private final short minShort(short a2, short b2) {
        return a2 <= b2 ? a2 : b2;
    }

    private final int minInt(int a2, int b2) {
        return a2 <= b2 ? a2 : b2;
    }

    public static float minFloat(float a2, float b2) {
        if (a2 != a2) {
            return a2;
        }
        if (a2 == 0.0f && b2 == 0.0f && (long)Float.floatToIntBits(b2) == negativeZeroFloatBits) {
            return b2;
        }
        return a2 <= b2 ? a2 : b2;
    }

    public static double minDouble(double a2, double b2) {
        if (a2 != a2) {
            return a2;
        }
        if (a2 == 0.0 && b2 == 0.0 && Double.doubleToLongBits(b2) == negativeZeroDoubleBits) {
            return b2;
        }
        return a2 <= b2 ? a2 : b2;
    }
}

