/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.swing;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressMeter
extends JFrame {
    private static final int MIN_PROGRESS = 0;
    private static final int MAX_PROGRESS = 100;
    JProgressBar progBar;
    JLabel label;
    private boolean preset;

    public ProgressMeter() {
        this("Progress");
    }

    public ProgressMeter(String title) {
        this(title, (String)null);
    }

    public ProgressMeter(String title, String labelText) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.progBar = new JProgressBar(0, 100);
        this.getContentPane().add((Component)this.progBar, "Center");
        this.label = new JLabel("  ");
        if (labelText != null && labelText.length() > 0) {
            this.label.setText(labelText);
        }
        this.getContentPane().add((Component)this.label, "South");
        this.setSize(400, 60);
        this.setLocationByPlatform(true);
    }

    public void setProgress(float progress) {
        final int barValue = (int)Math.ceil(100.0f * progress);
        if (this.isVisible()) {
            if (EventQueue.isDispatchThread()) {
                this.progBar.setValue(barValue);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMeter.this.progBar.setValue(barValue);
                    }
                });
            }
        } else {
            this.progBar.setValue(barValue);
            this.preset = true;
        }
    }

    public void setLabel(final String text) {
        if (!this.isVisible() || EventQueue.isDispatchThread()) {
            this.label.setText(text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressMeter.this.label.setText(text);
                }
            });
        }
    }

    @Override
    public void setVisible(boolean b2) {
        if (b2 && !this.preset) {
            this.progBar.setValue(0);
        }
        super.setVisible(b2);
    }
}

