/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.FA;

import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.constraints.nary.automata.FA.FiniteAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.Counter;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.CounterState;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.ICounter;
import org.chocosolver.solver.variables.IntVar;

public class CostAutomaton
extends FiniteAutomaton
implements ICostAutomaton {
    protected ArrayList<ICounter> counters = new ArrayList();

    public CostAutomaton() {
    }

    public CostAutomaton(IAutomaton auto) {
        super((FiniteAutomaton)auto);
    }

    public CostAutomaton(IAutomaton auto, List<ICounter> counters) {
        this(auto);
        this.counters.addAll(counters);
    }

    public CostAutomaton(IAutomaton auto, ICounter counter) {
        this(auto);
        this.counters.add(counter);
    }

    @Override
    public double getCost(int layer, int value) {
        ICounter zero = this.counters.get(0);
        return zero.cost(layer, value);
    }

    @Override
    public double getCostByState(int layer, int value, int state) {
        ICounter zero = this.counters.get(0);
        return zero.cost(layer, value, state);
    }

    @Override
    public double getCostByResource(int layer, int value, int counter) {
        ICounter aCounter = this.counters.get(counter);
        return aCounter.cost(layer, value);
    }

    @Override
    public int getNbResources() {
        return this.counters.size();
    }

    @Override
    public double getCostByResourceAndState(int layer, int value, int counter, int state) {
        ICounter aCounter = this.counters.get(counter);
        return aCounter.cost(layer, value, state);
    }

    @Override
    public List<ICounter> getCounters() {
        return this.counters;
    }

    public static ICostAutomaton makeSingleResource(IAutomaton pi, int[][][] costs, int inf, int sup) {
        CounterState c2 = new CounterState(costs, inf, sup);
        ArrayList<ICounter> tmp = new ArrayList<ICounter>();
        tmp.add(c2);
        return pi == null ? null : new CostAutomaton(pi, tmp);
    }

    public static ICostAutomaton makeSingleResource(IAutomaton pi, int[][] costs, int inf, int sup) {
        Counter c2 = new Counter(costs, inf, sup);
        ArrayList<ICounter> tmp = new ArrayList<ICounter>();
        tmp.add(c2);
        return pi == null ? null : new CostAutomaton(pi, tmp);
    }

    public static ICostAutomaton makeMultiResources(IAutomaton pi, int[][][] layer_value_resource, int[] infs, int[] sups) {
        int[][][] ordered = new int[infs.length][layer_value_resource.length][];
        ArrayList<ICounter> tmp = new ArrayList<ICounter>();
        for (int k = 0; k < infs.length; ++k) {
            for (int i = 0; i < layer_value_resource.length; ++i) {
                ordered[k][i] = new int[layer_value_resource[i].length];
                for (int j = 0; j < layer_value_resource[i].length; ++j) {
                    ordered[k][i][j] = layer_value_resource[i][j][k];
                }
            }
            tmp.add(new Counter(ordered[k], infs[k], sups[k]));
        }
        return pi == null ? null : new CostAutomaton(pi, tmp);
    }

    public static ICostAutomaton makeMultiResources(IAutomaton pi, int[][][][] layer_value_resource_state, int[] infs, int[] sups) {
        int[][][][] ordered = new int[infs.length][layer_value_resource_state.length][][];
        ArrayList<ICounter> tmp = new ArrayList<ICounter>();
        for (int k = 0; k < infs.length; ++k) {
            boolean stateDependant = true;
            for (int i = 0; i < layer_value_resource_state.length; ++i) {
                ordered[k][i] = new int[layer_value_resource_state[i].length][];
                for (int j = 0; j < layer_value_resource_state[i].length; ++j) {
                    ordered[k][i][j] = new int[layer_value_resource_state[i][j][k].length];
                    System.arraycopy(layer_value_resource_state[i][j][k], 0, ordered[k][i][j], 0, layer_value_resource_state[i][j][k].length);
                    if (ordered[k][i][j].length != 1) continue;
                    stateDependant = false;
                }
            }
            if (stateDependant) {
                tmp.add(new CounterState(ordered[k], infs[k], sups[k]));
                continue;
            }
            tmp.add(new Counter(ordered[k]));
        }
        return pi == null ? null : new CostAutomaton(pi, tmp);
    }

    public static ICostAutomaton makeMultiResources(IAutomaton auto, int[][][][] c2, IntVar[] z) {
        int[][] bounds = CostAutomaton.getBounds(z);
        return CostAutomaton.makeMultiResources(auto, c2, bounds[0], bounds[1]);
    }

    public static ICostAutomaton makeMultiResources(IAutomaton auto, int[][][] c2, IntVar[] z) {
        int[][] bounds = CostAutomaton.getBounds(z);
        return CostAutomaton.makeMultiResources(auto, c2, bounds[0], bounds[1]);
    }

    private static int[][] getBounds(IntVar[] cr) {
        int[][] bounds = new int[2][cr.length];
        for (int i = 0; i < cr.length; ++i) {
            bounds[0][i] = cr[i].getLB();
            bounds[1][i] = cr[i].getUB();
        }
        return bounds;
    }

    public void addCounter(ICounter c2) {
        this.counters.add(c2);
    }

    @Override
    public FiniteAutomaton clone() throws CloneNotSupportedException {
        CostAutomaton auto = (CostAutomaton)super.clone();
        auto.counters = new ArrayList();
        this.counters.forEach(auto::addCounter);
        return auto;
    }
}

