/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.DefaultCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.DisjunctiveTaskIntervalFilter;
import org.chocosolver.solver.constraints.nary.cumulative.HeightCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.NRJCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.NaiveTimeCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.PropCumulative;
import org.chocosolver.solver.constraints.nary.cumulative.PropGraphCumulative;
import org.chocosolver.solver.constraints.nary.cumulative.SweepCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.SweepHeiSortCumulFilter;
import org.chocosolver.solver.constraints.nary.cumulative.TimeCumulFilter;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.util.tools.ArrayUtils;

public class Cumulative
extends Constraint {
    public Cumulative(Task[] tasks, IntVar[] heights, IntVar capacity, boolean graphBased, Filter ... filters) {
        super("CUMULATIVE", Cumulative.createPropagators(tasks, heights, capacity, graphBased, (CumulFilter[])Arrays.stream(filters).map(f -> f.make(tasks.length)).toArray(CumulFilter[]::new)));
    }

    public Cumulative(Task[] tasks, IntVar[] heights, IntVar capacity, boolean graphBased, CumulFilter ... filters) {
        super("CUMULATIVE", Cumulative.createPropagators(tasks, heights, capacity, graphBased, filters));
    }

    private static Propagator[] createPropagators(Task[] tasks, IntVar[] heights, IntVar capa, boolean graphBased, CumulFilter ... filters) {
        int n = tasks.length;
        assert (n == heights.length && n > 0);
        IntVar[] vars = Cumulative.extract(tasks, heights, capa);
        IntVar[] s2 = Arrays.copyOfRange(vars, 0, n);
        IntVar[] d2 = Arrays.copyOfRange(vars, n, 2 * n);
        IntVar[] e2 = Arrays.copyOfRange(vars, 2 * n, 3 * n);
        IntVar[] h2 = Arrays.copyOfRange(vars, 3 * n, 4 * n);
        if (graphBased) {
            return new Propagator[]{new PropGraphCumulative(s2, d2, e2, h2, capa, false, filters), new PropGraphCumulative(s2, d2, e2, h2, capa, true, filters)};
        }
        return new Propagator[]{new PropCumulative(s2, d2, e2, h2, capa, filters), new PropCumulative(s2, d2, e2, h2, capa, filters)};
    }

    public static IntVar[] extract(Task[] tasks, IntVar[] heights, IntVar capa) {
        int n = tasks.length;
        IntVar[] starts = new IntVar[n];
        IntVar[] durations = new IntVar[n];
        IntVar[] ends = new IntVar[n];
        for (int i = 0; i < n; ++i) {
            starts[i] = tasks[i].getStart();
            durations[i] = tasks[i].getDuration();
            ends[i] = tasks[i].getEnd();
        }
        return ArrayUtils.append(starts, durations, ends, heights, {capa});
    }

    public static enum Filter {
        HEIGHTS{

            @Override
            public CumulFilter make(int n) {
                return new HeightCumulFilter(n);
            }
        }
        ,
        TIME{

            @Override
            public CumulFilter make(int n) {
                return new TimeCumulFilter(n);
            }
        }
        ,
        NAIVETIME{

            @Override
            public CumulFilter make(int n) {
                return new NaiveTimeCumulFilter(n);
            }
        }
        ,
        SWEEP{

            @Override
            public CumulFilter make(int n) {
                return new SweepCumulFilter(n);
            }
        }
        ,
        SWEEP_HEI_SORT{

            @Override
            public CumulFilter make(int n) {
                return new SweepHeiSortCumulFilter(n);
            }
        }
        ,
        NRJ{

            @Override
            public CumulFilter make(int n) {
                return new NRJCumulFilter(n);
            }
        }
        ,
        DISJUNCTIVE_TASK_INTERVAL{

            @Override
            public CumulFilter make(int n) {
                return new DisjunctiveTaskIntervalFilter(n);
            }
        }
        ,
        DEFAULT{

            @Override
            public CumulFilter make(int n) {
                return new DefaultCumulFilter(n);
            }
        };


        public abstract CumulFilter make(int var1);
    }
}

