/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.ToDoubleBiFunction;
import org.chocosolver.cutoffseq.GeometricalCutoffStrategy;
import org.chocosolver.cutoffseq.LubyCutoffStrategy;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveStrategy;
import org.chocosolver.solver.objective.OptimizationPolicy;
import org.chocosolver.solver.search.loop.monitors.IMonitorOpenNode;
import org.chocosolver.solver.search.restart.MonotonicRestartStrategy;
import org.chocosolver.solver.search.strategy.BoundSearch;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.IbexDecision;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainBest;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainLast;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMedian;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandomBound;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.RealValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.SetDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.SetValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphLexEdge;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphRandomEdge;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphLexNode;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphNodeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphRandomNode;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeOrEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeThenEdges;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.search.strategy.selectors.variables.ConflictHistorySearch;
import org.chocosolver.solver.search.strategy.selectors.variables.Cyclic;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDeg;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDegRef;
import org.chocosolver.solver.search.strategy.selectors.variables.FailureBased;
import org.chocosolver.solver.search.strategy.selectors.variables.FirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.GeneralizedMinDomVarSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.ImpactBased;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.Random;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.ConflictOrderingSearch;
import org.chocosolver.solver.search.strategy.strategy.GraphStrategy;
import org.chocosolver.solver.search.strategy.strategy.GreedyBranching;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.LastConflict;
import org.chocosolver.solver.search.strategy.strategy.MultiArmedBanditSequencer;
import org.chocosolver.solver.search.strategy.strategy.RealStrategy;
import org.chocosolver.solver.search.strategy.strategy.SetStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.bandit.MOSS;
import org.chocosolver.util.bandit.Static;
import org.chocosolver.util.tools.VariableUtils;

public class Search {
    public static <V extends Variable> AbstractStrategy<V> lastConflict(AbstractStrategy<V> formerSearch) {
        return Search.lastConflict(formerSearch, 1);
    }

    public static AbstractStrategy<IntVar> bestBound(AbstractStrategy<IntVar> formerSearch) {
        if (formerSearch == null) {
            throw new UnsupportedOperationException("the search strategy in parameter cannot be null! Consider using Search.defaultSearch(model)");
        }
        return new BoundSearch(formerSearch);
    }

    public static <V extends Variable> AbstractStrategy<V> lastConflict(AbstractStrategy<V> formerSearch, int k) {
        if (formerSearch == null) {
            throw new UnsupportedOperationException("the search strategy in parameter cannot be null! Consider using Search.defaultSearch(model)");
        }
        return new LastConflict<V>(formerSearch.getVariables()[0].getModel(), formerSearch, k);
    }

    public static <V extends Variable> AbstractStrategy<V> conflictOrderingSearch(AbstractStrategy<V> formerSearch) {
        return new ConflictOrderingSearch<V>(formerSearch.getVariables()[0].getModel(), formerSearch);
    }

    public static AbstractStrategy<?> greedySearch(AbstractStrategy<?> search) {
        return new GreedyBranching(search);
    }

    public static AbstractStrategy sequencer(AbstractStrategy ... searches) {
        return new StrategiesSequencer(searches);
    }

    public static SetStrategy setVarSearch(VariableSelector<SetVar> varS, SetValueSelector valS, boolean enforceFirst, SetVar ... sets) {
        return new SetStrategy(sets, varS, valS, enforceFirst);
    }

    public static SetStrategy setVarSearch(SetVar ... sets) {
        return Search.setVarSearch(new GeneralizedMinDomVarSelector<SetVar>(), new SetDomainMin(), true, sets);
    }

    public static AbstractStrategy<SetVar> domOverWDegSearch(SetVar ... vars) {
        return new SetStrategy(vars, new DomOverWDeg((Variable[])vars, 0L), new SetDomainMin(), true);
    }

    public static AbstractStrategy<SetVar> domOverWDegRefSearch(SetVar ... vars) {
        return new SetStrategy(vars, new DomOverWDegRef((Variable[])vars, 0L), new SetDomainMin(), true);
    }

    public static AbstractStrategy<SetVar> conflictHistorySearch(SetVar ... vars) {
        return new SetStrategy(vars, new ConflictHistorySearch((Variable[])vars, 0L), new SetDomainMin(), true);
    }

    public static AbstractStrategy<SetVar> failureRateBasedSearch(SetVar ... vars) {
        return new SetStrategy(vars, new FailureBased((Variable[])vars, 0L, 2), new SetDomainMin(), true);
    }

    public static AbstractStrategy<SetVar> failureLengthBasedSearch(SetVar ... vars) {
        return new SetStrategy(vars, new FailureBased((Variable[])vars, 0L, 4), new SetDomainMin(), true);
    }

    public static GraphStrategy graphVarSearch(VariableSelector<GraphVar> varS, GraphNodeOrEdgeSelector nodeOrEdgeS, GraphNodeSelector nodeS, GraphEdgeSelector edgeS, boolean enforceFirst, GraphVar ... graphs) {
        return new GraphStrategy(graphs, varS, nodeOrEdgeS, nodeS, edgeS, enforceFirst);
    }

    public static GraphStrategy graphVarSearch(GraphVar ... graphs) {
        return Search.graphVarSearch(new InputOrder<GraphVar>(graphs[0].getModel()), new GraphNodeThenEdges(), new GraphLexNode(), new GraphLexEdge(), true, graphs);
    }

    public static GraphStrategy randomGraphVarSearch(long seed, GraphVar ... graphs) {
        return Search.graphVarSearch(new Random<GraphVar>(seed), new GraphNodeThenEdges(), new GraphRandomNode(seed), new GraphRandomEdge(seed), true, graphs);
    }

    public static AbstractStrategy<IntVar> domOverWDegSearch(GraphVar ... vars) {
        return new GraphStrategy(vars, (VariableSelector)new DomOverWDeg((Variable[])vars, 0L), (GraphNodeOrEdgeSelector)new GraphNodeThenEdges(), (GraphNodeSelector)new GraphLexNode(), (GraphEdgeSelector)new GraphLexEdge(), true);
    }

    public static AbstractStrategy<IntVar> domOverWDegRefSearch(GraphVar ... vars) {
        return new GraphStrategy(vars, (VariableSelector)new DomOverWDegRef((Variable[])vars, 0L), (GraphNodeOrEdgeSelector)new GraphNodeThenEdges(), (GraphNodeSelector)new GraphLexNode(), (GraphEdgeSelector)new GraphLexEdge(), true);
    }

    public static AbstractStrategy<IntVar> conflictHistorySearch(GraphVar ... vars) {
        return new GraphStrategy(vars, (VariableSelector)new ConflictHistorySearch((Variable[])vars, 0L), (GraphNodeOrEdgeSelector)new GraphNodeThenEdges(), (GraphNodeSelector)new GraphLexNode(), (GraphEdgeSelector)new GraphLexEdge(), true);
    }

    public static RealStrategy realVarSearch(VariableSelector<RealVar> varS, RealValueSelector valS, double epsilon, boolean leftFirst, RealVar ... rvars) {
        return new RealStrategy(rvars, varS, valS, epsilon, leftFirst);
    }

    public static RealStrategy realVarSearch(double epsilon, RealVar ... reals) {
        return Search.realVarSearch(new Cyclic<RealVar>(), (RealValueSelector)new RealDomainMiddle(), epsilon, true, reals);
    }

    public static RealStrategy realVarSearch(VariableSelector<RealVar> varS, RealValueSelector valS, boolean leftFirst, RealVar ... rvars) {
        return Search.realVarSearch(varS, valS, Double.NaN, leftFirst, rvars);
    }

    public static RealStrategy realVarSearch(RealVar ... reals) {
        return Search.realVarSearch(new Cyclic<RealVar>(), (RealValueSelector)new RealDomainMiddle(), true, reals);
    }

    public static IntStrategy intVarSearch(VariableSelector<IntVar> varSelector, IntValueSelector valSelector, DecisionOperator<IntVar> decisionOperator, IntVar ... vars) {
        return new IntStrategy(vars, varSelector, valSelector, decisionOperator);
    }

    public static IntStrategy intVarSearch(VariableSelector<IntVar> varSelector, IntValueSelector valSelector, IntVar ... vars) {
        return Search.intVarSearch(varSelector, valSelector, DecisionOperatorFactory.makeIntEq(), vars);
    }

    public static AbstractStrategy<IntVar> intVarSearch(IntVar ... vars) {
        IntValueSelector valueSelector;
        Model model = vars[0].getModel();
        if (model.getResolutionPolicy() == ResolutionPolicy.SATISFACTION || !(model.getObjective() instanceof IntVar)) {
            valueSelector = new IntDomainMin();
        } else {
            valueSelector = new IntDomainBest();
            model.getSolver().attach(model.getSolver().defaultSolution());
            valueSelector = new IntDomainLast(model.getSolver().defaultSolution(), valueSelector, null);
        }
        return new IntStrategy(vars, new DomOverWDeg((Variable[])vars, 0L), valueSelector);
    }

    public static AbstractStrategy<IntVar> domOverWDegSearch(IntVar ... vars) {
        return new IntStrategy(vars, new DomOverWDeg((Variable[])vars, 0L), new IntDomainMin());
    }

    public static AbstractStrategy<IntVar> domOverWDegRefSearch(IntVar ... vars) {
        return new IntStrategy(vars, new DomOverWDegRef((Variable[])vars, 0L), new IntDomainMin());
    }

    public static AbstractStrategy<IntVar> activityBasedSearch(IntVar ... vars) {
        return new ActivityBased(vars);
    }

    public static AbstractStrategy<IntVar> conflictHistorySearch(IntVar ... vars) {
        return new IntStrategy(vars, new ConflictHistorySearch((Variable[])vars, 0L), new IntDomainMin());
    }

    public static AbstractStrategy<IntVar> failureRateBasedSearch(IntVar ... vars) {
        return new IntStrategy(vars, new FailureBased((Variable[])vars, 0L, 2), new IntDomainMin());
    }

    public static AbstractStrategy<IntVar> failureLengthBasedSearch(IntVar ... vars) {
        return new IntStrategy(vars, new FailureBased((Variable[])vars, 0L, 4), new IntDomainMin());
    }

    public static IntStrategy randomSearch(IntVar[] vars, long seed) {
        IntDomainRandom value = new IntDomainRandom(seed);
        IntDomainRandomBound bound = new IntDomainRandomBound(seed);
        IntValueSelector selector = var -> {
            if (var.hasEnumeratedDomain()) {
                return value.selectValue(var);
            }
            return bound.selectValue(var);
        };
        return Search.intVarSearch(new Random<IntVar>(seed), selector, vars);
    }

    public static AbstractStrategy<IntVar> objectiveStrategy(IntVar objective, OptimizationPolicy optPolicy) {
        return new ObjectiveStrategy(objective, optPolicy);
    }

    public static IntStrategy inputOrderLBSearch(IntVar ... vars) {
        return Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy inputOrderUBSearch(IntVar ... vars) {
        return Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), (IntValueSelector)new IntDomainMax(), vars);
    }

    public static IntStrategy minDomLBSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy minDomUBSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), (IntValueSelector)new IntDomainMax(), vars);
    }

    public static AbstractStrategy defaultSearch(Model model) {
        Solver r = model.getSolver();
        ArrayList<IntVar> livars = new ArrayList<IntVar>();
        ArrayList<SetVar> lsvars = new ArrayList<SetVar>();
        ArrayList<GraphVar> lgvars = new ArrayList<GraphVar>();
        ArrayList<RealVar> lrvars = new ArrayList<RealVar>();
        Variable[] variables = model.getVars();
        Variable objective = null;
        block6: for (Variable var : variables) {
            int type = var.getTypeAndKind();
            if ((type & 2) != 0) continue;
            int kind = type & 0x3F8;
            switch (kind) {
                case 8: 
                case 24: {
                    livars.add((IntVar)var);
                    continue block6;
                }
                case 32: {
                    lsvars.add((SetVar)var);
                    continue block6;
                }
                case 128: {
                    lgvars.add((GraphVar)var);
                    continue block6;
                }
                case 64: {
                    lrvars.add((RealVar)var);
                    continue block6;
                }
            }
        }
        if (r.getObjectiveManager().isOptimization()) {
            objective = (Variable)r.getObjectiveManager().getObjective();
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                lrvars.remove(objective);
            } else {
                assert ((objective.getTypeAndKind() & 8) != 0);
                livars.remove(objective);
            }
        }
        ArrayList<AbstractStrategy<IntVar>> strats = new ArrayList<AbstractStrategy<IntVar>>();
        if (livars.size() > 0) {
            strats.add(Search.intVarSearch(livars.toArray(new IntVar[0])));
        }
        if (lsvars.size() > 0) {
            strats.add(Search.setVarSearch(lsvars.toArray(new SetVar[0])));
        }
        if (lgvars.size() > 0) {
            strats.add(Search.graphVarSearch(lgvars.toArray(new GraphVar[0])));
        }
        if (lrvars.size() > 0) {
            strats.add(Search.realVarSearch(lrvars.toArray(new RealVar[0])));
        }
        if (objective != null) {
            boolean max;
            boolean bl = max = r.getObjectiveManager().getPolicy() == ResolutionPolicy.MAXIMIZE;
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                strats.add(Search.realVarSearch(new Cyclic<RealVar>(), max ? new RealDomainMax() : new RealDomainMin(), !max, (RealVar)objective));
            } else {
                strats.add(max ? Search.minDomUBSearch((IntVar)objective) : Search.minDomLBSearch((IntVar)objective));
            }
        }
        if (strats.isEmpty()) {
            strats.add(Search.minDomLBSearch(model.boolVar(true)));
        }
        return Search.lastConflict(Search.sequencer(strats.toArray(new AbstractStrategy[0])));
    }

    public static AbstractStrategy<Variable> ibexSolving(final Model model) {
        return new AbstractStrategy(model.getVars()){
            final IbexDecision dec;
            {
                super(variables);
                this.dec = new IbexDecision(model);
            }

            public Decision<Variable> getDecision() {
                if (this.dec.inUse()) {
                    return null;
                }
                return this.dec;
            }
        };
    }

    public static enum Restarts {
        NONE{

            @Override
            public void declare(Solver solver, int cutoff, double factor, int offset) {
            }
        }
        ,
        MONOTONIC{

            @Override
            public void declare(Solver solver, int cutoff, double factor, int offset) {
                solver.setRestarts(count -> solver.getFailCount() >= count, new MonotonicRestartStrategy(cutoff), offset);
                solver.setNoGoodRecordingFromRestarts();
            }
        }
        ,
        LUBY{

            @Override
            public void declare(Solver solver, int cutoff, double factor, int offset) {
                solver.setRestarts(count -> solver.getFailCount() >= count, new LubyCutoffStrategy(cutoff), offset);
                solver.setNoGoodRecordingFromRestarts();
            }
        }
        ,
        GEOMETRIC{

            @Override
            public void declare(Solver solver, int cutoff, double factor, int offset) {
                solver.setRestarts(count -> solver.getFailCount() >= count, new GeometricalCutoffStrategy(cutoff, factor), offset);
                solver.setNoGoodRecordingFromRestarts();
            }
        };


        public abstract void declare(Solver var1, int var2, double var3, int var5);
    }

    public static enum ValH {
        BEST{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                if (solver.getModel().getResolutionPolicy() == ResolutionPolicy.SATISFACTION) {
                    return MIN.make(solver, last);
                }
                return this.last(solver, new IntDomainBest(), last);
            }
        }
        ,
        BMIN{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                if (solver.getModel().getResolutionPolicy() == ResolutionPolicy.SATISFACTION) {
                    return MIN.make(solver, last);
                }
                return this.last(solver, new IntValueSelector(){
                    IntValueSelector sel = new IntDomainBest();

                    @Override
                    public int selectValue(IntVar var) {
                        if (var.getModel().getSolver().getSolutionCount() > 0L) {
                            this.sel = new IntDomainMin();
                        }
                        return this.sel.selectValue(var);
                    }
                }, last);
            }
        }
        ,
        BLAST{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                if (solver.getModel().getResolutionPolicy() == ResolutionPolicy.SATISFACTION) {
                    return MIN.make(solver, last);
                }
                Solution lastSol = solver.defaultSolution();
                return this.last(solver, new IntDomainBest((v, i) -> lastSol.exists() && lastSol.getIntVal((IntVar)v) == i.intValue()), last);
            }
        }
        ,
        DEFAULT{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return BEST.make(solver, last);
            }
        }
        ,
        MAX{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return this.last(solver, new IntDomainMax(), last);
            }
        }
        ,
        MED{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return this.last(solver, new IntDomainMedian(), last);
            }
        }
        ,
        MIDFLOOR{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return this.last(solver, new IntDomainMiddle(true), last);
            }
        }
        ,
        MIDCEIL{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return this.last(solver, new IntDomainMiddle(false), last);
            }
        }
        ,
        MIN{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return this.last(solver, new IntDomainMin(), last);
            }
        }
        ,
        RAND{

            @Override
            public IntValueSelector make(Solver solver, boolean last) {
                return this.last(solver, new IntDomainRandom(solver.getModel().getSeed()), last);
            }
        };


        public abstract IntValueSelector make(Solver var1, boolean var2);

        IntValueSelector last(Solver solver, IntValueSelector selector, boolean last) {
            if (last) {
                Model model = solver.getModel();
                if (model.getResolutionPolicy() == ResolutionPolicy.SATISFACTION) {
                    return selector;
                }
                model.getSolver().attach(model.getSolver().defaultSolution());
                return new IntDomainLast(model.getSolver().defaultSolution(), selector, null);
            }
            return selector;
        }
    }

    public static enum VarH {
        ABS{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return ACTIVITY.make(solver, vars, ValH.DEFAULT, flushThs, last);
            }
        }
        ,
        ACTIVITY{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                Model model = solver.getModel();
                return new ActivityBased(model, vars, valueSelector == ValH.DEFAULT ? null : valueSelector.make(solver, last), 0.999, 0.2, 8, 1, model.getSeed());
            }
        }
        ,
        CHS{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new IntStrategy(vars, new ConflictHistorySearch((Variable[])vars, solver.getModel().getSeed(), flushThs), valueSelector.make(solver, last));
            }
        }
        ,
        DOM{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(solver.getModel()), valueSelector.make(solver, last), vars);
            }
        }
        ,
        DOMWDEG{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new IntStrategy(vars, new DomOverWDeg((Variable[])vars, solver.getModel().getSeed(), flushThs), valueSelector.make(solver, last));
            }
        }
        ,
        DOMWDEGR{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new IntStrategy(vars, new DomOverWDegRef((Variable[])vars, solver.getModel().getSeed(), flushThs), valueSelector.make(solver, last));
            }
        }
        ,
        DEFAULT{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return Search.defaultSearch(solver.getModel());
            }
        }
        ,
        FRBA{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new IntStrategy(vars, new FailureBased((Variable[])vars, solver.getModel().getSeed(), 2), valueSelector.make(solver, last));
            }
        }
        ,
        FLBA{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new IntStrategy(vars, new FailureBased((Variable[])vars, solver.getModel().getSeed(), 4), valueSelector.make(solver, last));
            }
        }
        ,
        IBS{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return IMPACT.make(solver, vars, ValH.DEFAULT, flushThs, last);
            }
        }
        ,
        IMPACT{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new ImpactBased(vars, valueSelector == ValH.DEFAULT ? null : valueSelector.make(solver, last), 2, 512, 2048, solver.getModel().getSeed(), false);
            }
        }
        ,
        INPUT{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return Search.intVarSearch(new InputOrder<IntVar>(solver.getModel()), valueSelector.make(solver, last), vars);
            }
        }
        ,
        RAND{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return Search.intVarSearch(new Random<IntVar>(solver.getModel().getSeed()), valueSelector.make(solver, last), vars);
            }
        }
        ,
        MAB_CHS_DWDEG_STATIC{

            @Override
            public AbstractStrategy<IntVar> make(Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                return new MultiArmedBanditSequencer<IntVar>(new AbstractStrategy[]{CHS.make(solver, vars, valueSelector, flushThs, last), DOMWDEG.make(solver, vars, valueSelector, flushThs, last)}, new Static(new double[]{0.7, 0.3}, new java.util.Random(solver.getModel().getSeed())), (a2, t) -> 0.0);
            }
        }
        ,
        MAB_CHS_DWDEG_MOSS{

            @Override
            public AbstractStrategy<IntVar> make(final Solver solver, IntVar[] vars, ValH valueSelector, int flushThs, boolean last) {
                long[] pat = new long[]{0L, 0L};
                final HashSet selected = new HashSet();
                ToDoubleBiFunction<Integer, Integer> reward = (a2, t) -> {
                    double r = Math.log(solver.getNodeCount() - pat[0]) / Math.log(VariableUtils.searchSpaceSize(selected.iterator()));
                    pat[0] = solver.getNodeCount();
                    pat[1] = solver.getSolutionCount();
                    selected.clear();
                    return r;
                };
                solver.plugMonitor(new IMonitorOpenNode(){

                    @Override
                    public void afterOpenNode() {
                        selected.add((IntVar)solver.getDecisionPath().getLastDecision().getDecisionVariable());
                    }
                });
                return new MultiArmedBanditSequencer<IntVar>(new AbstractStrategy[]{CHS.make(solver, vars, valueSelector, flushThs, last), DOMWDEG.make(solver, vars, valueSelector, flushThs, last)}, new MOSS(2), reward);
            }
        };


        public abstract AbstractStrategy<IntVar> make(Solver var1, IntVar[] var2, ValH var3, int var4, boolean var5);
    }
}

