/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphNodeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeOrEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.GraphVar;

public class GraphStrategy<G extends GraphVar<?>>
extends AbstractStrategy<G> {
    protected VariableSelector<G> varSelector;
    private final GraphNodeOrEdgeSelector<G> nodeOrEdgeSelector;
    protected GraphNodeSelector<G> nodeSelector;
    protected GraphEdgeSelector<G> edgeSelector;
    protected GraphDecisionOperator operator;

    public GraphStrategy(G[] scope, VariableSelector<G> varSelector, GraphNodeOrEdgeSelector<G> nodeOrEdgeSelector, GraphNodeSelector<G> nodeSelector, GraphEdgeSelector<G> edgeSelector, boolean enforceFirst) {
        super(scope);
        this.varSelector = varSelector;
        this.nodeOrEdgeSelector = nodeOrEdgeSelector;
        this.nodeSelector = nodeSelector;
        this.edgeSelector = edgeSelector;
        this.operator = enforceFirst ? DecisionOperatorFactory.makeGraphEnforce() : DecisionOperatorFactory.makeGraphRemove();
    }

    @Override
    public Decision<G> getDecision() {
        GraphVar variable = (GraphVar)this.varSelector.getVariable((GraphVar[])this.vars);
        return this.computeDecision((G)variable);
    }

    @Override
    public Decision<G> computeDecision(G g2) {
        if (g2 == null) {
            return null;
        }
        assert (!g2.isInstantiated());
        if (this.nodeOrEdgeSelector.nextIsNode(g2)) {
            return g2.getModel().getSolver().getDecisionPath().makeGraphNodeDecision(g2, this.operator, this.nodeSelector.selectNode(g2));
        }
        int[] edge = this.edgeSelector.selectEdge(g2);
        assert (edge.length == 2);
        return g2.getModel().getSolver().getDecisionPath().makeGraphEdgeDecision(g2, this.operator, edge[0], edge[1]);
    }
}

