/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.set.PropCardinality;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.impl.scheduler.SetEvtScheduler;
import org.chocosolver.solver.variables.view.AbstractView;
import org.chocosolver.util.iterators.EvtScheduler;

public abstract class SetView<V extends Variable>
extends AbstractView<V>
implements SetVar {
    protected IntVar cardinality = null;

    protected SetView(String name, V ... variables) {
        super(name, variables);
    }

    protected abstract boolean doRemoveSetElement(int var1) throws ContradictionException;

    protected abstract boolean doForceSetElement(int var1) throws ContradictionException;

    @Override
    public boolean force(int element, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (!this.getLB().contains(element) && this.doForceSetElement(element)) {
            SetEventType e2 = SetEventType.ADD_TO_KER;
            this.notifyPropagators(e2, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int element, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.getUB().contains(element) && this.doRemoveSetElement(element)) {
            SetEventType e2 = SetEventType.REMOVE_FROM_ENVELOPE;
            this.notifyPropagators(e2, cause);
            return true;
        }
        return false;
    }

    @Override
    public void createDelta() {
        for (Variable v : this.getVariables()) {
            v.createDelta();
        }
    }

    @Override
    public int getTypeAndKind() {
        return 36;
    }

    protected EvtScheduler createScheduler() {
        return new SetEvtScheduler();
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        throw new UnsupportedOperationException("SetView does not support explanation.");
    }

    @Override
    public void explain(int p, ExplanationForSignedClause clause) {
        throw new UnsupportedOperationException("SetView does not support explanation.");
    }

    @Override
    public IntVar getCard() {
        if (!this.hasCard()) {
            int lbc;
            int ubc = this.getUB().size();
            if (ubc == (lbc = this.getLB().size())) {
                this.cardinality = this.model.intVar(ubc);
            } else {
                this.cardinality = this.model.intVar(this.name + ".card", lbc, ubc);
                new Constraint("SETCARD", new PropCardinality(this, this.cardinality)).post();
            }
        }
        return this.cardinality;
    }

    @Override
    public boolean hasCard() {
        return this.cardinality != null;
    }

    @Override
    public void setCard(IntVar card) {
        if (!this.hasCard()) {
            this.cardinality = card;
            new Constraint("SETCARD", new PropCardinality(this, card)).post();
        } else {
            this.model.arithm(this.cardinality, "=", card).post();
        }
    }
}

