/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.dominance;

import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;

public class AlphaDominatorsFinder
extends AbstractLengauerTarjanDominatorsFinder {
    private final int[] size;
    private final int[] child;

    public AlphaDominatorsFinder(int s2, DirectedGraph g2) {
        super(s2, g2);
        this.size = new int[this.n];
        this.child = new int[this.n];
    }

    @Override
    protected void initParams(boolean inverseGraph) {
        super.initParams(inverseGraph);
        for (int i = 0; i < this.n; ++i) {
            this.size[i] = 0;
            this.child[i] = this.root;
        }
    }

    @Override
    protected void link(int v, int w) {
        int s2 = w;
        while (this.semi[this.label[w]] < this.semi[this.label[this.child[s2]]]) {
            if (this.size[s2] + this.size[this.child[this.child[s2]]] >= 2 * this.size[this.child[s2]]) {
                this.ancestor[this.child[s2]] = s2;
                this.child[s2] = this.child[this.child[s2]];
                continue;
            }
            this.size[this.child[s2]] = this.size[s2];
            this.ancestor[s2] = this.child[s2];
            s2 = this.ancestor[s2];
        }
        this.label[s2] = this.label[w];
        this.size[v] = this.size[v] + this.size[w];
        if (this.size[v] < 2 * this.size[w]) {
            int k = s2;
            s2 = this.child[v];
            this.child[v] = k;
        }
        while (s2 != this.root) {
            this.ancestor[s2] = v;
            s2 = this.child[s2];
        }
    }

    @Override
    protected int eval(int v) {
        if (this.ancestor[v] == -1) {
            return this.label[v];
        }
        this.compress(v);
        if (this.semi[this.label[this.ancestor[v]]] >= this.semi[this.label[v]]) {
            return this.label[v];
        }
        return this.label[this.ancestor[v]];
    }

    @Override
    protected void compress(int v) {
        int k = v;
        this.list.resetQuick();
        while (this.ancestor[this.ancestor[k]] != -1) {
            this.list.add(k);
            k = this.ancestor[k];
        }
        for (k = this.list.size() - 1; k >= 0; --k) {
            v = this.list.get(k);
            if (this.semi[this.label[this.ancestor[v]]] < this.semi[this.label[v]]) {
                this.label[v] = this.label[this.ancestor[v]];
            }
            this.ancestor[v] = this.ancestor[this.ancestor[v]];
        }
    }
}

