/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.structure.IndexedObject;
import org.chocosolver.util.iterators.DisposableIntIterator;

public class StoredIndexedBipartiteSet {
    protected int[] list;
    protected int[] position;
    protected IndexedObject[] idxToObjects;
    protected IStateInt last;
    protected BipartiteSetIterator _cachedIterator;

    public StoredIndexedBipartiteSet(IEnvironment environment, int[] values) {
        this.buildList(environment, values);
    }

    public void buildList(IEnvironment environment, int[] values) {
        int i;
        this.list = values;
        int maxElt = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] <= maxElt) continue;
            maxElt = values[i];
        }
        this.position = new int[maxElt + 1];
        for (i = 0; i < values.length; ++i) {
            this.position[values[i]] = i;
        }
        this.last = environment.makeInt(this.list.length - 1);
    }

    public final int size() {
        return this.last.get() + 1;
    }

    public final boolean isEmpty() {
        return this.last.get() == -1;
    }

    public void remove(int object) {
        if (this.contains(object)) {
            int idxToRem = this.position[object];
            if (idxToRem == this.last.get()) {
                this.last.add(-1);
            } else {
                int temp = this.list[this.last.get()];
                this.list[this.last.get()] = object;
                this.list[idxToRem] = temp;
                this.position[object] = this.last.get();
                this.position[temp] = idxToRem;
                this.last.add(-1);
            }
        }
    }

    public boolean contains(int object) {
        return this.position[object] <= this.last.get();
    }

    public final DisposableIntIterator getIterator() {
        if (this._cachedIterator == null || this._cachedIterator.isNotReusable()) {
            this._cachedIterator = new BipartiteSetIterator();
        }
        this._cachedIterator.init(this.list, this.position, this.last, this.idxToObjects);
        return this._cachedIterator;
    }

    public final String pretty() {
        StringBuilder s2 = new StringBuilder("[");
        for (int i = 0; i <= this.last.get(); ++i) {
            s2.append(this.list[i]).append(i == this.last.get() ? "" : ",");
        }
        return s2.append(']').toString();
    }

    public final int[] _getStructure() {
        return this.list;
    }

    protected static class BipartiteSetIterator
    extends DisposableIntIterator {
        private int[] list;
        private int[] position;
        private IndexedObject[] idxToObjects;
        private IStateInt last;
        private int nlast;
        private int idx;

        protected BipartiteSetIterator() {
        }

        public void init(int[] aList, int[] aPosition, IStateInt aLast, IndexedObject[] anIdxToObjects) {
            super.init();
            this.idx = 0;
            this.list = aList;
            this.position = aPosition;
            this.idxToObjects = anIdxToObjects;
            this.last = aLast;
            this.nlast = this.last.get();
        }

        @Override
        public boolean hasNext() {
            return this.idx <= this.nlast;
        }

        @Override
        public int next() {
            return this.list[this.idx++];
        }

        public IndexedObject nextObject() {
            return this.idxToObjects[this.list[this.idx++]];
        }

        @Override
        public void remove() {
            --this.idx;
            int idxToRem = this.idx;
            if (idxToRem == this.nlast) {
                this.last.add(-1);
                --this.nlast;
            } else {
                int temp = this.list[this.nlast];
                this.list[this.nlast] = this.list[idxToRem];
                this.list[idxToRem] = temp;
                this.position[this.list[this.nlast]] = this.last.get();
                this.position[temp] = idxToRem;
                this.last.add(-1);
                --this.nlast;
            }
        }
    }
}

