/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Set;
import javax.measure.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.util.NameFactory;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.factory.Hints;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public abstract class AbstractCachedAuthorityFactory
extends AbstractAuthorityFactory
implements AuthorityFactory,
CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
BufferedFactory {
    protected ObjectCache cache;
    ObjectCache findCache;
    protected ReferencingFactoryContainer factories;

    protected AbstractCachedAuthorityFactory(int priority) {
        this(priority, ObjectCaches.create("weak", 50), ReferencingFactoryContainer.instance(null));
    }

    protected AbstractCachedAuthorityFactory(int priority, Hints hints) {
        this(priority, ObjectCaches.create(hints), ReferencingFactoryContainer.instance(hints));
    }

    protected AbstractCachedAuthorityFactory(int priority, ObjectCache cache, ReferencingFactoryContainer container) {
        super(priority);
        this.factories = container;
        this.cache = cache;
        this.findCache = ObjectCaches.create("weak", 0);
    }

    final void completeHints() {
        this.hints.put(Hints.DATUM_AUTHORITY_FACTORY, this);
        this.hints.put(Hints.CS_AUTHORITY_FACTORY, this);
        this.hints.put(Hints.CRS_AUTHORITY_FACTORY, this);
        this.hints.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this);
    }

    protected String toKey(String code) {
        return ObjectCaches.toKey(this.getAuthority(), code);
    }

    @Override
    protected String trimAuthority(String code) {
        GenericName name = NameFactory.create(code = code.trim());
        GenericName scope = name.scope().name();
        if (scope == null) {
            return code;
        }
        if (Citations.identifierMatches(this.getAuthority(), scope.toString())) {
            return name.tip().toString().trim();
        }
        return code;
    }

    protected NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code, ClassCastException cause) {
        NoSuchAuthorityCodeException exception = this.noSuchAuthorityCode(type, code);
        exception.initCause(cause);
        return exception;
    }

    @Override
    public abstract Citation getAuthority();

    public Set getAuthorityCodes(Class type) throws FactoryException {
        Set codes = (Set)this.cache.get(type);
        if (codes == null) {
            try {
                this.cache.writeLock(type);
                codes = (Set)this.cache.peek(type);
                if (codes == null) {
                    codes = this.generateAuthorityCodes(type);
                    this.cache.put(type, codes);
                }
            }
            finally {
                this.cache.writeUnLock(type);
            }
        }
        return codes;
    }

    protected abstract Set generateAuthorityCodes(Class var1) throws FactoryException;

    @Override
    public abstract InternationalString getDescriptionText(String var1) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        String key = this.toKey(code);
        IdentifiedObject obj = (IdentifiedObject)this.cache.get(key);
        if (obj == null) {
            try {
                this.cache.writeLock(key);
                obj = (IdentifiedObject)this.cache.peek(key);
                if (obj == null) {
                    obj = this.generateObject(code);
                    this.cache.put(key, obj);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return obj;
    }

    protected abstract IdentifiedObject generateObject(String var1) throws FactoryException;

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (CompoundCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CompoundCRS.class, code, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (CoordinateReferenceSystem)this.cache.peek(key);
                if (crs == null) {
                    crs = this.generateCoordinateReferenceSystem(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    protected abstract CoordinateReferenceSystem generateCoordinateReferenceSystem(String var1) throws FactoryException;

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (DerivedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(DerivedCRS.class, code, exception);
        }
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (EngineeringCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringCRS.class, code, exception);
        }
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeocentricCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeocentricCRS.class, code, exception);
        }
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeographicCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeographicCRS.class, code, exception);
        }
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ImageCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageCRS.class, code, exception);
        }
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ProjectedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ProjectedCRS.class, code, exception);
        }
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (TemporalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalCRS.class, code, exception);
        }
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (VerticalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCRS.class, code, exception);
        }
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CartesianCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CartesianCS.class, code, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateSystem cs = (CoordinateSystem)this.cache.get(key);
        if (cs == null) {
            try {
                this.cache.writeLock(key);
                cs = (CoordinateSystem)this.cache.peek(key);
                if (cs == null) {
                    cs = this.generateCoordinateSystem(code);
                    this.cache.put(key, cs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return cs;
    }

    protected abstract CoordinateSystem generateCoordinateSystem(String var1) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateSystemAxis axis = (CoordinateSystemAxis)this.cache.get(key);
        if (axis == null) {
            try {
                this.cache.writeLock(key);
                axis = (CoordinateSystemAxis)this.cache.peek(key);
                if (axis == null) {
                    axis = this.generateCoordinateSystemAxis(code);
                    this.cache.put(key, axis);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return axis;
    }

    protected abstract CoordinateSystemAxis generateCoordinateSystemAxis(String var1) throws FactoryException;

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CylindricalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CylindricalCS.class, code, exception);
        }
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (EllipsoidalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EllipsoidalCS.class, code, exception);
        }
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (PolarCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PolarCS.class, code, exception);
        }
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (SphericalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(SphericalCS.class, code, exception);
        }
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (TimeCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TimeCS.class, code, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        String key = this.toKey(code);
        Unit<?> unit = (Unit<?>)this.cache.get(key);
        if (unit == null) {
            try {
                this.cache.writeLock(key);
                unit = (Unit)this.cache.peek(key);
                if (unit == null) {
                    unit = this.generateUnit(code);
                    this.cache.put(key, unit);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return unit;
    }

    protected abstract Unit<?> generateUnit(String var1) throws FactoryException;

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (VerticalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCS.class, code, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum createDatum(String code) throws FactoryException {
        String key = this.toKey(code);
        Datum datum = (Datum)this.cache.get(key);
        if (datum == null) {
            try {
                this.cache.writeLock(key);
                datum = (Datum)this.cache.peek(key);
                if (datum == null) {
                    datum = this.generateDatum(code);
                    this.cache.put(key, datum);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return datum;
    }

    protected abstract Datum generateDatum(String var1) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        String key = this.toKey(code);
        Ellipsoid ellipsoid = (Ellipsoid)this.cache.get(key);
        if (ellipsoid == null) {
            try {
                this.cache.writeLock(key);
                ellipsoid = (Ellipsoid)this.cache.peek(key);
                if (ellipsoid == null) {
                    ellipsoid = this.generateEllipsoid(code);
                    this.cache.put(key, ellipsoid);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return ellipsoid;
    }

    protected abstract Ellipsoid generateEllipsoid(String var1) throws FactoryException;

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (EngineeringDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringDatum.class, code, exception);
        }
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (GeodeticDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeodeticDatum.class, code, exception);
        }
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (ImageDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageDatum.class, code, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        String key = this.toKey(code);
        PrimeMeridian datum = (PrimeMeridian)this.cache.get(key);
        if (datum == null) {
            try {
                this.cache.writeLock(key);
                datum = (PrimeMeridian)this.cache.peek(key);
                if (datum == null) {
                    datum = this.generatePrimeMeridian(code);
                    this.cache.put(key, datum);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return datum;
    }

    protected abstract PrimeMeridian generatePrimeMeridian(String var1) throws FactoryException;

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (TemporalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalDatum.class, code, exception);
        }
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (VerticalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalDatum.class, code, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateOperation operation = (CoordinateOperation)this.cache.get(key);
        if (operation == null) {
            try {
                this.cache.writeLock(key);
                operation = (CoordinateOperation)this.cache.peek(key);
                if (operation == null) {
                    operation = this.generateCoordinateOperation(code);
                    this.cache.put(key, operation);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return operation;
    }

    protected abstract CoordinateOperation generateCoordinateOperation(String var1) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        Object key = ObjectCaches.toKey(this.getAuthority(), sourceCode, targetCode);
        Set operations = (Set)this.cache.get(key);
        if (operations == null) {
            try {
                this.cache.writeLock(key);
                operations = (Set)this.cache.peek(key);
                if (operations == null) {
                    operations = this.generateFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
                    this.cache.put(key, operations);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return operations;
    }

    protected abstract Set generateFromCoordinateReferenceSystemCodes(String var1, String var2) throws FactoryException;

    @Override
    public void dispose() throws FactoryException {
        this.cache = null;
        this.factories = null;
    }

    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new CachedFinder(type);
    }

    private final class CachedFinder
    extends IdentifiedObjectFinder {
        CachedFinder(Class type) {
            super(AbstractCachedAuthorityFactory.this, type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = (IdentifiedObject)AbstractCachedAuthorityFactory.this.findCache.get(object);
            if (candidate != null) {
                return candidate;
            }
            try {
                AbstractCachedAuthorityFactory.this.findCache.writeLock(object);
                IdentifiedObject found = super.find(object);
                if (found == null) {
                    IdentifiedObject identifiedObject = null;
                    return identifiedObject;
                }
                candidate = (IdentifiedObject)AbstractCachedAuthorityFactory.this.findCache.peek(object);
                if (candidate == null) {
                    AbstractCachedAuthorityFactory.this.findCache.put(object, found);
                    IdentifiedObject identifiedObject = found;
                    return identifiedObject;
                }
                IdentifiedObject identifiedObject = candidate;
                return identifiedObject;
            }
            finally {
                AbstractCachedAuthorityFactory.this.findCache.writeUnLock(object);
            }
        }

        @Override
        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = (IdentifiedObject)AbstractCachedAuthorityFactory.this.findCache.get(object);
            if (candidate != null) {
                return this.getIdentifier(candidate);
            }
            return super.findIdentifier(object);
        }
    }
}

