/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.text.Format;
import java.util.Map;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Cursor;
import org.knowm.xchart.internal.chartpart.Formatter_Custom;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.lines.SeriesLines;

public class PlotContent_XY<ST extends XYStyler, S extends XYSeries>
extends PlotContent_<ST, S> {
    private final ST xyStyler;
    Cursor cursor;

    PlotContent_XY(Chart<ST, S> chart) {
        super(chart);
        this.xyStyler = (XYStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g2) {
        double xTickSpace = ((Styler)this.xyStyler).getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        double yTickSpace = ((Styler)this.xyStyler).getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), yTickSpace);
        double xMin = this.chart.getXAxis().getMin();
        double xMax = this.chart.getXAxis().getMax();
        Line2D.Double line = new Line2D.Double();
        if (((AxesChartStyler)this.xyStyler).isXAxisLogarithmic()) {
            xMin = Math.log10(xMin);
            xMax = Math.log10(xMax);
        }
        Map map = this.chart.getSeriesMap();
        for (XYSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            Axis yAxis = this.chart.getYAxis(series.getYAxisGroup());
            double yMin = yAxis.getMin();
            double yMax = yAxis.getMax();
            if (((AxesChartStyler)this.xyStyler).isYAxisLogarithmic()) {
                yMin = Math.log10(yMin);
                yMax = Math.log10(yMax);
            }
            double[] xData = series.getXData();
            double[] yData = series.getYData();
            double previousX = -1.7976931348623157E308;
            double previousY = -1.7976931348623157E308;
            double polygonStartX = -1.7976931348623157E308;
            double polygonStartY = -1.7976931348623157E308;
            double[] errorBars = series.getExtraValues();
            Path2D.Double path = null;
            Path2D.Double smoothPath = null;
            double yZeroTransform = this.getBounds().getHeight() - (yTopMargin + (0.0 - yMin) / (yMax - yMin) * yTickSpace);
            double yZeroOffset = yZeroTransform + this.getBounds().getY();
            for (int i = 0; i < xData.length; ++i) {
                boolean isSeriesStepLineOrStepArea;
                double next;
                double x = xData[i];
                if (((AxesChartStyler)this.xyStyler).isXAxisLogarithmic()) {
                    x = Math.log10(x);
                }
                if (Double.isNaN(next = yData[i])) {
                    g2.setColor(series.getFillColor());
                    this.closePathXY(g2, path, previousX, yZeroOffset, polygonStartX, polygonStartY);
                    path = null;
                    if (smoothPath != null) {
                        g2.setColor(series.getLineColor());
                        g2.setStroke(series.getLineStyle());
                        g2.draw(smoothPath);
                        smoothPath = null;
                    }
                    previousX = -1.7976931348623157E308;
                    previousY = -1.7976931348623157E308;
                    continue;
                }
                double yOrig = yData[i];
                double y = ((AxesChartStyler)this.xyStyler).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                    xTransform = this.getBounds().getWidth() / 2.0;
                }
                if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                    yTransform = this.getBounds().getHeight() / 2.0;
                }
                double xOffset = this.getBounds().getX() + xTransform;
                double yOffset = this.getBounds().getY() + yTransform;
                boolean isSeriesLineOrArea = XYSeries.XYSeriesRenderStyle.Line == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.Area == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.PolygonArea == series.getXYSeriesRenderStyle();
                boolean bl = isSeriesStepLineOrStepArea = XYSeries.XYSeriesRenderStyle.Step == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.StepArea == series.getXYSeriesRenderStyle();
                if ((isSeriesLineOrArea || isSeriesStepLineOrStepArea) && series.getLineStyle() != SeriesLines.NONE && previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                    g2.setColor(series.getLineColor());
                    g2.setStroke(series.getLineStyle());
                    if (isSeriesLineOrArea) {
                        if (series.isSmooth()) {
                            if (smoothPath == null) {
                                smoothPath = new Path2D.Double();
                                smoothPath.moveTo(previousX, previousY);
                            }
                            smoothPath.curveTo((previousX + xOffset) / 2.0, previousY, (previousX + xOffset) / 2.0, yOffset, xOffset, yOffset);
                        } else {
                            line.setLine(previousX, previousY, xOffset, yOffset);
                            g2.draw(line);
                        }
                    } else {
                        if (previousX != xOffset) {
                            line.setLine(previousX, previousY, xOffset, previousY);
                            g2.draw(line);
                        }
                        if (previousY != yOffset) {
                            line.setLine(xOffset, previousY, xOffset, yOffset);
                            g2.draw(line);
                        }
                    }
                }
                if (XYSeries.XYSeriesRenderStyle.Area == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.StepArea == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.PolygonArea == series.getXYSeriesRenderStyle()) {
                    if (previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                        if (path == null) {
                            path = new Path2D.Double();
                            if (XYSeries.XYSeriesRenderStyle.PolygonArea == series.getXYSeriesRenderStyle()) {
                                path.moveTo(previousX, previousY);
                                polygonStartX = previousX;
                                polygonStartY = previousY;
                            } else {
                                path.moveTo(previousX, yZeroOffset);
                                path.lineTo(previousX, previousY);
                            }
                        }
                        if (XYSeries.XYSeriesRenderStyle.Area == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.PolygonArea == series.getXYSeriesRenderStyle()) {
                            if (series.isSmooth()) {
                                path.curveTo((previousX + xOffset) / 2.0, previousY, (previousX + xOffset) / 2.0, yOffset, xOffset, yOffset);
                            } else {
                                path.lineTo(xOffset, yOffset);
                            }
                        } else {
                            if (previousX != xOffset) {
                                path.lineTo(xOffset, previousY);
                            }
                            if (previousY != yOffset) {
                                path.lineTo(xOffset, yOffset);
                            }
                        }
                    }
                    if (xOffset < previousX && XYSeries.XYSeriesRenderStyle.PolygonArea != series.getXYSeriesRenderStyle()) {
                        throw new RuntimeException("X-Data must be in ascending order for Area Charts!!!");
                    }
                }
                previousX = xOffset;
                previousY = yOffset;
                if (series.getMarker() != null) {
                    g2.setColor(series.getMarkerColor());
                    series.getMarker().paint(g2, xOffset, yOffset, ((Styler)this.xyStyler).getMarkerSize());
                }
                if (errorBars != null) {
                    double bottomValue;
                    double topValue;
                    double eb = errorBars[i];
                    if (((AxesChartStyler)this.xyStyler).isErrorBarsColorSeriesColor()) {
                        g2.setColor(series.getLineColor());
                    } else {
                        g2.setColor(((AxesChartStyler)this.xyStyler).getErrorBarsColor());
                    }
                    g2.setStroke(ERROR_BAR_STROKE);
                    if (((AxesChartStyler)this.xyStyler).isYAxisLogarithmic()) {
                        topValue = yOrig + eb;
                        topValue = Math.log10(topValue);
                    } else {
                        topValue = y + eb;
                    }
                    double topEBTransform = this.getBounds().getHeight() - (yTopMargin + (topValue - yMin) / (yMax - yMin) * yTickSpace);
                    double topEBOffset = this.getBounds().getY() + topEBTransform;
                    if (((AxesChartStyler)this.xyStyler).isYAxisLogarithmic()) {
                        bottomValue = yOrig - eb;
                        bottomValue = Math.log10(bottomValue);
                    } else {
                        bottomValue = y - eb;
                    }
                    double bottomEBTransform = this.getBounds().getHeight() - (yTopMargin + (bottomValue - yMin) / (yMax - yMin) * yTickSpace);
                    double bottomEBOffset = this.getBounds().getY() + bottomEBTransform;
                    line.setLine(xOffset, topEBOffset, xOffset, bottomEBOffset);
                    g2.draw(line);
                    line.setLine(xOffset - 3.0, bottomEBOffset, xOffset + 3.0, bottomEBOffset);
                    g2.draw(line);
                    line.setLine(xOffset - 3.0, topEBOffset, xOffset + 3.0, topEBOffset);
                    g2.draw(line);
                }
                if (((XYStyler)this.chart.getStyler()).isToolTipsEnabled()) {
                    this.toolTips.addData(xOffset, yOffset, this.chart.getXAxisFormat().format(x), this.chart.getYAxisFormat(series.getYAxisDecimalPattern()).format(yOrig));
                }
                if (!((XYStyler)this.xyStyler).isCursorEnabled()) continue;
                Format xFormat = ((XYStyler)this.xyStyler).getCustomCursorXDataFormattingFunction() == null ? this.chart.getXAxisFormat() : new Formatter_Custom(((XYStyler)this.xyStyler).getCustomCursorXDataFormattingFunction());
                Format yFormat = ((XYStyler)this.xyStyler).getCustomCursorYDataFormattingFunction() == null ? this.chart.getYAxisFormat(series.getYAxisDecimalPattern()) : new Formatter_Custom(((XYStyler)this.xyStyler).getCustomCursorYDataFormattingFunction());
                this.cursor.addData(xOffset, yOffset, xFormat.format(x), yFormat.format(yOrig), series.getName());
            }
            if (smoothPath != null) {
                g2.setColor(series.getLineColor());
                g2.setStroke(series.getLineStyle());
                g2.draw(smoothPath);
            }
            g2.setColor(series.getFillColor());
            this.closePathXY(g2, path, previousX, yZeroOffset, polygonStartX, polygonStartY);
        }
        if (((XYStyler)this.chart.getStyler()).isCursorEnabled()) {
            this.cursor.paint(g2);
        }
    }

    void closePathXY(Graphics2D g2, Path2D.Double path, double previousX, double yZeroOffset, double polygonStartX, double polygonStartY) {
        if (path != null) {
            if (polygonStartX != -1.7976931348623157E308) {
                path.lineTo(polygonStartX, polygonStartY);
            } else {
                path.lineTo(previousX, yZeroOffset);
            }
            path.closePath();
            g2.fill(path);
        }
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }
}

