/*
 * Decompiled with CFR 0.152.
 */
package scala.reflect.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StringOps$;
import scala.collection.convert.AsScalaExtensions;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.Directory;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\r\u001b\u0005\u0005B\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\te\u0001\u0011\t\u0011)A\u0005Q!)1\u0007\u0001C\u0001i!)1\u0006\u0001C!o!AQ\b\u0001EC\u0002\u0013\u0005c\bC\u0003K\u0001\u0011\u00053\nC\u0004Q\u0001\t\u0007I\u0011B)\t\r]\u0003\u0001\u0015!\u0003S\u0011\u0015A\u0006\u0001\"\u0001R\u0011\u0015I\u0006\u0001\"\u0001R\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015a\b\u0001\"\u0001~\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u00055\u0002\u0001\"\u0001\u0002&!9\u0011q\u0006\u0001\u0005\u0002\u0005E\"\u0001\u0004)mC&tg*[8GS2,'BA\u000e\u001d\u0003\tIwN\u0003\u0002\u001e=\u00059!/\u001a4mK\u000e$(\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0011j\u0011AG\u0005\u0003Ki\u0011A\"\u00112tiJ\f7\r\u001e$jY\u0016\fqA\\5p!\u0006$\b.F\u0001)!\tI\u0003'D\u0001+\u0015\tYC&\u0001\u0003gS2,'BA\u0017/\u0003\rq\u0017n\u001c\u0006\u0002_\u0005!!.\u0019<b\u0013\t\t$F\u0001\u0003QCRD\u0017\u0001\u00038j_B\u000bG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\t)d\u0007\u0005\u0002$\u0001!)ae\u0001a\u0001QU\t\u0001\b\u0005\u0002:w5\t!H\u0003\u0002\u001c]%\u0011AH\u000f\u0002\u0005\r&dW-A\u0007dC:|g.[2bYB\u000bG\u000f[\u000b\u0002\u007fA\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"A\u0011\u0010\u000e\u0003\rS!\u0001\u0012\u0011\u0002\rq\u0012xn\u001c;?\u0013\t1e$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$\u001f\u0003A)h\u000eZ3sYfLgnZ*pkJ\u001cW-F\u0001M!\rieJI\u0007\u0002=%\u0011qJ\b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000b\u0019\u0004\u0018\r\u001e5\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0018\u0002\t1\fgnZ\u0005\u0003\u0011R\u000baA\u001a9bi\"\u0004\u0013\u0001\u00028b[\u0016\fA\u0001]1uQ\u0006A\u0011MY:pYV$X-F\u00016\u0003%\u0019wN\u001c;bS:,'/F\u0001#\u0003\u0015Ig\u000e];u+\u0005\u0001\u0007CA\u001db\u0013\t\u0011'HA\u0006J]B,Ho\u0015;sK\u0006l\u0017AB8viB,H/F\u0001f!\tId-\u0003\u0002hu\taq*\u001e;qkR\u001cFO]3b[\u0006Q1/\u001b>f\u001fB$\u0018n\u001c8\u0016\u0003)\u00042!T6n\u0013\tagD\u0001\u0003T_6,\u0007CA'o\u0013\tygDA\u0002J]R\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002[\u00061Q-];bYN$\"\u0001^<\u0011\u00055+\u0018B\u0001<\u001f\u0005\u001d\u0011un\u001c7fC:DQ\u0001_\tA\u0002e\fA\u0001\u001e5biB\u0011QJ_\u0005\u0003wz\u00111!\u00118z\u0003-I7\u000fR5sK\u000e$xN]=\u0016\u0003Q\fA\u0002\\1ti6{G-\u001b4jK\u0012,\"!!\u0001\u0011\u00075\u000b\u0019!C\u0002\u0002\u0006y\u0011A\u0001T8oO\u0006A\u0011\u000e^3sCR|'/\u0006\u0002\u0002\fA)\u0011QBA\nE9\u0019Q*a\u0004\n\u0007\u0005Ea$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0011q\u0003\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011\u0011\u0003\u0010\u0002\u00151|wn[;q\u001d\u0006lW\rF\u0003#\u0003;\ty\u0002C\u0003Y+\u0001\u0007q\b\u0003\u0004\u0002\"U\u0001\r\u0001^\u0001\nI&\u0014Xm\u0019;pef\faa\u0019:fCR,GCAA\u0014!\ri\u0015\u0011F\u0005\u0004\u0003Wq\"\u0001B+oSR\fa\u0001Z3mKR,\u0017a\u00057p_.,\bOT1nKVs7\r[3dW\u0016$G#\u0002\u0012\u00024\u0005U\u0002\"\u0002-\u0019\u0001\u0004y\u0004BBA\u00111\u0001\u0007A\u000f")
public final class PlainNioFile
extends AbstractFile {
    private String canonicalPath;
    private final Path nioPath;
    private final String fpath;
    private volatile boolean bitmap$0;

    public Path nioPath() {
        return this.nioPath;
    }

    @Override
    public File file() {
        try {
            return this.nioPath().toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    private String canonicalPath$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.canonicalPath = super.canonicalPath();
                this.bitmap$0 = true;
            }
        }
        return this.canonicalPath;
    }

    @Override
    public String canonicalPath() {
        if (!this.bitmap$0) {
            return this.canonicalPath$lzycompute();
        }
        return this.canonicalPath;
    }

    @Override
    public Option<AbstractFile> underlyingSource() {
        None$ none$;
        FileSystem fileSystem = this.nioPath().getFileSystem();
        String string = fileSystem.provider().getScheme();
        if ("jar".equals(string)) {
            None$ none$2;
            java.util.Iterator<FileStore> fileStores = fileSystem.getFileStores().iterator();
            if (fileStores.hasNext()) {
                String jarPath = fileStores.next().name();
                try {
                    none$2 = new Some((Object)new PlainNioFile(Paths.get(StringOps$.MODULE$.stripSuffix$extension(jarPath, fileSystem.getSeparator()), new String[0])));
                }
                catch (InvalidPathException invalidPathException) {
                    none$2 = None$.MODULE$;
                }
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if ("jrt".equals(string)) {
            None$ none$3;
            if (this.nioPath().getNameCount() > 2 && this.nioPath().startsWith("/modules")) {
                Path moduleName = this.nioPath().getName(1);
                none$3 = new Some((Object)new PlainNioFile(Paths.get(System.getProperty("java.home"), "jmods", new StringBuilder(5).append(((Object)moduleName).toString()).append(".jmod").toString())));
            } else {
                none$3 = None$.MODULE$;
            }
            none$ = none$3;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String fpath() {
        return this.fpath;
    }

    @Override
    public String name() {
        return ((Object)this.nioPath().getFileName()).toString();
    }

    @Override
    public String path() {
        return ((Object)this.nioPath()).toString();
    }

    @Override
    public PlainNioFile absolute() {
        return new PlainNioFile(this.nioPath().toAbsolutePath());
    }

    @Override
    public AbstractFile container() {
        return new PlainNioFile(this.nioPath().getParent());
    }

    @Override
    public InputStream input() {
        return Files.newInputStream(this.nioPath(), new OpenOption[0]);
    }

    @Override
    public OutputStream output() {
        return Files.newOutputStream(this.nioPath(), new OpenOption[0]);
    }

    public Some<Object> sizeOption() {
        return new Some((Object)((int)Files.size(this.nioPath())));
    }

    public int hashCode() {
        return this.fpath().hashCode();
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof PlainNioFile) {
            PlainNioFile plainNioFile = (PlainNioFile)((Object)that);
            String string = this.fpath();
            String string2 = plainNioFile.fpath();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.nioPath(), new LinkOption[0]);
    }

    @Override
    public long lastModified() {
        return Files.getLastModifiedTime(this.nioPath(), new LinkOption[0]).toMillis();
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        try {
            java.util.Iterator<Path> it = Files.newDirectoryStream(this.nioPath()).iterator();
            return AsScalaExtensions.IteratorHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, it).asScala().map((Function1 & Serializable)x$3 -> new PlainNioFile((Path)x$3));
        }
        catch (NotDirectoryException notDirectoryException) {
            if (package$.MODULE$.Iterator() == null) {
                throw null;
            }
            return Iterator$.scala$collection$Iterator$$_empty;
        }
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        Path child = this.nioPath().resolve(name);
        if (Files.isDirectory(child, new LinkOption[0]) && directory || Files.isRegularFile(child, new LinkOption[0]) && !directory) {
            return new PlainNioFile(child);
        }
        return null;
    }

    @Override
    public void create() {
        if (!this.exists()) {
            Files.createFile(this.nioPath(), new FileAttribute[0]);
        }
    }

    @Override
    public void delete() {
        if (Files.isRegularFile(this.nioPath(), new LinkOption[0])) {
            Files.deleteIfExists(this.nioPath());
            return;
        }
        if (Files.isDirectory(this.nioPath(), new LinkOption[0])) {
            new Directory(this.nioPath().toFile()).deleteRecursively();
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        return new PlainNioFile(this.nioPath().resolve(name));
    }

    public PlainNioFile(Path nioPath) {
        this.nioPath = nioPath;
        Predef$.MODULE$.assert(nioPath != null);
        this.fpath = ((Object)nioPath.toAbsolutePath()).toString();
    }
}

