/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.Cell;
import fr.ird.osmose.ltl.LTLForcing;
import fr.ird.osmose.util.SimulationLinker;
import java.util.List;

public abstract class AbstractLTLForcing
extends SimulationLinker
implements LTLForcing {
    List<Integer>[][] icoordLTLGrid;
    List<Integer>[][] jcoordLTLGrid;
    double[] conversionFactor;
    private int nLTLStep;
    private double[][][] biomass;

    AbstractLTLForcing(int rank) {
        super(rank);
    }

    abstract double[][] getRawBiomass(int var1, int var2);

    abstract void readParameters();

    abstract void initLTLGrid();

    public int getIndexStepLTL(int iStepSimu) {
        return iStepSimu % this.nLTLStep;
    }

    @Override
    public void init() {
        this.nLTLStep = this.getConfiguration().getInt("ltl.nstep");
        int nPlk = this.getConfiguration().getNPlankton();
        this.conversionFactor = new double[nPlk];
        for (int iPlk = 0; iPlk < nPlk; ++iPlk) {
            if (!this.getConfiguration().isNull("plankton.conversion2tons.plk" + iPlk)) {
                this.conversionFactor[iPlk] = this.getConfiguration().getDouble("plankton.conversion2tons.plk" + iPlk);
                continue;
            }
            this.warning("Paramter plankton.conversion2tons.plk{0} not found (or set to null). Osmose assumes that LTL data for plankton group {1} is already expressed in tonne/km2 (or tonne/km3 for 3D dataset)", new Object[]{iPlk, this.getSimulation().getPlankton(iPlk).getName()});
            this.conversionFactor[iPlk] = 1.0;
        }
        this.readParameters();
        this.initLTLGrid();
        this.biomass = new double[nPlk][this.getGrid().get_ny()][this.getGrid().get_nx()];
    }

    public double[][] verticalIntegration(float[][][] data3d, float[][][] depthLayer, float maxDepth) {
        int nx = data3d[0][0].length;
        int ny = data3d[0].length;
        int nz = data3d.length;
        double[][] integratedData = new double[ny][nx];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                double integr = 0.0;
                for (int k = 0; k < nz - 1; ++k) {
                    if (!(depthLayer[k][j][i] > maxDepth) || !(data3d[k][j][i] >= 0.0f) || !(data3d[k + 1][j][i] >= 0.0f)) continue;
                    integr += (double)Math.abs(depthLayer[k][j][i] - depthLayer[k + 1][j][i]) * ((double)(data3d[k][j][i] + data3d[k + 1][j][i]) / 2.0);
                }
                integratedData[j][i] = integr;
            }
        }
        return integratedData;
    }

    @Override
    public void update(int iStepSimu) {
        this.biomass = new double[this.getConfiguration().getNPlankton()][this.getGrid().get_ny()][this.getGrid().get_nx()];
        for (int iPlk = 0; iPlk < this.getConfiguration().getNPlankton(); ++iPlk) {
            double[][] rawBiomass = this.getRawBiomass(iPlk, iStepSimu);
            for (Cell cell : this.getGrid().getCells()) {
                if (cell.isLand()) continue;
                double area = 111.0 * (double)this.getGrid().getdLat() * 111.0 * Math.cos((double)cell.getLat() * Math.PI / 180.0) * (double)this.getGrid().getdLong();
                int i = cell.get_igrid();
                int j = cell.get_jgrid();
                int nCells = this.icoordLTLGrid[j][i].size();
                for (int k = 0; k < nCells; ++k) {
                    double[] dArray = this.biomass[iPlk][j];
                    int n = i;
                    dArray[n] = dArray[n] + area * this.convertToTonnePerKm2(iPlk, rawBiomass[this.jcoordLTLGrid[j][i].get(k)][this.icoordLTLGrid[j][i].get(k)]) / (double)nCells;
                }
            }
        }
    }

    @Override
    public double getBiomass(int iPlankton, Cell cell) {
        return this.biomass[iPlankton][cell.get_jgrid()][cell.get_igrid()];
    }

    private double convertToTonnePerKm2(int iPlankton, double concentration) {
        return concentration * this.conversionFactor[iPlankton];
    }
}

