/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import fr.ird.osmose.process.mortality.MortalityCause;
import java.io.File;

public class MeanSizeCatchOutput
extends AbstractOutput {
    private double[] meanSizeCatch;
    private double[] yieldN;

    public MeanSizeCatchOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.meanSizeCatch = new double[this.getNSpecies()];
        this.yieldN = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int i;
            int n = i = school.getSpeciesIndex();
            this.meanSizeCatch[n] = this.meanSizeCatch[n] + school.getNdead(MortalityCause.FISHING) * (double)school.getLength();
            int n2 = i;
            this.yieldN[n2] = this.yieldN[n2] + school.getNdead(MortalityCause.FISHING);
        }
    }

    @Override
    public void write(float time) {
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            this.meanSizeCatch[i] = this.yieldN[i] > 0.0 ? this.meanSizeCatch[i] / this.yieldN[i] : Double.NaN;
        }
        this.writeVariable(time, this.meanSizeCatch);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("SizeIndicators");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_meanSizeCatch_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "Mean size of fish species in cm, weighted by fish numbers in the catches, and including first ages specified in input.";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

