/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import fr.ird.osmose.process.mortality.MortalityCause;
import java.io.File;

public class MeanTrophicLevelCatchOutput
extends AbstractOutput {
    private double[] meanTLCatch;
    private double[] yield;

    public MeanTrophicLevelCatchOutput(int rank) {
        super(rank);
        this.getSimulation().requestPreyRecord();
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.meanTLCatch = new double[this.getNSpecies()];
        this.yield = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int i;
            int n = i = school.getSpeciesIndex();
            this.meanTLCatch[n] = this.meanTLCatch[n] + (double)school.getTrophicLevel() * school.adb2biom(school.getNdead(MortalityCause.FISHING));
            int n2 = i;
            this.yield[n2] = this.yield[n2] + school.adb2biom(school.getNdead(MortalityCause.FISHING));
        }
    }

    @Override
    public void write(float time) {
        for (int i = 0; i < this.getConfiguration().getNSpecies(); ++i) {
            this.meanTLCatch[i] = this.yield[i] > 0.0 ? this.meanTLCatch[i] / this.yield[i] : Double.NaN;
        }
        this.writeVariable(time, this.meanTLCatch);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_meanTLCatch_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "Mean Trophic Level of fish species, weighted by fish catch, and including first ages specified in input";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

