/*
 * Decompiled with CFR 0.152.
 */
package io.github.crew102.rapidrake;

import io.github.crew102.rapidrake.model.Keyword;
import io.github.crew102.rapidrake.model.RakeParams;
import io.github.crew102.rapidrake.model.Result;
import io.github.crew102.rapidrake.opennlpUtils.SentDetector;
import io.github.crew102.rapidrake.opennlpUtils.Tagger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.stemmer.snowball.SnowballStemmer;
import opennlp.tools.tokenize.WhitespaceTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RakeAlgorithm {
    private final RakeParams rakeParams;
    private final POSTaggerME tagger;
    private final SentenceDetectorME sentDetector;
    private static final SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.ENGLISH);

    public RakeAlgorithm(RakeParams rakeParams, String taggerModelUrl, String sentDectModelUrl) throws IOException {
        this.rakeParams = rakeParams;
        this.tagger = new Tagger(taggerModelUrl).getPosTagger();
        this.sentDetector = new SentDetector(sentDectModelUrl).getSentDetector();
    }

    public Result rake(String txtEl) {
        String[] tokens = this.getTokens(txtEl);
        ArrayList<Keyword> keywords = this.idCandidateKeywords(tokens);
        ArrayList<Keyword> keywords2 = this.calcKeywordScores(keywords);
        return this.getResult(keywords2);
    }

    private String[] getTokens(String txtEl) {
        String[] sents;
        String txtPadded = txtEl.replaceAll("([-,.?():;\"!/])", " $1 ");
        ArrayList<String> tokenList = new ArrayList<String>();
        Pattern anyWordChar = Pattern.compile("[a-z]");
        for (String sentence : sents = this.sentDetector.sentDetect(txtPadded)) {
            String[] tokenArray = WhitespaceTokenizer.INSTANCE.tokenize(sentence);
            String[] tags = this.tagger.tag(tokenArray);
            for (int i = 0; i < tokenArray.length; ++i) {
                String token = tokenArray[i].trim().toLowerCase();
                String tag = tags[i].trim();
                if (!token.matches("\\p{Punct}") && (this.rakeParams.getStopPOS().contains(tag) || token.length() < this.rakeParams.getWordMinChar() || this.rakeParams.getStopWords().contains(token) || !anyWordChar.matcher(token).find())) {
                    token = ".";
                }
                tokenList.add(token);
            }
        }
        String[] tokens = new String[tokenList.size()];
        return tokenList.toArray(tokens);
    }

    private ArrayList<Keyword> idCandidateKeywords(String[] tokens) {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        String cleanedTxt = this.collapseTokens(tokens);
        String[] aryKey = cleanedTxt.split(this.rakeParams.getPhraseDelmins());
        Pattern anyWordChar = Pattern.compile("[a-z]");
        for (int i = 0; i < aryKey.length; ++i) {
            String oneKey = aryKey[i];
            Matcher myMatch = anyWordChar.matcher(oneKey);
            if (!myMatch.find()) continue;
            String trimmedKey = oneKey.trim();
            String[] wordAr = trimmedKey.split(" ");
            if (this.rakeParams.shouldStem()) {
                String[] stemmedWordAr = new String[wordAr.length];
                for (int k = 0; k < wordAr.length; ++k) {
                    stemmedWordAr[k] = stemmer.stem((CharSequence)wordAr[k]).toString();
                }
                String stemedString = this.collapseTokens(stemmedWordAr);
                Keyword someKey = new Keyword(trimmedKey, wordAr, stemedString, stemmedWordAr);
                keywords.add(someKey);
                continue;
            }
            Keyword someKey = new Keyword(trimmedKey, wordAr);
            keywords.add(someKey);
        }
        return keywords;
    }

    private String collapseTokens(String[] tokens) {
        StringBuilder fullBuff = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String atok = tokens[i];
            String toAdd = i != tokens.length - 1 ? atok + " " : atok;
            fullBuff.append(toAdd);
        }
        return fullBuff.toString();
    }

    private ArrayList<Keyword> calcKeywordScores(ArrayList<Keyword> candidateKeywords) {
        Keyword oneKey;
        HashMap<String, Integer> wordfreq = new HashMap<String, Integer>();
        HashMap<String, Integer> worddegTemp = new HashMap<String, Integer>();
        HashMap<String, Float> tokenScores = new HashMap<String, Float>();
        for (int i = 0; i < candidateKeywords.size(); ++i) {
            oneKey = candidateKeywords.get(i);
            String[] keysTokens = this.rakeParams.shouldStem() ? oneKey.getKeyStemmedAry() : oneKey.getKeyStringAry();
            for (int z = 0; z < keysTokens.length; ++z) {
                String aTok = keysTokens[z];
                int degTe = keysTokens.length - 1;
                if (!wordfreq.containsKey(aTok)) {
                    wordfreq.put(aTok, 1);
                    worddegTemp.put(aTok, degTe);
                    continue;
                }
                int valu2 = (Integer)wordfreq.get(aTok) + 1;
                wordfreq.replace(aTok, valu2);
                int repdeg = (Integer)worddegTemp.get(aTok) + degTe;
                worddegTemp.replace(aTok, repdeg);
            }
        }
        for (Map.Entry entry : wordfreq.entrySet()) {
            String aKey = (String)entry.getKey();
            float freq = ((Integer)wordfreq.get(aKey)).intValue();
            float val = ((float)((Integer)worddegTemp.get(aKey)).intValue() + freq) / freq;
            tokenScores.put(aKey, Float.valueOf(val));
        }
        for (int i = 0; i < candidateKeywords.size(); ++i) {
            oneKey = candidateKeywords.get(i);
            oneKey.sumScore(tokenScores, this.rakeParams);
        }
        return candidateKeywords;
    }

    public Result getResult(ArrayList<Keyword> keywords) {
        String[] full = new String[keywords.size()];
        String[] stemmed = new String[keywords.size()];
        float[] scores = new float[keywords.size()];
        for (int i = 0; i < keywords.size(); ++i) {
            Keyword oneKey = keywords.get(i);
            full[i] = oneKey.getKeyString();
            stemmed[i] = oneKey.getStemmedString();
            scores[i] = oneKey.getScore();
        }
        return new Result(full, stemmed, scores);
    }
}

