/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.Arrays;

final class JenaHandler
extends ARPSaxErrorHandler
implements StatementHandler,
NamespaceHandler {
    private static final int BULK_UPDATE_SIZE = 1000;
    private final BulkUpdateHandler bulk;
    private final PrefixMapping prefixMapping;
    protected final Triple[] triples;
    protected int here = 0;

    public JenaHandler(Model m, RDFErrorHandler e) {
        this(m.getGraph(), e);
    }

    public JenaHandler(Graph g, Model m, RDFErrorHandler e) {
        this(g, JenaHandler.modelToPrefixMapping(m), e);
    }

    private JenaHandler(Graph graph, RDFErrorHandler e) {
        this(graph, graph.getPrefixMapping(), e);
    }

    private JenaHandler(Graph graph, PrefixMapping prefixMapping, RDFErrorHandler errorHandler) {
        super(errorHandler);
        this.bulk = graph.getBulkUpdateHandler();
        this.triples = new Triple[1000];
        this.prefixMapping = prefixMapping;
    }

    private static PrefixMapping modelToPrefixMapping(Model model) {
        return model == null ? PrefixMapping.Factory.create() : model.getGraph().getPrefixMapping();
    }

    public void useWith(ARPHandlers h) {
        h.setStatementHandler(this);
        h.setErrorHandler(this);
        h.setNamespaceHandler(this);
    }

    @Override
    public void statement(AResource subj, AResource pred, AResource obj) {
        try {
            this.triples[this.here++] = JenaReader.convert(subj, pred, obj);
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
        if (this.here == 1000) {
            this.bulkUpdate();
        }
    }

    @Override
    public void statement(AResource subj, AResource pred, ALiteral lit) {
        try {
            this.triples[this.here++] = JenaReader.convert(subj, pred, lit);
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
        if (this.here == 1000) {
            this.bulkUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkUpdate() {
        try {
            if (this.here == 1000) {
                this.bulk.add(this.triples);
            } else {
                this.bulk.add(Arrays.asList(this.triples).subList(0, this.here));
            }
        }
        catch (JenaException e) {
            this.errorHandler.error(e);
        }
        finally {
            this.here = 0;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (PrefixMappingImpl.isNiceURI(uri)) {
            this.prefixMapping.setNsPrefix(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }
}

