/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public abstract class IsotopeFactory {
    protected Map<String, List<IIsotope>> isotopes = null;
    protected Map<String, IIsotope> majorIsotopes = null;
    protected static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopeFactory.class);

    public int getSize() {
        return this.isotopes.size();
    }

    protected void add(IIsotope isotope) {
        List<IIsotope> isotopesForSymbol = this.isotopes.get(isotope.getSymbol());
        if (isotopesForSymbol == null) {
            isotopesForSymbol = new ArrayList<IIsotope>();
            this.isotopes.put(isotope.getSymbol(), isotopesForSymbol);
        }
        isotopesForSymbol.add(isotope);
    }

    public IIsotope[] getIsotopes(String symbol) {
        if (this.isotopes.get(symbol) == null) {
            return new IIsotope[0];
        }
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (IIsotope isotope : this.isotopes.get(symbol)) {
            try {
                IIsotope clone = (IIsotope)isotope.clone();
                list.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    public IIsotope[] getIsotopes() {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (String element : this.isotopes.keySet()) {
            for (IIsotope isotope : this.isotopes.get(element)) {
                try {
                    IIsotope clone = (IIsotope)isotope.clone();
                    list.add(clone);
                }
                catch (CloneNotSupportedException e) {
                    logger.error("Could not clone IIsotope: ", e.getMessage());
                    logger.debug(e);
                }
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    public IIsotope[] getIsotopes(double exactMass, double difference) {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (String element : this.isotopes.keySet()) {
            for (IIsotope isotope : this.isotopes.get(element)) {
                if (!(Math.abs(isotope.getExactMass() - exactMass) <= difference)) continue;
                try {
                    IIsotope clone = (IIsotope)isotope.clone();
                    list.add(clone);
                }
                catch (CloneNotSupportedException e) {
                    logger.error("Could not clone IIsotope: ", e.getMessage());
                    logger.debug(e);
                }
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    public IIsotope getIsotope(String symbol, int massNumber) {
        IIsotope ret = null;
        for (IIsotope isotope : this.isotopes.get(symbol)) {
            if (!isotope.getSymbol().equals(symbol) || isotope.getMassNumber() != massNumber) continue;
            try {
                ret = (IIsotope)isotope.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
            return ret;
        }
        return null;
    }

    public IIsotope getIsotope(String symbol, double exactMass, double tolerance) {
        IIsotope ret = null;
        double minDiff = Double.MAX_VALUE;
        for (IIsotope isotope : this.isotopes.get(symbol)) {
            double diff = Math.abs(isotope.getExactMass() - exactMass);
            if (!isotope.getSymbol().equals(symbol) || !(diff <= tolerance) || !(diff < minDiff)) continue;
            try {
                ret = (IIsotope)isotope.clone();
                minDiff = diff;
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        return ret;
    }

    public IIsotope getMajorIsotope(int atomicNumber) {
        IIsotope major = null;
        for (IIsotope isotope : this.isotopes.get(PeriodicTable.getSymbol(atomicNumber))) {
            try {
                if (major == null) {
                    major = (IIsotope)isotope.clone();
                    continue;
                }
                if (!(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                major = (IIsotope)isotope.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        if (major == null) {
            logger.error("Could not find major isotope for: ", atomicNumber);
        }
        return major;
    }

    public boolean isElement(String elementName) {
        return this.getElement(elementName) != null;
    }

    public IIsotope getMajorIsotope(String symbol) {
        IIsotope major = null;
        if (this.majorIsotopes.containsKey(symbol)) {
            major = this.majorIsotopes.get(symbol);
        } else {
            if (this.isotopes.get(symbol) == null) {
                logger.error("Could not find major isotope for: ", symbol);
                return null;
            }
            for (IIsotope isotope : this.isotopes.get(symbol)) {
                if (!isotope.getSymbol().equals(symbol)) continue;
                try {
                    if (major == null) {
                        major = (IIsotope)isotope.clone();
                        continue;
                    }
                    if (!(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                    major = (IIsotope)isotope.clone();
                }
                catch (CloneNotSupportedException e) {
                    logger.error("Could not clone IIsotope: ", e.getMessage());
                    logger.debug(e);
                }
            }
            if (major == null) {
                logger.error("Could not find major isotope for: ", symbol);
            } else {
                this.majorIsotopes.put(symbol, major);
            }
        }
        return major;
    }

    public IElement getElement(String symbol) {
        return this.getMajorIsotope(symbol);
    }

    public IElement getElement(int atomicNumber) {
        return this.getMajorIsotope(atomicNumber);
    }

    public String getElementSymbol(int atomicNumber) {
        IIsotope isotope = this.getMajorIsotope(atomicNumber);
        return isotope.getSymbol();
    }

    public IAtom configure(IAtom atom) {
        IIsotope isotope = atom.getMassNumber() == null ? this.getMajorIsotope(atom.getSymbol()) : this.getIsotope(atom.getSymbol(), atom.getMassNumber());
        if (isotope == null) {
            throw new IllegalArgumentException("Cannot configure an unrecognized element: " + atom);
        }
        return this.configure(atom, isotope);
    }

    public IAtom configure(IAtom atom, IIsotope isotope) {
        atom.setMassNumber(isotope.getMassNumber());
        atom.setSymbol(isotope.getSymbol());
        atom.setExactMass(isotope.getExactMass());
        atom.setAtomicNumber(isotope.getAtomicNumber());
        atom.setNaturalAbundance(isotope.getNaturalAbundance());
        return atom;
    }

    public void configureAtoms(IAtomContainer container) {
        for (int f = 0; f < container.getAtomCount(); ++f) {
            this.configure(container.getAtom(f));
        }
    }

    public double getNaturalMass(IElement element) {
        IIsotope[] isotopes = this.getIsotopes(element.getSymbol());
        double summedAbundances = 0.0;
        double summedWeightedAbundances = 0.0;
        double getNaturalMass = 0.0;
        for (int i = 0; i < isotopes.length; ++i) {
            getNaturalMass = (summedWeightedAbundances += isotopes[i].getNaturalAbundance() * isotopes[i].getExactMass()) / (summedAbundances += isotopes[i].getNaturalAbundance().doubleValue());
        }
        return getNaturalMass;
    }
}

