/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.core.DoubleVector;
import moa.core.FastVector;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.options.ClassOption;
import moa.streams.InstanceStream;

public class RandomRules
extends AbstractClassifier
implements Regressor {
    public IntOption VerbosityOption = new IntOption("verbosity", 'v', "Output Verbosity Control Level. 1 (Less) to 2 (More)", 1, 1, 2);
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "rules.AMRulesRegressor");
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models in the bag.", 10, 1, Integer.MAX_VALUE);
    public FloatOption numAttributesPercentageOption = new FloatOption("numAttributesPercentage", 'n', "The number of attributes to use per model.", 63.2, 0.0, 100.0);
    public FlagOption useBaggingOption = new FlagOption("useBagging", 'p', "Use Bagging.");
    protected Classifier[] ensemble;
    protected boolean isRegression;
    protected int[][] listAttributes;
    protected int numAttributes;
    protected InstancesHeader[] dataset;

    @Override
    public String getPurposeString() {
        return "RandomRules";
    }

    @Override
    public void resetLearningImpl() {
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = baseLearner.copy();
        }
        this.isRegression = baseLearner instanceof Regressor;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        for (int i = 0; i < this.ensemble.length; ++i) {
            int k = 1;
            if (this.useBaggingOption.isSet()) {
                k = MiscUtils.poisson(1.0, this.classifierRandom);
            }
            if (k <= 0) continue;
            Instance weightedInst = this.transformInstance(inst, i);
            weightedInst.setWeight(inst.weight() * (double)k);
            this.ensemble[i].trainOnInstance(weightedInst);
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        StringBuilder sb = null;
        if (this.VerbosityOption.getValue() > 1) {
            sb = new StringBuilder();
        }
        for (int i = 0; i < this.ensemble.length; ++i) {
            DoubleVector vote = new DoubleVector(this.ensemble[i].getVotesForInstance(this.transformInstance(inst, i)));
            if (this.VerbosityOption.getValue() > 1) {
                sb.append(vote.getValue(0) + ", ");
            }
            if (!this.isRegression && vote.sumOfValues() != 0.0) {
                vote.normalize();
            }
            combinedVote.addValues(vote);
        }
        if (this.isRegression) {
            combinedVote.scaleValues(1.0 / (double)this.ensemble.length);
        }
        if (this.VerbosityOption.getValue() > 1) {
            sb.append(combinedVote.getValue(0) + ", ").append(inst.classValue());
            System.out.println(sb.toString());
        }
        return combinedVote.getArrayRef();
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("ensemble size", this.ensemble != null ? (double)this.ensemble.length : 0.0)};
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return this.ensemble;
    }

    protected Instance transformInstance(Instance inst, int classifierIndex) {
        if (this.listAttributes == null) {
            this.numAttributes = (int)(this.numAttributesPercentageOption.getValue() * (double)(inst.numAttributes() - 1) / 100.0);
            this.listAttributes = new int[this.numAttributes][this.ensemble.length];
            this.dataset = new InstancesHeader[this.ensemble.length];
            for (int ensembleIndex = 0; ensembleIndex < this.ensemble.length; ++ensembleIndex) {
                for (int attributeIndex = 0; attributeIndex < this.numAttributes; ++attributeIndex) {
                    boolean isUnique = false;
                    block2: while (!isUnique) {
                        this.listAttributes[attributeIndex][ensembleIndex] = this.classifierRandom.nextInt(inst.numAttributes() - 1);
                        isUnique = true;
                        for (int k = 0; k < attributeIndex; ++k) {
                            if (this.listAttributes[attributeIndex][ensembleIndex] != this.listAttributes[k][ensembleIndex]) continue;
                            isUnique = false;
                            continue block2;
                        }
                    }
                }
                FastVector<Attribute> attributes = new FastVector<Attribute>();
                for (int attributeIndex = 0; attributeIndex < this.numAttributes; ++attributeIndex) {
                    attributes.addElement(inst.attribute(this.listAttributes[attributeIndex][ensembleIndex]));
                    System.out.print(this.listAttributes[attributeIndex][ensembleIndex]);
                }
                System.out.println("Number of attributes: " + this.numAttributes + "," + (inst.numAttributes() - 1));
                attributes.addElement(inst.classAttribute());
                this.dataset[ensembleIndex] = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
                this.dataset[ensembleIndex].setClassIndex(this.numAttributes);
                this.ensemble[ensembleIndex].setModelContext(this.dataset[ensembleIndex]);
            }
        }
        double[] attVals = new double[this.numAttributes + 1];
        for (int attributeIndex = 0; attributeIndex < this.numAttributes; ++attributeIndex) {
            attVals[attributeIndex] = inst.value(this.listAttributes[attributeIndex][classifierIndex]);
        }
        DenseInstance instance = new DenseInstance(1.0, attVals);
        instance.setDataset(this.dataset[classifierIndex]);
        instance.setClassValue(inst.classValue());
        return instance;
    }
}

