/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.vikamine.kernel.xpdl.ETyp;
import org.vikamine.kernel.xpdl.IConstraint;
import org.vikamine.kernel.xpdl.MAttribute;
import org.vikamine.kernel.xpdl.MConstraintBuilder;
import org.vikamine.kernel.xpdl.MConstraints;
import org.vikamine.kernel.xpdl.MDataset;
import org.vikamine.kernel.xpdl.MInitialSubgroup;
import org.vikamine.kernel.xpdl.MMethod;
import org.vikamine.kernel.xpdl.MOperator;
import org.vikamine.kernel.xpdl.MQualityFunction;
import org.vikamine.kernel.xpdl.MRestrictions;
import org.vikamine.kernel.xpdl.MSearchSpace;
import org.vikamine.kernel.xpdl.MTarget;
import org.vikamine.kernel.xpdl.MValue;
import org.vikamine.kernel.xpdl.XMLException;

public class XMLData {
    private Document doc;

    public XMLData(Document doc) {
        this.doc = doc;
    }

    public XMLData(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File for loading mining task not found: " + file.getAbsolutePath());
        }
        this.doc = this.buildDoc(file);
    }

    public XMLData(InputStream stream) {
        this.doc = this.buildDoc(stream);
    }

    public String getMiningId() {
        return this.doc.getRootElement().getAttributeValue("id");
    }

    public MDataset getDataset() {
        Element elem = this.doc.getRootElement().getChild("dataset");
        MRestrictions res = new MRestrictions(this.getAttributes(elem.getChild("restrictions")));
        MDataset data = new MDataset(elem.getAttributeValue("name"), res);
        return data;
    }

    public MInitialSubgroup getInitialSubgroup() {
        Element elem = this.doc.getRootElement().getChild("initialSubgroup");
        if (elem != null) {
            MOperator op = new MOperator("and", this.getAttributes(elem.getChild("sgDescription").getChild("operator")));
            return new MInitialSubgroup(op);
        }
        return null;
    }

    public MTarget getTarget() {
        Element target = this.doc.getRootElement().getChild("target");
        if (this.getAttributes(target).size() <= 1) {
            MTarget data = new MTarget(target.getAttributeValue("type"), this.getAttributes(target).get(0));
            return data;
        }
        throw new XMLException("Target contains more than 1 Attribute");
    }

    public MSearchSpace getSearchSpace() {
        int limitSelectors;
        Attribute limitSelectorsAtt;
        Element search = this.doc.getDocument().getRootElement().getChild("searchSpace");
        boolean useAllNominal = false;
        Attribute useAllNominalString = search.getAttribute("useAllNominal");
        if (useAllNominalString != null) {
            try {
                useAllNominal = useAllNominalString.getBooleanValue();
            }
            catch (DataConversionException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "could not convert Attribute value of limit Selectors to boolean, using default (false)");
            }
        }
        boolean useAll = false;
        Attribute useAllString = search.getAttribute("useAll");
        if (useAllString != null) {
            try {
                useAll = useAllString.getBooleanValue();
            }
            catch (DataConversionException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "could not convert Attribute value of limit Selectors to boolean, using default (false)");
            }
        }
        if ((limitSelectorsAtt = search.getAttribute("limitSelectors")) == null) {
            limitSelectors = Integer.MAX_VALUE;
        } else {
            try {
                limitSelectors = limitSelectorsAtt.getIntValue();
            }
            catch (DataConversionException e) {
                limitSelectors = Integer.MAX_VALUE;
            }
        }
        int[] metaLimitSelectors = null;
        if (limitSelectorsAtt == null) {
            metaLimitSelectors = new int[]{Integer.MAX_VALUE};
        } else {
            try {
                String metaLimitSelectorsString = limitSelectorsAtt.getValue();
                metaLimitSelectorsString = metaLimitSelectorsString.replaceAll(" ", "");
                String[] metaLimitsStrings = metaLimitSelectorsString.split(",");
                metaLimitSelectors = new int[metaLimitsStrings.length];
                int i = 0;
                String[] stringArray = metaLimitsStrings;
                int n = metaLimitsStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    metaLimitSelectors[i++] = Integer.parseInt(s);
                    ++n2;
                }
            }
            catch (NumberFormatException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "could not convert Attribute value of limit Selectors to int [], using default");
                metaLimitSelectors = new int[]{Integer.MAX_VALUE};
            }
        }
        return new MSearchSpace(this.getAttributes(search), useAll, useAllNominal, limitSelectors, metaLimitSelectors);
    }

    public MQualityFunction getQualityFunction() {
        Element func = this.doc.getRootElement().getChild("qualityFunction");
        try {
            return new MQualityFunction(func.getAttributeValue("name"), Boolean.parseBoolean(func.getAttributeValue("invert")));
        }
        catch (IllegalArgumentException e) {
            throw new XMLException("Invalid quality function!");
        }
    }

    public MMethod getMethod() {
        return new MMethod(this.doc.getRootElement().getChild("method").getAttributeValue("name"));
    }

    public MConstraints getMConstraints() {
        Element constraints = this.doc.getRootElement().getChild("constraints");
        return new MConstraints(this.getContraints(constraints));
    }

    private ArrayList<IConstraint> getContraints(Element t) {
        ArrayList<IConstraint> temp = new ArrayList<IConstraint>();
        for (Element l : t.getChildren()) {
            IConstraint Constraint = MConstraintBuilder.build(l.getAttributeValue("value"), l.getAttributeValue("name"));
            temp.add(Constraint);
        }
        return temp;
    }

    private ArrayList<MAttribute> getAttributes(Element t) {
        ArrayList<MAttribute> attributes = new ArrayList<MAttribute>();
        for (Element e : t.getChildren("attribute")) {
            MValue value;
            Attribute discretizationMethod = e.getAttribute("discretizationMethod");
            MAttribute att = discretizationMethod == null ? new MAttribute(e.getAttribute("name").getValue()) : new MAttribute(e.getAttribute("name").getValue(), discretizationMethod.getValue());
            List values = e.getChildren("includeValue");
            for (Element f : values) {
                value = new MValue(ETyp.include, f.getText());
                att.addValue(value);
            }
            values = e.getChildren("excludeValue");
            for (Element f : values) {
                value = new MValue(ETyp.exclude, f.getText());
                att.addValue(value);
            }
            attributes.add(att);
        }
        return attributes;
    }

    private SAXBuilder preBuild() {
        Properties properties = new Properties();
        try {
            InputStream stream = this.getClass().getResourceAsStream("/resources/xml/xsd.properties");
            properties.load(stream);
            stream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Properties File not found");
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        SAXBuilder sax = new SAXBuilder();
        return sax;
    }

    private Document buildDoc(File toBuild) throws IOException {
        SAXBuilder sax = this.preBuild();
        try {
            return sax.build(toBuild);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new XMLException("Eingabe-datei nicht valide");
        }
    }

    private Document buildDoc(InputStream stream) {
        SAXBuilder sax = this.preBuild();
        try {
            return sax.build(stream);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new XMLException("Eingabe-datei nicht valide");
        }
        catch (IOException e) {
            new XMLException("Fehler beim Lesen der Eingabedatei");
            return null;
        }
    }

    public String getContent() {
        XMLOutputter xmlout = new XMLOutputter();
        String xml = xmlout.outputString(this.doc);
        return xml;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }

    public Document getDoc() {
        return this.doc;
    }
}

