/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

public final class FMeasure {
    private long selected;
    private long target;
    private long truePositive;

    public double getPrecisionScore() {
        return this.selected > 0L ? (double)this.truePositive / (double)this.selected : 0.0;
    }

    public double getRecallScore() {
        return this.target > 0L ? (double)this.truePositive / (double)this.target : 0.0;
    }

    public double getFMeasure() {
        if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
            return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
        }
        return -1.0;
    }

    public void updateScores(Object[] references, Object[] predictions) {
        this.truePositive += (long)FMeasure.countTruePositives(references, predictions);
        this.selected += (long)predictions.length;
        this.target += (long)references.length;
    }

    public void mergeInto(FMeasure measure) {
        this.selected += measure.selected;
        this.target += measure.target;
        this.truePositive += measure.truePositive;
    }

    public String toString() {
        return "Precision: " + Double.toString(this.getPrecisionScore()) + "\n" + "Recall: " + Double.toString(this.getRecallScore()) + "\n" + "F-Measure: " + Double.toString(this.getFMeasure());
    }

    static int countTruePositives(Object[] references, Object[] predictions) {
        int truePositives = 0;
        for (int referenceIndex = 0; referenceIndex < references.length; ++referenceIndex) {
            Object referenceName = references[referenceIndex];
            for (int predictedIndex = 0; predictedIndex < predictions.length; ++predictedIndex) {
                if (!referenceName.equals(predictions[predictedIndex])) continue;
                ++truePositives;
            }
        }
        return truePositives;
    }

    public static double precision(Object[] references, Object[] predictions) {
        if (predictions.length > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)predictions.length;
        }
        return Double.NaN;
    }

    public static double recall(Object[] references, Object[] predictions) {
        if (references.length > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)references.length;
        }
        return Double.NaN;
    }
}

