/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SimpleTreeQueryPlan
implements TreeQueryPlan {
    private Graph pattern;
    private Graph target;

    public SimpleTreeQueryPlan(Graph target, Graph pattern) {
        this.target = target;
        this.pattern = pattern;
    }

    @Override
    public Graph executeTree() {
        Graph result = Factory.createGraphMem();
        Set<Node> roots = SimpleTreeQueryPlan.getRoots(this.pattern);
        Iterator<Node> it = roots.iterator();
        while (it.hasNext()) {
            this.handleRoot(result, it.next(), new HashSet<Triple>());
        }
        return result;
    }

    private Iterator<Triple> findFromTriple(Graph g, Triple t) {
        return g.find(this.asPattern(t.getSubject()), this.asPattern(t.getPredicate()), this.asPattern(t.getObject()));
    }

    private Node asPattern(Node x) {
        return x.isBlank() ? null : x;
    }

    private void handleRoot(Graph result, Node root, Set<Triple> pending) {
        ExtendedIterator<Triple> it = this.pattern.find(root, null, null);
        if (!it.hasNext()) {
            this.absorb(result, pending);
            return;
        }
        while (it.hasNext()) {
            Triple base = (Triple)it.next();
            Iterator<Triple> that = this.findFromTriple(this.target, base);
            while (that.hasNext()) {
                Triple x = that.next();
                pending.add(x);
                this.handleRoot(result, base.getObject(), pending);
            }
        }
    }

    private void absorb(Graph result, Set<Triple> triples) {
        Iterator<Triple> it = triples.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        triples.clear();
    }

    public static Set<Node> getRoots(Graph pattern) {
        Set<Node> roots = CollectionFactory.createHashedSet();
        ExtendedIterator<Triple> sub = GraphUtil.findAll(pattern);
        while (sub.hasNext()) {
            roots.add(((Triple)sub.next()).getSubject());
        }
        ExtendedIterator<Triple> obj = GraphUtil.findAll(pattern);
        while (obj.hasNext()) {
            roots.remove(((Triple)obj.next()).getObject());
        }
        return roots;
    }
}

