/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Dichroic;
import ome.model.acquisition.Filter;
import ome.model.acquisition.FilterSetEmissionFilterLink;
import ome.model.acquisition.FilterSetExcitationFilterLink;
import ome.model.acquisition.Instrument;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="filterset_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filterset_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filterset_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filterset_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="filterset_owner_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filterset_group_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filterset_event_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filterset_perms_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="filterset_owner_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filterset_group_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filterset_event_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filterset_perms_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="filterset_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filterset_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filterset_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filterset_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT filterset.id FROM filterset*, image* WHERE filterset.instrument = image.instrument AND image.id IN (:images)))")})
@Entity
@Table(name="filterset", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_filterset", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_filterset"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class FilterSet
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "filterset_owner_filter";
    public static final String GROUP_FILTER = "filterset_group_filter";
    public static final String EVENT_FILTER = "filterset_event_filter";
    public static final String PERMS_FILTER = "filterset_perms_filter";
    public static final String ID = "ome.model.acquisition.FilterSet_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.FilterSet_version";
    protected Integer version = 0;
    protected String manufacturer = null;
    protected String model = null;
    protected String lotNumber = null;
    protected String serialNumber = null;
    protected Instrument instrument = null;
    protected Set<FilterSetExcitationFilterLink> excitationFilterLink = new HashSet<FilterSetExcitationFilterLink>();
    public static final String OWNER_FILTER_EXCITATIONFILTERLINK = "filterset_owner_filter_EXCITATIONFILTERLINK";
    public static final String GROUP_FILTER_EXCITATIONFILTERLINK = "filterset_group_filter_EXCITATIONFILTERLINK";
    public static final String EVENT_FILTER_EXCITATIONFILTERLINK = "filterset_event_filter_EXCITATIONFILTERLINK";
    public static final String PERMS_FILTER_EXCITATIONFILTERLINK = "filterset_perms_filter_EXCITATIONFILTERLINK";
    private Map<Long, Long> excitationFilterLinkCountPerOwner = null;
    protected Dichroic dichroic = null;
    protected Set<FilterSetEmissionFilterLink> emissionFilterLink = new HashSet<FilterSetEmissionFilterLink>();
    public static final String OWNER_FILTER_EMISSIONFILTERLINK = "filterset_owner_filter_EMISSIONFILTERLINK";
    public static final String GROUP_FILTER_EMISSIONFILTERLINK = "filterset_group_filter_EMISSIONFILTERLINK";
    public static final String EVENT_FILTER_EMISSIONFILTERLINK = "filterset_event_filter_EMISSIONFILTERLINK";
    public static final String PERMS_FILTER_EMISSIONFILTERLINK = "filterset_perms_filter_EMISSIONFILTERLINK";
    private Map<Long, Long> emissionFilterLinkCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String MANUFACTURER = "ome.model.acquisition.FilterSet_manufacturer";
    public static final String MODEL = "ome.model.acquisition.FilterSet_model";
    public static final String LOTNUMBER = "ome.model.acquisition.FilterSet_lotNumber";
    public static final String SERIALNUMBER = "ome.model.acquisition.FilterSet_serialNumber";
    public static final String INSTRUMENT = "ome.model.acquisition.FilterSet_instrument";
    public static final String EXCITATIONFILTERLINKCOUNTPEROWNER = "ome.model.acquisition.FilterSet_excitationFilterLinkCountPerOwner";
    public static final String EXCITATIONFILTERLINK = "ome.model.acquisition.FilterSet_excitationFilterLink";
    public static final String DICHROIC = "ome.model.acquisition.FilterSet_dichroic";
    public static final String EMISSIONFILTERLINKCOUNTPEROWNER = "ome.model.acquisition.FilterSet_emissionFilterLinkCountPerOwner";
    public static final String EMISSIONFILTERLINK = "ome.model.acquisition.FilterSet_emissionFilterLink";
    public static final String DETAILS = "ome.model.acquisition.FilterSet_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public FilterSet() {
        this(null, true);
    }

    protected FilterSet(Long id) {
        this(id, true);
    }

    public FilterSet(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public FilterSet(Instrument _instrument) {
        this(null, true);
        this.setInstrument(_instrument);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_filterset")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="manufacturer", updatable=true)
    public String getManufacturer() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.manufacturer = manufacturer;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="model", updatable=true)
    public String getModel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.model;
    }

    public void setModel(String model) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.model = model;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="lotNumber", updatable=true)
    public String getLotNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lotNumber = lotNumber;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="serialNumber", updatable=true)
    public String getSerialNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.serialNumber = serialNumber;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Instrument.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="instrument", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKfilterset_instrument_instrument")
    public Instrument getInstrument() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.instrument = instrument;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT link.id FROM filtersetexcitationfilterlink AS link*, filter*, image* WHERE link.child = filter.id AND filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="filterset_owner_filter_EXCITATIONFILTERLINK", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filterset_group_filter_EXCITATIONFILTERLINK", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filterset_event_filter_EXCITATIONFILTERLINK", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filterset_perms_filter_EXCITATIONFILTERLINK", condition=":permsStr = permissions")})
    protected Set<FilterSetExcitationFilterLink> getExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationFilterLink;
    }

    protected void setExcitationFilterLink(Set<FilterSetExcitationFilterLink> excitationFilterLink) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.excitationFilterLink = excitationFilterLink;
    }

    public int sizeOfExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationFilterLink == null ? -1 : this.excitationFilterLink.size();
    }

    public Iterator<FilterSetExcitationFilterLink> iterateExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return new EmptyIterator<FilterSetExcitationFilterLink>();
        }
        return this.getExcitationFilterLink().iterator();
    }

    public Collection<FilterSetExcitationFilterLink> unmodifiableExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getExcitationFilterLink());
    }

    public <E> List<E> collectExcitationFilterLink(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSetExcitationFilterLink> it = this.iterateExcitationFilterLink();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilterSetExcitationFilterLink(FilterSetExcitationFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFilterSetExcitationFilterLinkSet(Collection<FilterSetExcitationFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().addAll(targets);
        for (FilterSetExcitationFilterLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFilterSetExcitationFilterLink(FilterSetExcitationFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().remove(target);
        target.setParent(null);
    }

    public void removeFilterSetExcitationFilterLinkSet(Collection<FilterSetExcitationFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().removeAll(targets);
        for (FilterSetExcitationFilterLink target : targets) {
            target.setParent(null);
        }
    }

    public FilterSetExcitationFilterLink linkExcitationFilter(Filter addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilterSetExcitationFilterLink link = new FilterSetExcitationFilterLink();
        link.link(this, addition);
        this.addFilterSetExcitationFilterLink(link, true);
        return link;
    }

    public void addFilterSetExcitationFilterLink(FilterSetExcitationFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addFilterSetExcitationFilterLink(link, false);
        }
    }

    public Iterator<Filter> linkedExcitationFilterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return new EmptyIterator<Filter>();
        }
        final Iterator<FilterSetExcitationFilterLink> it = this.getExcitationFilterLink().iterator();
        return new Iterator<Filter>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Filter next() {
                if (it == null) {
                    throw new NoSuchElementException("excitationFilterLink is null; no elements.");
                }
                FilterSetExcitationFilterLink link = (FilterSetExcitationFilterLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilterSetExcitationFilterLink> findFilterSetExcitationFilterLink(Filter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterSetExcitationFilterLink> it = this.iterateExcitationFilterLink();
        HashSet<FilterSetExcitationFilterLink> result = new HashSet<FilterSetExcitationFilterLink>();
        while (it.hasNext()) {
            FilterSetExcitationFilterLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Filter> linkedExcitationFilterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Filter> it = this.linkedExcitationFilterIterator();
        ArrayList<Filter> list = new ArrayList<Filter>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedExcitationFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Filter> it = this.linkedExcitationFilterIterator();
        while (it.hasNext()) {
            Filter obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkExcitationFilter(Filter removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilterSetExcitationFilterLink> toRemove = this.findFilterSetExcitationFilterLink(removal);
        Iterator<FilterSetExcitationFilterLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilterSetExcitationFilterLink(it.next(), true);
        }
    }

    public void removeFilterSetExcitationFilterLink(FilterSetExcitationFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeFilterSetExcitationFilterLink(link, false);
        }
    }

    public void clearExcitationFilterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilterSetExcitationFilterLink> list = new ArrayList<FilterSetExcitationFilterLink>(this.getExcitationFilterLink());
        for (FilterSetExcitationFilterLink link : list) {
            this.removeFilterSetExcitationFilterLink(link, true);
        }
    }

    protected void setExcitationFilterLinkCountPerOwner(Map<Long, Long> map) {
        this.excitationFilterLinkCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_FilterSet_excitationFilterLink")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_FilterSet_excitationFilterLink_by_owner", joinColumns={@JoinColumn(name="FilterSet_id")})
    public Map<Long, Long> getExcitationFilterLinkCountPerOwner() {
        return this.excitationFilterLinkCountPerOwner;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Dichroic.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="dichroic", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKfilterset_dichroic_dichroic")
    public Dichroic getDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.dichroic;
    }

    public void setDichroic(Dichroic dichroic) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.dichroic = dichroic;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT link.id FROM filtersetemissionfilterlink AS link*, filter*, image* WHERE link.child = filter.id AND filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="filterset_owner_filter_EMISSIONFILTERLINK", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filterset_group_filter_EMISSIONFILTERLINK", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filterset_event_filter_EMISSIONFILTERLINK", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filterset_perms_filter_EMISSIONFILTERLINK", condition=":permsStr = permissions")})
    protected Set<FilterSetEmissionFilterLink> getEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionFilterLink;
    }

    protected void setEmissionFilterLink(Set<FilterSetEmissionFilterLink> emissionFilterLink) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.emissionFilterLink = emissionFilterLink;
    }

    public int sizeOfEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionFilterLink == null ? -1 : this.emissionFilterLink.size();
    }

    public Iterator<FilterSetEmissionFilterLink> iterateEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return new EmptyIterator<FilterSetEmissionFilterLink>();
        }
        return this.getEmissionFilterLink().iterator();
    }

    public Collection<FilterSetEmissionFilterLink> unmodifiableEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getEmissionFilterLink());
    }

    public <E> List<E> collectEmissionFilterLink(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSetEmissionFilterLink> it = this.iterateEmissionFilterLink();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilterSetEmissionFilterLink(FilterSetEmissionFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFilterSetEmissionFilterLinkSet(Collection<FilterSetEmissionFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().addAll(targets);
        for (FilterSetEmissionFilterLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFilterSetEmissionFilterLink(FilterSetEmissionFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().remove(target);
        target.setParent(null);
    }

    public void removeFilterSetEmissionFilterLinkSet(Collection<FilterSetEmissionFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().removeAll(targets);
        for (FilterSetEmissionFilterLink target : targets) {
            target.setParent(null);
        }
    }

    public FilterSetEmissionFilterLink linkEmissionFilter(Filter addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilterSetEmissionFilterLink link = new FilterSetEmissionFilterLink();
        link.link(this, addition);
        this.addFilterSetEmissionFilterLink(link, true);
        return link;
    }

    public void addFilterSetEmissionFilterLink(FilterSetEmissionFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addFilterSetEmissionFilterLink(link, false);
        }
    }

    public Iterator<Filter> linkedEmissionFilterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return new EmptyIterator<Filter>();
        }
        final Iterator<FilterSetEmissionFilterLink> it = this.getEmissionFilterLink().iterator();
        return new Iterator<Filter>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Filter next() {
                if (it == null) {
                    throw new NoSuchElementException("emissionFilterLink is null; no elements.");
                }
                FilterSetEmissionFilterLink link = (FilterSetEmissionFilterLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilterSetEmissionFilterLink> findFilterSetEmissionFilterLink(Filter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterSetEmissionFilterLink> it = this.iterateEmissionFilterLink();
        HashSet<FilterSetEmissionFilterLink> result = new HashSet<FilterSetEmissionFilterLink>();
        while (it.hasNext()) {
            FilterSetEmissionFilterLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Filter> linkedEmissionFilterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Filter> it = this.linkedEmissionFilterIterator();
        ArrayList<Filter> list = new ArrayList<Filter>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedEmissionFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Filter> it = this.linkedEmissionFilterIterator();
        while (it.hasNext()) {
            Filter obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkEmissionFilter(Filter removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilterSetEmissionFilterLink> toRemove = this.findFilterSetEmissionFilterLink(removal);
        Iterator<FilterSetEmissionFilterLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilterSetEmissionFilterLink(it.next(), true);
        }
    }

    public void removeFilterSetEmissionFilterLink(FilterSetEmissionFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeFilterSetEmissionFilterLink(link, false);
        }
    }

    public void clearEmissionFilterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilterSetEmissionFilterLink> list = new ArrayList<FilterSetEmissionFilterLink>(this.getEmissionFilterLink());
        for (FilterSetEmissionFilterLink link : list) {
            this.removeFilterSetEmissionFilterLink(link, true);
        }
    }

    protected void setEmissionFilterLinkCountPerOwner(Map<Long, Long> map) {
        this.emissionFilterLinkCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_FilterSet_emissionFilterLink")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_FilterSet_emissionFilterLink_by_owner", joinColumns={@JoinColumn(name="FilterSet_id")})
    public Map<Long, Long> getEmissionFilterLinkCountPerOwner() {
        return this.emissionFilterLinkCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public FilterSet newInstance() {
        return new FilterSet();
    }

    public FilterSet proxy() {
        return new FilterSet(this.id, false);
    }

    @Override
    public boolean acceptFilter(ome.util.Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.manufacturer = (String)__filter.filter(MANUFACTURER, this.manufacturer);
            this.model = (String)__filter.filter(MODEL, this.model);
            this.lotNumber = (String)__filter.filter(LOTNUMBER, this.lotNumber);
            this.serialNumber = (String)__filter.filter(SERIALNUMBER, this.serialNumber);
            this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
            this.excitationFilterLinkCountPerOwner = __filter.filter(EXCITATIONFILTERLINKCOUNTPEROWNER, this.excitationFilterLinkCountPerOwner);
            this.excitationFilterLink = (Set)__filter.filter(EXCITATIONFILTERLINK, this.excitationFilterLink);
            this.dichroic = (Dichroic)__filter.filter(DICHROIC, this.dichroic);
            this.emissionFilterLinkCountPerOwner = __filter.filter(EMISSIONFILTERLINKCOUNTPEROWNER, this.emissionFilterLinkCountPerOwner);
            this.emissionFilterLink = (Set)__filter.filter(EMISSIONFILTERLINK, this.emissionFilterLink);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MANUFACTURER)) {
            return this.getManufacturer();
        }
        if (field.equals(MODEL)) {
            return this.getModel();
        }
        if (field.equals(LOTNUMBER)) {
            return this.getLotNumber();
        }
        if (field.equals(SERIALNUMBER)) {
            return this.getSerialNumber();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (field.equals(EXCITATIONFILTERLINKCOUNTPEROWNER)) {
            return this.getExcitationFilterLinkCountPerOwner();
        }
        if (field.equals(EXCITATIONFILTERLINK)) {
            return this.getExcitationFilterLink();
        }
        if (field.equals(DICHROIC)) {
            return this.getDichroic();
        }
        if (field.equals(EMISSIONFILTERLINKCOUNTPEROWNER)) {
            return this.getEmissionFilterLinkCountPerOwner();
        }
        if (field.equals(EMISSIONFILTERLINK)) {
            return this.getEmissionFilterLink();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MANUFACTURER)) {
            this.setManufacturer((String)value);
        } else if (field.equals(MODEL)) {
            this.setModel((String)value);
        } else if (field.equals(LOTNUMBER)) {
            this.setLotNumber((String)value);
        } else if (field.equals(SERIALNUMBER)) {
            this.setSerialNumber((String)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else if (field.equals(EXCITATIONFILTERLINKCOUNTPEROWNER)) {
            this.setExcitationFilterLinkCountPerOwner((Map)value);
        } else if (field.equals(EXCITATIONFILTERLINK)) {
            this.setExcitationFilterLink((Set)value);
        } else if (field.equals(DICHROIC)) {
            this.setDichroic((Dichroic)value);
        } else if (field.equals(EMISSIONFILTERLINKCOUNTPEROWNER)) {
            this.setEmissionFilterLinkCountPerOwner((Map)value);
        } else if (field.equals(EMISSIONFILTERLINK)) {
            this.setEmissionFilterLink((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.manufacturer = null;
        this.model = null;
        this.lotNumber = null;
        this.serialNumber = null;
        this.instrument = null;
        this.excitationFilterLinkCountPerOwner = null;
        this.excitationFilterLink = null;
        this.dichroic = null;
        this.emissionFilterLinkCountPerOwner = null;
        this.emissionFilterLink = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(MANUFACTURER);
        raw.add(MODEL);
        raw.add(LOTNUMBER);
        raw.add(SERIALNUMBER);
        raw.add(INSTRUMENT);
        raw.add(EXCITATIONFILTERLINKCOUNTPEROWNER);
        raw.add(EXCITATIONFILTERLINK);
        raw.add(DICHROIC);
        raw.add(EMISSIONFILTERLINKCOUNTPEROWNER);
        raw.add(EMISSIONFILTERLINK);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKfilterset_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfilterset_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKfilterset_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfilterset_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfilterset_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

