/*
 * Decompiled with CFR 0.152.
 */
package ome.model.annotations;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.NumericAnnotation;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@DiscriminatorValue(value="/basic/num/long/")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class LongAnnotation
extends NumericAnnotation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "longannotation_owner_filter";
    public static final String GROUP_FILTER = "longannotation_group_filter";
    public static final String EVENT_FILTER = "longannotation_event_filter";
    public static final String PERMS_FILTER = "longannotation_perms_filter";
    protected Long longValue = null;
    public static final String LONGVALUE = "ome.model.annotations.LongAnnotation_longValue";
    public static final Set<String> FIELDS;

    public LongAnnotation() {
        this(null, true);
    }

    protected LongAnnotation(Long id) {
        this(id, true);
    }

    public LongAnnotation(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="longValue", updatable=true)
    public Long getLongValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.longValue = longValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public LongAnnotation newInstance() {
        return new LongAnnotation();
    }

    public LongAnnotation proxy() {
        return new LongAnnotation(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.longValue = (Long)__filter.filter(LONGVALUE, this.longValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(LONGVALUE)) {
            return this.getLongValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(LONGVALUE)) {
            this.setLongValue((Long)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.longValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(LONGVALUE);
        raw.addAll(NumericAnnotation.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

