/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.DatasetAnnotationLink;
import ome.model.containers.DatasetImageLink;
import ome.model.containers.Project;
import ome.model.containers.ProjectDatasetLink;
import ome.model.core.Image;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="dataset_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="dataset_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="dataset_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="dataset_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="dataset_owner_filter_PROJECTLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="dataset_group_filter_PROJECTLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="dataset_event_filter_PROJECTLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="dataset_perms_filter_PROJECTLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="dataset_owner_filter_IMAGELINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="dataset_group_filter_IMAGELINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="dataset_event_filter_IMAGELINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="dataset_perms_filter_IMAGELINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="dataset_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="dataset_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="dataset_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="dataset_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="dataset_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="dataset_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="dataset_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="dataset_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)")})
@Entity
@Table(name="dataset", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_dataset", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_dataset"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Dataset
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "dataset_owner_filter";
    public static final String GROUP_FILTER = "dataset_group_filter";
    public static final String EVENT_FILTER = "dataset_event_filter";
    public static final String PERMS_FILTER = "dataset_perms_filter";
    public static final String ID = "ome.model.containers.Dataset_id";
    protected Long id;
    public static final String VERSION = "ome.model.containers.Dataset_version";
    protected Integer version = 0;
    protected Set<ProjectDatasetLink> projectLinks = new HashSet<ProjectDatasetLink>();
    public static final String OWNER_FILTER_PROJECTLINKS = "dataset_owner_filter_PROJECTLINKS";
    public static final String GROUP_FILTER_PROJECTLINKS = "dataset_group_filter_PROJECTLINKS";
    public static final String EVENT_FILTER_PROJECTLINKS = "dataset_event_filter_PROJECTLINKS";
    public static final String PERMS_FILTER_PROJECTLINKS = "dataset_perms_filter_PROJECTLINKS";
    private Map<Long, Long> projectLinksCountPerOwner = null;
    protected Set<DatasetImageLink> imageLinks = new HashSet<DatasetImageLink>();
    public static final String OWNER_FILTER_IMAGELINKS = "dataset_owner_filter_IMAGELINKS";
    public static final String GROUP_FILTER_IMAGELINKS = "dataset_group_filter_IMAGELINKS";
    public static final String EVENT_FILTER_IMAGELINKS = "dataset_event_filter_IMAGELINKS";
    public static final String PERMS_FILTER_IMAGELINKS = "dataset_perms_filter_IMAGELINKS";
    private Map<Long, Long> imageLinksCountPerOwner = null;
    protected Set<DatasetAnnotationLink> annotationLinks = new HashSet<DatasetAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "dataset_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "dataset_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "dataset_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "dataset_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String PROJECTLINKSCOUNTPEROWNER = "ome.model.containers.Dataset_projectLinksCountPerOwner";
    public static final String PROJECTLINKS = "ome.model.containers.Dataset_projectLinks";
    public static final String IMAGELINKSCOUNTPEROWNER = "ome.model.containers.Dataset_imageLinksCountPerOwner";
    public static final String IMAGELINKS = "ome.model.containers.Dataset_imageLinks";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.containers.Dataset_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.containers.Dataset_annotationLinks";
    public static final String NAME = "ome.model.containers.Dataset_name";
    public static final String DESCRIPTION = "ome.model.containers.Dataset_description";
    public static final String DETAILS = "ome.model.containers.Dataset_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Dataset() {
        this(null, true);
    }

    protected Dataset(Long id) {
        this(id, true);
    }

    public Dataset(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Dataset(String _name) {
        this(null, true);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_dataset")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="dataset_owner_filter_PROJECTLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="dataset_group_filter_PROJECTLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="dataset_event_filter_PROJECTLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="dataset_perms_filter_PROJECTLINKS", condition=":permsStr = permissions")})
    protected Set<ProjectDatasetLink> getProjectLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.projectLinks;
    }

    protected void setProjectLinks(Set<ProjectDatasetLink> projectLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.projectLinks = projectLinks;
    }

    public int sizeOfProjectLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.projectLinks == null ? -1 : this.projectLinks.size();
    }

    public Iterator<ProjectDatasetLink> iterateProjectLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            return new EmptyIterator<ProjectDatasetLink>();
        }
        return this.getProjectLinks().iterator();
    }

    public Collection<ProjectDatasetLink> unmodifiableProjectLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getProjectLinks());
    }

    public <E> List<E> collectProjectLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ProjectDatasetLink> it = this.iterateProjectLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addProjectDatasetLink(ProjectDatasetLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            this.throwNullCollectionException("ProjectLinks");
        }
        this.getProjectLinks().add(target);
        if (target != null) {
            target.setChild(this);
        }
    }

    public void addProjectDatasetLinkSet(Collection<ProjectDatasetLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            this.throwNullCollectionException("ProjectLinks");
        }
        this.getProjectLinks().addAll(targets);
        for (ProjectDatasetLink target : targets) {
            if (target == null) continue;
            target.setChild(this);
        }
    }

    public void removeProjectDatasetLink(ProjectDatasetLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            this.throwNullCollectionException("ProjectLinks");
        }
        this.getProjectLinks().remove(target);
        target.setChild(null);
    }

    public void removeProjectDatasetLinkSet(Collection<ProjectDatasetLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            this.throwNullCollectionException("ProjectLinks");
        }
        this.getProjectLinks().removeAll(targets);
        for (ProjectDatasetLink target : targets) {
            target.setChild(null);
        }
    }

    public ProjectDatasetLink linkProject(Project addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ProjectDatasetLink link = new ProjectDatasetLink();
        link.link(addition, this);
        this.addProjectDatasetLink(link, true);
        return link;
    }

    public void addProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            this.throwNullCollectionException("ProjectLinks");
        }
        this.getProjectLinks().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addProjectDatasetLink(link, false);
        }
    }

    public Iterator<Project> linkedProjectIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            return new EmptyIterator<Project>();
        }
        final Iterator<ProjectDatasetLink> it = this.getProjectLinks().iterator();
        return new Iterator<Project>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Project next() {
                if (it == null) {
                    throw new NoSuchElementException("projectLinks is null; no elements.");
                }
                ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ProjectDatasetLink> findProjectDatasetLink(Project target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ProjectDatasetLink> it = this.iterateProjectLinks();
        HashSet<ProjectDatasetLink> result = new HashSet<ProjectDatasetLink>();
        while (it.hasNext()) {
            ProjectDatasetLink link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Project> linkedProjectList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Project> it = this.linkedProjectIterator();
        ArrayList<Project> list = new ArrayList<Project>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedProject(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Project> it = this.linkedProjectIterator();
        while (it.hasNext()) {
            Project obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkProject(Project removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ProjectDatasetLink> toRemove = this.findProjectDatasetLink(removal);
        Iterator<ProjectDatasetLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeProjectDatasetLink(it.next(), true);
        }
    }

    public void removeProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getProjectLinks() == null) {
            this.throwNullCollectionException("ProjectLinks");
        }
        this.getProjectLinks().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeProjectDatasetLink(link, false);
        }
    }

    public void clearProjectLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ProjectDatasetLink> list = new ArrayList<ProjectDatasetLink>(this.getProjectLinks());
        for (ProjectDatasetLink link : list) {
            this.removeProjectDatasetLink(link, true);
        }
    }

    protected void setProjectLinksCountPerOwner(Map<Long, Long> map) {
        this.projectLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Dataset_projectLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Dataset_projectLinks_by_owner", joinColumns={@JoinColumn(name="Dataset_id")})
    public Map<Long, Long> getProjectLinksCountPerOwner() {
        return this.projectLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="dataset_owner_filter_IMAGELINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="dataset_group_filter_IMAGELINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="dataset_event_filter_IMAGELINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="dataset_perms_filter_IMAGELINKS", condition=":permsStr = permissions")})
    protected Set<DatasetImageLink> getImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imageLinks;
    }

    protected void setImageLinks(Set<DatasetImageLink> imageLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.imageLinks = imageLinks;
    }

    public int sizeOfImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imageLinks == null ? -1 : this.imageLinks.size();
    }

    public Iterator<DatasetImageLink> iterateImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            return new EmptyIterator<DatasetImageLink>();
        }
        return this.getImageLinks().iterator();
    }

    public Collection<DatasetImageLink> unmodifiableImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getImageLinks());
    }

    public <E> List<E> collectImageLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<DatasetImageLink> it = this.iterateImageLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addDatasetImageLink(DatasetImageLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addDatasetImageLinkSet(Collection<DatasetImageLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().addAll(targets);
        for (DatasetImageLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeDatasetImageLink(DatasetImageLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().remove(target);
        target.setParent(null);
    }

    public void removeDatasetImageLinkSet(Collection<DatasetImageLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().removeAll(targets);
        for (DatasetImageLink target : targets) {
            target.setParent(null);
        }
    }

    public DatasetImageLink linkImage(Image addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        DatasetImageLink link = new DatasetImageLink();
        link.link(this, addition);
        this.addDatasetImageLink(link, true);
        return link;
    }

    public void addDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addDatasetImageLink(link, false);
        }
    }

    public Iterator<Image> linkedImageIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            return new EmptyIterator<Image>();
        }
        final Iterator<DatasetImageLink> it = this.getImageLinks().iterator();
        return new Iterator<Image>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Image next() {
                if (it == null) {
                    throw new NoSuchElementException("imageLinks is null; no elements.");
                }
                DatasetImageLink link = (DatasetImageLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<DatasetImageLink> findDatasetImageLink(Image target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<DatasetImageLink> it = this.iterateImageLinks();
        HashSet<DatasetImageLink> result = new HashSet<DatasetImageLink>();
        while (it.hasNext()) {
            DatasetImageLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Image> linkedImageList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Image> it = this.linkedImageIterator();
        ArrayList<Image> list = new ArrayList<Image>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedImage(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Image> it = this.linkedImageIterator();
        while (it.hasNext()) {
            Image obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkImage(Image removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<DatasetImageLink> toRemove = this.findDatasetImageLink(removal);
        Iterator<DatasetImageLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDatasetImageLink(it.next(), true);
        }
    }

    public void removeDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeDatasetImageLink(link, false);
        }
    }

    public void clearImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<DatasetImageLink> list = new ArrayList<DatasetImageLink>(this.getImageLinks());
        for (DatasetImageLink link : list) {
            this.removeDatasetImageLink(link, true);
        }
    }

    protected void setImageLinksCountPerOwner(Map<Long, Long> map) {
        this.imageLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Dataset_imageLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Dataset_imageLinks_by_owner", joinColumns={@JoinColumn(name="Dataset_id")})
    public Map<Long, Long> getImageLinksCountPerOwner() {
        return this.imageLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="dataset_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="dataset_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="dataset_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="dataset_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<DatasetAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<DatasetAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<DatasetAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<DatasetAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<DatasetAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<DatasetAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addDatasetAnnotationLink(DatasetAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addDatasetAnnotationLinkSet(Collection<DatasetAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (DatasetAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeDatasetAnnotationLink(DatasetAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeDatasetAnnotationLinkSet(Collection<DatasetAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (DatasetAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public DatasetAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        DatasetAnnotationLink link = new DatasetAnnotationLink();
        link.link(this, addition);
        this.addDatasetAnnotationLink(link, true);
        return link;
    }

    public void addDatasetAnnotationLink(DatasetAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<DatasetAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                DatasetAnnotationLink link = (DatasetAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<DatasetAnnotationLink> findDatasetAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<DatasetAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<DatasetAnnotationLink> result = new HashSet<DatasetAnnotationLink>();
        while (it.hasNext()) {
            DatasetAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<DatasetAnnotationLink> toRemove = this.findDatasetAnnotationLink(removal);
        Iterator<DatasetAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDatasetAnnotationLink(it.next(), true);
        }
    }

    public void removeDatasetAnnotationLink(DatasetAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<DatasetAnnotationLink> list = new ArrayList<DatasetAnnotationLink>(this.getAnnotationLinks());
        for (DatasetAnnotationLink link : list) {
            this.removeDatasetAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Dataset_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Dataset_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Dataset_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Dataset newInstance() {
        return new Dataset();
    }

    public Dataset proxy() {
        return new Dataset(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.projectLinksCountPerOwner = __filter.filter(PROJECTLINKSCOUNTPEROWNER, this.projectLinksCountPerOwner);
            this.projectLinks = (Set)__filter.filter(PROJECTLINKS, this.projectLinks);
            this.imageLinksCountPerOwner = __filter.filter(IMAGELINKSCOUNTPEROWNER, this.imageLinksCountPerOwner);
            this.imageLinks = (Set)__filter.filter(IMAGELINKS, this.imageLinks);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(PROJECTLINKSCOUNTPEROWNER)) {
            return this.getProjectLinksCountPerOwner();
        }
        if (field.equals(PROJECTLINKS)) {
            return this.getProjectLinks();
        }
        if (field.equals(IMAGELINKSCOUNTPEROWNER)) {
            return this.getImageLinksCountPerOwner();
        }
        if (field.equals(IMAGELINKS)) {
            return this.getImageLinks();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(PROJECTLINKSCOUNTPEROWNER)) {
            this.setProjectLinksCountPerOwner((Map)value);
        } else if (field.equals(PROJECTLINKS)) {
            this.setProjectLinks((Set)value);
        } else if (field.equals(IMAGELINKSCOUNTPEROWNER)) {
            this.setImageLinksCountPerOwner((Map)value);
        } else if (field.equals(IMAGELINKS)) {
            this.setImageLinks((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.projectLinksCountPerOwner = null;
        this.projectLinks = null;
        this.imageLinksCountPerOwner = null;
        this.imageLinks = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(PROJECTLINKSCOUNTPEROWNER);
        raw.add(PROJECTLINKS);
        raw.add(IMAGELINKSCOUNTPEROWNER);
        raw.add(IMAGELINKS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKdataset_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKdataset_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKdataset_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKdataset_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKdataset_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

