/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.FolderAnnotationLink;
import ome.model.containers.FolderImageLink;
import ome.model.containers.FolderRoiLink;
import ome.model.core.Image;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.roi.Roi;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="folder_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="folder_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="folder_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="folder_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="folder_owner_filter_CHILDFOLDERS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="folder_group_filter_CHILDFOLDERS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="folder_event_filter_CHILDFOLDERS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="folder_perms_filter_CHILDFOLDERS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="folder_owner_filter_IMAGELINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="folder_group_filter_IMAGELINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="folder_event_filter_IMAGELINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="folder_perms_filter_IMAGELINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="folder_owner_filter_ROILINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="folder_group_filter_ROILINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="folder_event_filter_ROILINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="folder_perms_filter_ROILINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="folder_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="folder_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="folder_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="folder_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="folder_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="folder_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="folder_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="folder_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)")})
@Entity
@Table(name="folder", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_folder", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_folder"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Folder
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "folder_owner_filter";
    public static final String GROUP_FILTER = "folder_group_filter";
    public static final String EVENT_FILTER = "folder_event_filter";
    public static final String PERMS_FILTER = "folder_perms_filter";
    public static final String ID = "ome.model.containers.Folder_id";
    protected Long id;
    public static final String VERSION = "ome.model.containers.Folder_version";
    protected Integer version = 0;
    protected Set<Folder> childFolders = new HashSet<Folder>();
    public static final String OWNER_FILTER_CHILDFOLDERS = "folder_owner_filter_CHILDFOLDERS";
    public static final String GROUP_FILTER_CHILDFOLDERS = "folder_group_filter_CHILDFOLDERS";
    public static final String EVENT_FILTER_CHILDFOLDERS = "folder_event_filter_CHILDFOLDERS";
    public static final String PERMS_FILTER_CHILDFOLDERS = "folder_perms_filter_CHILDFOLDERS";
    protected Folder parentFolder = null;
    protected Set<FolderImageLink> imageLinks = new HashSet<FolderImageLink>();
    public static final String OWNER_FILTER_IMAGELINKS = "folder_owner_filter_IMAGELINKS";
    public static final String GROUP_FILTER_IMAGELINKS = "folder_group_filter_IMAGELINKS";
    public static final String EVENT_FILTER_IMAGELINKS = "folder_event_filter_IMAGELINKS";
    public static final String PERMS_FILTER_IMAGELINKS = "folder_perms_filter_IMAGELINKS";
    private Map<Long, Long> imageLinksCountPerOwner = null;
    protected Set<FolderRoiLink> roiLinks = new HashSet<FolderRoiLink>();
    public static final String OWNER_FILTER_ROILINKS = "folder_owner_filter_ROILINKS";
    public static final String GROUP_FILTER_ROILINKS = "folder_group_filter_ROILINKS";
    public static final String EVENT_FILTER_ROILINKS = "folder_event_filter_ROILINKS";
    public static final String PERMS_FILTER_ROILINKS = "folder_perms_filter_ROILINKS";
    private Map<Long, Long> roiLinksCountPerOwner = null;
    protected Set<FolderAnnotationLink> annotationLinks = new HashSet<FolderAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "folder_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "folder_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "folder_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "folder_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected String description = null;
    protected ome.model.internal.Details details = new Details();
    public static final String CHILDFOLDERS = "ome.model.containers.Folder_childFolders";
    public static final String PARENTFOLDER = "ome.model.containers.Folder_parentFolder";
    public static final String IMAGELINKSCOUNTPEROWNER = "ome.model.containers.Folder_imageLinksCountPerOwner";
    public static final String IMAGELINKS = "ome.model.containers.Folder_imageLinks";
    public static final String ROILINKSCOUNTPEROWNER = "ome.model.containers.Folder_roiLinksCountPerOwner";
    public static final String ROILINKS = "ome.model.containers.Folder_roiLinks";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.containers.Folder_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.containers.Folder_annotationLinks";
    public static final String NAME = "ome.model.containers.Folder_name";
    public static final String DESCRIPTION = "ome.model.containers.Folder_description";
    public static final String DETAILS = "ome.model.containers.Folder_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Folder() {
        this(null, true);
    }

    protected Folder(Long id) {
        this(id, true);
    }

    public Folder(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Folder(String _name) {
        this(null, true);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_folder")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @OneToMany(mappedBy="parentFolder", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="folder_owner_filter_CHILDFOLDERS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="folder_group_filter_CHILDFOLDERS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="folder_event_filter_CHILDFOLDERS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="folder_perms_filter_CHILDFOLDERS", condition=":permsStr = permissions")})
    protected Set<Folder> getChildFolders() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.childFolders;
    }

    protected void setChildFolders(Set<Folder> childFolders) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.childFolders = childFolders;
    }

    public int sizeOfChildFolders() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.childFolders == null ? -1 : this.childFolders.size();
    }

    public Iterator<Folder> iterateChildFolders() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            return new EmptyIterator<Folder>();
        }
        return this.getChildFolders().iterator();
    }

    public Collection<Folder> unmodifiableChildFolders() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getChildFolders());
    }

    public <E> List<E> collectChildFolders(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Folder> it = this.iterateChildFolders();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addChildFolders(Folder target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            this.throwNullCollectionException("ChildFolders");
        }
        this.getChildFolders().add(target);
        if (target != null) {
            target.setParentFolder(this);
        }
    }

    public void addChildFoldersSet(Collection<Folder> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            this.throwNullCollectionException("ChildFolders");
        }
        this.getChildFolders().addAll(targets);
        for (Folder target : targets) {
            if (target == null) continue;
            target.setParentFolder(this);
        }
    }

    public void removeChildFolders(Folder target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            this.throwNullCollectionException("ChildFolders");
        }
        this.getChildFolders().remove(target);
        target.setParentFolder(null);
    }

    public void removeChildFoldersSet(Collection<Folder> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            this.throwNullCollectionException("ChildFolders");
        }
        this.getChildFolders().removeAll(targets);
        for (Folder target : targets) {
            target.setParentFolder(null);
        }
    }

    public void clearChildFolders() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChildFolders() == null) {
            this.throwNullCollectionException("ChildFolders");
        }
        this.getChildFolders().clear();
        Iterator<Folder> it = this.iterateChildFolders();
        while (it.hasNext()) {
            Folder target = it.next();
            target.setParentFolder(null);
        }
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Folder.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="parentFolder", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKfolder_parentFolder_folder")
    public Folder getParentFolder() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.parentFolder;
    }

    public void setParentFolder(Folder parentFolder) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.parentFolder = parentFolder;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="folder_owner_filter_IMAGELINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="folder_group_filter_IMAGELINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="folder_event_filter_IMAGELINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="folder_perms_filter_IMAGELINKS", condition=":permsStr = permissions")})
    protected Set<FolderImageLink> getImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imageLinks;
    }

    protected void setImageLinks(Set<FolderImageLink> imageLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.imageLinks = imageLinks;
    }

    public int sizeOfImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.imageLinks == null ? -1 : this.imageLinks.size();
    }

    public Iterator<FolderImageLink> iterateImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            return new EmptyIterator<FolderImageLink>();
        }
        return this.getImageLinks().iterator();
    }

    public Collection<FolderImageLink> unmodifiableImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getImageLinks());
    }

    public <E> List<E> collectImageLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FolderImageLink> it = this.iterateImageLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFolderImageLink(FolderImageLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFolderImageLinkSet(Collection<FolderImageLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().addAll(targets);
        for (FolderImageLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFolderImageLink(FolderImageLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().remove(target);
        target.setParent(null);
    }

    public void removeFolderImageLinkSet(Collection<FolderImageLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().removeAll(targets);
        for (FolderImageLink target : targets) {
            target.setParent(null);
        }
    }

    public FolderImageLink linkImage(Image addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FolderImageLink link = new FolderImageLink();
        link.link(this, addition);
        this.addFolderImageLink(link, true);
        return link;
    }

    public void addFolderImageLink(FolderImageLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addFolderImageLink(link, false);
        }
    }

    public Iterator<Image> linkedImageIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            return new EmptyIterator<Image>();
        }
        final Iterator<FolderImageLink> it = this.getImageLinks().iterator();
        return new Iterator<Image>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Image next() {
                if (it == null) {
                    throw new NoSuchElementException("imageLinks is null; no elements.");
                }
                FolderImageLink link = (FolderImageLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FolderImageLink> findFolderImageLink(Image target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FolderImageLink> it = this.iterateImageLinks();
        HashSet<FolderImageLink> result = new HashSet<FolderImageLink>();
        while (it.hasNext()) {
            FolderImageLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Image> linkedImageList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Image> it = this.linkedImageIterator();
        ArrayList<Image> list = new ArrayList<Image>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedImage(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Image> it = this.linkedImageIterator();
        while (it.hasNext()) {
            Image obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkImage(Image removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FolderImageLink> toRemove = this.findFolderImageLink(removal);
        Iterator<FolderImageLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderImageLink(it.next(), true);
        }
    }

    public void removeFolderImageLink(FolderImageLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImageLinks() == null) {
            this.throwNullCollectionException("ImageLinks");
        }
        this.getImageLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeFolderImageLink(link, false);
        }
    }

    public void clearImageLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FolderImageLink> list = new ArrayList<FolderImageLink>(this.getImageLinks());
        for (FolderImageLink link : list) {
            this.removeFolderImageLink(link, true);
        }
    }

    protected void setImageLinksCountPerOwner(Map<Long, Long> map) {
        this.imageLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Folder_imageLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Folder_imageLinks_by_owner", joinColumns={@JoinColumn(name="Folder_id")})
    public Map<Long, Long> getImageLinksCountPerOwner() {
        return this.imageLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="folder_owner_filter_ROILINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="folder_group_filter_ROILINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="folder_event_filter_ROILINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="folder_perms_filter_ROILINKS", condition=":permsStr = permissions")})
    protected Set<FolderRoiLink> getRoiLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.roiLinks;
    }

    protected void setRoiLinks(Set<FolderRoiLink> roiLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.roiLinks = roiLinks;
    }

    public int sizeOfRoiLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.roiLinks == null ? -1 : this.roiLinks.size();
    }

    public Iterator<FolderRoiLink> iterateRoiLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            return new EmptyIterator<FolderRoiLink>();
        }
        return this.getRoiLinks().iterator();
    }

    public Collection<FolderRoiLink> unmodifiableRoiLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getRoiLinks());
    }

    public <E> List<E> collectRoiLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FolderRoiLink> it = this.iterateRoiLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFolderRoiLink(FolderRoiLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            this.throwNullCollectionException("RoiLinks");
        }
        this.getRoiLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFolderRoiLinkSet(Collection<FolderRoiLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            this.throwNullCollectionException("RoiLinks");
        }
        this.getRoiLinks().addAll(targets);
        for (FolderRoiLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFolderRoiLink(FolderRoiLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            this.throwNullCollectionException("RoiLinks");
        }
        this.getRoiLinks().remove(target);
        target.setParent(null);
    }

    public void removeFolderRoiLinkSet(Collection<FolderRoiLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            this.throwNullCollectionException("RoiLinks");
        }
        this.getRoiLinks().removeAll(targets);
        for (FolderRoiLink target : targets) {
            target.setParent(null);
        }
    }

    public FolderRoiLink linkRoi(Roi addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FolderRoiLink link = new FolderRoiLink();
        link.link(this, addition);
        this.addFolderRoiLink(link, true);
        return link;
    }

    public void addFolderRoiLink(FolderRoiLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            this.throwNullCollectionException("RoiLinks");
        }
        this.getRoiLinks().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addFolderRoiLink(link, false);
        }
    }

    public Iterator<Roi> linkedRoiIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            return new EmptyIterator<Roi>();
        }
        final Iterator<FolderRoiLink> it = this.getRoiLinks().iterator();
        return new Iterator<Roi>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Roi next() {
                if (it == null) {
                    throw new NoSuchElementException("roiLinks is null; no elements.");
                }
                FolderRoiLink link = (FolderRoiLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FolderRoiLink> findFolderRoiLink(Roi target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FolderRoiLink> it = this.iterateRoiLinks();
        HashSet<FolderRoiLink> result = new HashSet<FolderRoiLink>();
        while (it.hasNext()) {
            FolderRoiLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Roi> linkedRoiList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Roi> it = this.linkedRoiIterator();
        ArrayList<Roi> list = new ArrayList<Roi>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedRoi(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Roi> it = this.linkedRoiIterator();
        while (it.hasNext()) {
            Roi obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkRoi(Roi removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FolderRoiLink> toRemove = this.findFolderRoiLink(removal);
        Iterator<FolderRoiLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderRoiLink(it.next(), true);
        }
    }

    public void removeFolderRoiLink(FolderRoiLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getRoiLinks() == null) {
            this.throwNullCollectionException("RoiLinks");
        }
        this.getRoiLinks().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removeFolderRoiLink(link, false);
        }
    }

    public void clearRoiLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FolderRoiLink> list = new ArrayList<FolderRoiLink>(this.getRoiLinks());
        for (FolderRoiLink link : list) {
            this.removeFolderRoiLink(link, true);
        }
    }

    protected void setRoiLinksCountPerOwner(Map<Long, Long> map) {
        this.roiLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Folder_roiLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Folder_roiLinks_by_owner", joinColumns={@JoinColumn(name="Folder_id")})
    public Map<Long, Long> getRoiLinksCountPerOwner() {
        return this.roiLinksCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="folder_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="folder_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="folder_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="folder_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<FolderAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<FolderAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<FolderAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<FolderAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<FolderAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FolderAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFolderAnnotationLink(FolderAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFolderAnnotationLinkSet(Collection<FolderAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (FolderAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFolderAnnotationLink(FolderAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeFolderAnnotationLinkSet(Collection<FolderAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (FolderAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public FolderAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FolderAnnotationLink link = new FolderAnnotationLink();
        link.link(this, addition);
        this.addFolderAnnotationLink(link, true);
        return link;
    }

    public void addFolderAnnotationLink(FolderAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<FolderAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                FolderAnnotationLink link = (FolderAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FolderAnnotationLink> findFolderAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FolderAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<FolderAnnotationLink> result = new HashSet<FolderAnnotationLink>();
        while (it.hasNext()) {
            FolderAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FolderAnnotationLink> toRemove = this.findFolderAnnotationLink(removal);
        Iterator<FolderAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderAnnotationLink(it.next(), true);
        }
    }

    public void removeFolderAnnotationLink(FolderAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FolderAnnotationLink> list = new ArrayList<FolderAnnotationLink>(this.getAnnotationLinks());
        for (FolderAnnotationLink link : list) {
            this.removeFolderAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Folder_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Folder_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Folder_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="description", updatable=true)
    public String getDescription() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.description;
    }

    public void setDescription(String description) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.description = description;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Folder newInstance() {
        return new Folder();
    }

    public Folder proxy() {
        return new Folder(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.childFolders = (Set)__filter.filter(CHILDFOLDERS, this.childFolders);
            this.parentFolder = (Folder)__filter.filter(PARENTFOLDER, this.parentFolder);
            this.imageLinksCountPerOwner = __filter.filter(IMAGELINKSCOUNTPEROWNER, this.imageLinksCountPerOwner);
            this.imageLinks = (Set)__filter.filter(IMAGELINKS, this.imageLinks);
            this.roiLinksCountPerOwner = __filter.filter(ROILINKSCOUNTPEROWNER, this.roiLinksCountPerOwner);
            this.roiLinks = (Set)__filter.filter(ROILINKS, this.roiLinks);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.description = (String)__filter.filter(DESCRIPTION, this.description);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(CHILDFOLDERS)) {
            return this.getChildFolders();
        }
        if (field.equals(PARENTFOLDER)) {
            return this.getParentFolder();
        }
        if (field.equals(IMAGELINKSCOUNTPEROWNER)) {
            return this.getImageLinksCountPerOwner();
        }
        if (field.equals(IMAGELINKS)) {
            return this.getImageLinks();
        }
        if (field.equals(ROILINKSCOUNTPEROWNER)) {
            return this.getRoiLinksCountPerOwner();
        }
        if (field.equals(ROILINKS)) {
            return this.getRoiLinks();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(CHILDFOLDERS)) {
            this.setChildFolders((Set)value);
        } else if (field.equals(PARENTFOLDER)) {
            this.setParentFolder((Folder)value);
        } else if (field.equals(IMAGELINKSCOUNTPEROWNER)) {
            this.setImageLinksCountPerOwner((Map)value);
        } else if (field.equals(IMAGELINKS)) {
            this.setImageLinks((Set)value);
        } else if (field.equals(ROILINKSCOUNTPEROWNER)) {
            this.setRoiLinksCountPerOwner((Map)value);
        } else if (field.equals(ROILINKS)) {
            this.setRoiLinks((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.childFolders = null;
        this.parentFolder = null;
        this.imageLinksCountPerOwner = null;
        this.imageLinks = null;
        this.roiLinksCountPerOwner = null;
        this.roiLinks = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.description = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(CHILDFOLDERS);
        raw.add(PARENTFOLDER);
        raw.add(IMAGELINKSCOUNTPEROWNER);
        raw.add(IMAGELINKS);
        raw.add(ROILINKSCOUNTPEROWNER);
        raw.add(ROILINKS);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKfolder_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfolder_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKfolder_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfolder_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfolder_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

