/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.PlaneInfoAnnotationLink;
import ome.model.core.Pixels;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.units.Length;
import ome.model.units.Time;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="planeinfo_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="planeinfo_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="planeinfo_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="planeinfo_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="planeinfo_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="planeinfo_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="planeinfo_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="planeinfo_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="planeinfo_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="planeinfo_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="planeinfo_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="planeinfo_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT planeinfo.id FROM planeinfo*, pixels* WHERE planeinfo.pixels = pixels.id AND pixels.image IN (:images)))")})
@Entity
@Table(name="planeinfo", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_planeinfo", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_planeinfo"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class PlaneInfo
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "planeinfo_owner_filter";
    public static final String GROUP_FILTER = "planeinfo_group_filter";
    public static final String EVENT_FILTER = "planeinfo_event_filter";
    public static final String PERMS_FILTER = "planeinfo_perms_filter";
    public static final String ID = "ome.model.core.PlaneInfo_id";
    protected Long id;
    public static final String VERSION = "ome.model.core.PlaneInfo_version";
    protected Integer version = 0;
    protected Pixels pixels = null;
    protected Integer theZ = null;
    protected Integer theC = null;
    protected Integer theT = null;
    protected Time deltaT = null;
    protected Length positionX = null;
    protected Length positionY = null;
    protected Length positionZ = null;
    protected Time exposureTime = null;
    protected Set<PlaneInfoAnnotationLink> annotationLinks = new HashSet<PlaneInfoAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "planeinfo_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "planeinfo_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "planeinfo_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "planeinfo_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String PIXELS = "ome.model.core.PlaneInfo_pixels";
    public static final String THEZ = "ome.model.core.PlaneInfo_theZ";
    public static final String THEC = "ome.model.core.PlaneInfo_theC";
    public static final String THET = "ome.model.core.PlaneInfo_theT";
    public static final String DELTAT = "ome.model.core.PlaneInfo_deltaT";
    public static final String POSITIONX = "ome.model.core.PlaneInfo_positionX";
    public static final String POSITIONY = "ome.model.core.PlaneInfo_positionY";
    public static final String POSITIONZ = "ome.model.core.PlaneInfo_positionZ";
    public static final String EXPOSURETIME = "ome.model.core.PlaneInfo_exposureTime";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.core.PlaneInfo_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.core.PlaneInfo_annotationLinks";
    public static final String DETAILS = "ome.model.core.PlaneInfo_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public PlaneInfo() {
        this(null, true);
    }

    protected PlaneInfo(Long id) {
        this(id, true);
    }

    public PlaneInfo(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public PlaneInfo(Pixels _pixels, Integer _theZ, Integer _theC, Integer _theT) {
        this(null, true);
        this.setPixels(_pixels);
        this.setTheZ(_theZ);
        this.setTheC(_theC);
        this.setTheT(_theT);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_planeinfo")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Pixels.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="pixels", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKplaneinfo_pixels_pixels")
    public Pixels getPixels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixels = pixels;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="nonnegative_int", nullable=false, unique=false, name="theZ", updatable=true)
    public Integer getTheZ() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.theZ;
    }

    public void setTheZ(Integer theZ) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (theZ != null && theZ < 0) {
            throw new IllegalArgumentException("values of PlaneInfo.theZ must not be negative");
        }
        this.theZ = theZ;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="nonnegative_int", nullable=false, unique=false, name="theC", updatable=true)
    public Integer getTheC() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.theC;
    }

    public void setTheC(Integer theC) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (theC != null && theC < 0) {
            throw new IllegalArgumentException("values of PlaneInfo.theC must not be negative");
        }
        this.theC = theC;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="nonnegative_int", nullable=false, unique=false, name="theT", updatable=true)
    public Integer getTheT() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.theT;
    }

    public void setTheT(Integer theT) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (theT != null && theT < 0) {
            throw new IllegalArgumentException("values of PlaneInfo.theT must not be negative");
        }
        this.theT = theT;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="deltaT")), @AttributeOverride(name="unit", column=@Column(name="deltaTUnit"))})
    public Time getDeltaT() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.deltaT;
    }

    public void setDeltaT(Time deltaT) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.deltaT = deltaT;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="positionX")), @AttributeOverride(name="unit", column=@Column(name="positionXUnit"))})
    public Length getPositionX() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.positionX;
    }

    public void setPositionX(Length positionX) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.positionX = positionX;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="positionY")), @AttributeOverride(name="unit", column=@Column(name="positionYUnit"))})
    public Length getPositionY() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.positionY;
    }

    public void setPositionY(Length positionY) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.positionY = positionY;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="positionZ")), @AttributeOverride(name="unit", column=@Column(name="positionZUnit"))})
    public Length getPositionZ() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.positionZ;
    }

    public void setPositionZ(Length positionZ) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.positionZ = positionZ;
    }

    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="value", column=@Column(name="exposureTime")), @AttributeOverride(name="unit", column=@Column(name="exposureTimeUnit"))})
    public Time getExposureTime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.exposureTime;
    }

    public void setExposureTime(Time exposureTime) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.exposureTime = exposureTime;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="planeinfo_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="planeinfo_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="planeinfo_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="planeinfo_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<PlaneInfoAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<PlaneInfoAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<PlaneInfoAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<PlaneInfoAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<PlaneInfoAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<PlaneInfoAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPlaneInfoAnnotationLink(PlaneInfoAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addPlaneInfoAnnotationLinkSet(Collection<PlaneInfoAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (PlaneInfoAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removePlaneInfoAnnotationLink(PlaneInfoAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removePlaneInfoAnnotationLinkSet(Collection<PlaneInfoAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (PlaneInfoAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public PlaneInfoAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        PlaneInfoAnnotationLink link = new PlaneInfoAnnotationLink();
        link.link(this, addition);
        this.addPlaneInfoAnnotationLink(link, true);
        return link;
    }

    public void addPlaneInfoAnnotationLink(PlaneInfoAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<PlaneInfoAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                PlaneInfoAnnotationLink link = (PlaneInfoAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<PlaneInfoAnnotationLink> findPlaneInfoAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<PlaneInfoAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<PlaneInfoAnnotationLink> result = new HashSet<PlaneInfoAnnotationLink>();
        while (it.hasNext()) {
            PlaneInfoAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<PlaneInfoAnnotationLink> toRemove = this.findPlaneInfoAnnotationLink(removal);
        Iterator<PlaneInfoAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePlaneInfoAnnotationLink(it.next(), true);
        }
    }

    public void removePlaneInfoAnnotationLink(PlaneInfoAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<PlaneInfoAnnotationLink> list = new ArrayList<PlaneInfoAnnotationLink>(this.getAnnotationLinks());
        for (PlaneInfoAnnotationLink link : list) {
            this.removePlaneInfoAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_PlaneInfo_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_PlaneInfo_annotationLinks_by_owner", joinColumns={@JoinColumn(name="PlaneInfo_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public PlaneInfo newInstance() {
        return new PlaneInfo();
    }

    public PlaneInfo proxy() {
        return new PlaneInfo(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.pixels = (Pixels)__filter.filter(PIXELS, this.pixels);
            this.theZ = (Integer)__filter.filter(THEZ, this.theZ);
            this.theC = (Integer)__filter.filter(THEC, this.theC);
            this.theT = (Integer)__filter.filter(THET, this.theT);
            this.deltaT = (Time)__filter.filter(DELTAT, this.deltaT);
            this.positionX = (Length)__filter.filter(POSITIONX, this.positionX);
            this.positionY = (Length)__filter.filter(POSITIONY, this.positionY);
            this.positionZ = (Length)__filter.filter(POSITIONZ, this.positionZ);
            this.exposureTime = (Time)__filter.filter(EXPOSURETIME, this.exposureTime);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(PIXELS)) {
            return this.getPixels();
        }
        if (field.equals(THEZ)) {
            return this.getTheZ();
        }
        if (field.equals(THEC)) {
            return this.getTheC();
        }
        if (field.equals(THET)) {
            return this.getTheT();
        }
        if (field.equals(DELTAT)) {
            return this.getDeltaT();
        }
        if (field.equals(POSITIONX)) {
            return this.getPositionX();
        }
        if (field.equals(POSITIONY)) {
            return this.getPositionY();
        }
        if (field.equals(POSITIONZ)) {
            return this.getPositionZ();
        }
        if (field.equals(EXPOSURETIME)) {
            return this.getExposureTime();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(PIXELS)) {
            this.setPixels((Pixels)value);
        } else if (field.equals(THEZ)) {
            this.setTheZ((Integer)value);
        } else if (field.equals(THEC)) {
            this.setTheC((Integer)value);
        } else if (field.equals(THET)) {
            this.setTheT((Integer)value);
        } else if (field.equals(DELTAT)) {
            this.setDeltaT((Time)value);
        } else if (field.equals(POSITIONX)) {
            this.setPositionX((Length)value);
        } else if (field.equals(POSITIONY)) {
            this.setPositionY((Length)value);
        } else if (field.equals(POSITIONZ)) {
            this.setPositionZ((Length)value);
        } else if (field.equals(EXPOSURETIME)) {
            this.setExposureTime((Time)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.pixels = null;
        this.theZ = null;
        this.theC = null;
        this.theT = null;
        this.deltaT = null;
        this.positionX = null;
        this.positionY = null;
        this.positionZ = null;
        this.exposureTime = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(PIXELS);
        raw.add(THEZ);
        raw.add(THEC);
        raw.add(THET);
        raw.add(DELTAT);
        raw.add(POSITIONX);
        raw.add(POSITIONY);
        raw.add(POSITIONZ);
        raw.add(EXPOSURETIME);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKplaneinfo_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKplaneinfo_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKplaneinfo_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKplaneinfo_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKplaneinfo_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

