/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.ExtSSTRecord;
import loci.poi.hssf.record.SSTRecordHeader;
import loci.poi.hssf.record.UnicodeString;
import loci.poi.util.IntMapper;
import loci.poi.util.LittleEndian;

class SSTSerializer {
    private IntMapper strings;
    private SSTRecordHeader sstRecordHeader;
    int[] bucketAbsoluteOffsets;
    int[] bucketRelativeOffsets;
    int startOfSST;
    int startOfRecord;

    public SSTSerializer(IntMapper strings, int numStrings, int numUniqueStrings) {
        this.strings = strings;
        this.sstRecordHeader = new SSTRecordHeader(numStrings, numUniqueStrings);
        int infoRecs = ExtSSTRecord.getNumberOfInfoRecsForStrings(strings.size());
        this.bucketAbsoluteOffsets = new int[infoRecs];
        this.bucketRelativeOffsets = new int[infoRecs];
    }

    public int serialize(int offset, byte[] data) {
        UnicodeString.UnicodeRecordStats stats = new UnicodeString.UnicodeRecordStats();
        this.sstRecordHeader.writeSSTHeader(stats, data, 0 + offset, 0);
        int pos = offset + 12;
        for (int k = 0; k < this.strings.size(); ++k) {
            int index;
            if (k % 8 == 0 && (index = k / 8) < 128) {
                this.bucketAbsoluteOffsets[index] = pos - offset;
                this.bucketRelativeOffsets[index] = pos - offset;
            }
            UnicodeString s = this.getUnicodeString(k);
            pos += s.serialize(stats, pos, data);
        }
        if (stats.lastLengthPos != -1) {
            short lastRecordLength = (short)(pos - stats.lastLengthPos - 2);
            if (lastRecordLength > 8224) {
                throw new InternalError();
            }
            LittleEndian.putShort(data, stats.lastLengthPos, lastRecordLength);
        }
        return pos - offset;
    }

    private UnicodeString getUnicodeString(int index) {
        return SSTSerializer.getUnicodeString(this.strings, index);
    }

    private static UnicodeString getUnicodeString(IntMapper strings, int index) {
        return (UnicodeString)strings.get(index);
    }

    public int[] getBucketAbsoluteOffsets() {
        return this.bucketAbsoluteOffsets;
    }

    public int[] getBucketRelativeOffsets() {
        return this.bucketRelativeOffsets;
    }
}

