/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.HuffmanCodecOptions;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.codec.MJPBCodecOptions;
import ome.codecs.Codec;
import ome.codecs.CodecException;

class WrappedCodec
extends BaseCodec {
    protected Codec codec = null;

    protected WrappedCodec(Codec codec) {
        this.codec = codec;
    }

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        try {
            return this.codec.compress(data, WrappedCodec.getOptions(options));
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    @Override
    public byte[] compress(byte[][] data, CodecOptions options) throws FormatException {
        try {
            return this.codec.compress(data, WrappedCodec.getOptions(options));
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    @Override
    public byte[] decompress(byte[] data, CodecOptions options) throws FormatException {
        try {
            return this.codec.decompress(data, WrappedCodec.getOptions(options));
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    @Override
    public byte[] decompress(byte[][] data, CodecOptions options) throws FormatException {
        try {
            return this.codec.decompress(data, WrappedCodec.getOptions(options));
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    @Override
    public byte[] decompress(byte[] data) throws FormatException {
        try {
            return this.codec.decompress(data);
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    @Override
    public byte[] decompress(byte[][] data) throws FormatException {
        try {
            return this.codec.decompress(data);
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        try {
            return this.codec.decompress(in, WrappedCodec.getOptions(options));
        }
        catch (CodecException e) {
            throw WrappedCodec.unwrapCodecException(e);
        }
    }

    private static void copyOptions(CodecOptions src, ome.codecs.CodecOptions dest) throws FormatException {
        dest.width = src.width;
        dest.height = src.height;
        dest.channels = src.channels;
        dest.bitsPerSample = src.bitsPerSample;
        dest.littleEndian = src.littleEndian;
        dest.interleaved = src.interleaved;
        dest.signed = src.signed;
        dest.maxBytes = src.maxBytes;
        dest.previousImage = src.previousImage;
        dest.lossless = src.lossless;
        dest.colorModel = src.colorModel;
        dest.quality = src.quality;
        dest.tileWidth = src.tileWidth;
        dest.tileHeight = src.tileHeight;
        dest.tileGridXOffset = src.tileGridXOffset;
        dest.tileGridYOffset = src.tileGridYOffset;
        dest.ycbcr = src.ycbcr;
    }

    protected static ome.codecs.CodecOptions getOptions(CodecOptions options) throws FormatException {
        if (options == null) {
            return null;
        }
        ome.codecs.HuffmanCodecOptions newOptions = null;
        Class<?> c = options.getClass();
        if (c.equals(HuffmanCodecOptions.class)) {
            newOptions = new ome.codecs.HuffmanCodecOptions();
            WrappedCodec.copyOptions(options, (ome.codecs.CodecOptions)newOptions);
            newOptions.table = ((HuffmanCodecOptions)options).table;
        } else if (c.equals(JPEG2000CodecOptions.class)) {
            newOptions = new ome.codecs.JPEG2000CodecOptions();
            WrappedCodec.copyOptions(options, (ome.codecs.CodecOptions)newOptions);
            ((ome.codecs.JPEG2000CodecOptions)newOptions).codeBlockSize = ((JPEG2000CodecOptions)options).codeBlockSize;
            ((ome.codecs.JPEG2000CodecOptions)newOptions).numDecompositionLevels = ((JPEG2000CodecOptions)options).numDecompositionLevels;
            ((ome.codecs.JPEG2000CodecOptions)newOptions).resolution = ((JPEG2000CodecOptions)options).resolution;
            ((ome.codecs.JPEG2000CodecOptions)newOptions).writeBox = ((JPEG2000CodecOptions)options).writeBox;
        } else if (c.equals(MJPBCodecOptions.class)) {
            newOptions = new ome.codecs.MJPBCodecOptions();
            WrappedCodec.copyOptions(options, (ome.codecs.CodecOptions)newOptions);
            ((ome.codecs.MJPBCodecOptions)newOptions).interlaced = ((MJPBCodecOptions)options).interlaced;
        } else if (c.equals(CodecOptions.class)) {
            newOptions = new ome.codecs.CodecOptions();
            WrappedCodec.copyOptions(options, (ome.codecs.CodecOptions)newOptions);
        } else {
            throw new FormatException("Unwrapped codec: " + c.getName());
        }
        return newOptions;
    }

    static FormatException unwrapCodecException(CodecException e) {
        FormatException fe = e.getMessage() != null ? new FormatException(e.getMessage()) : new FormatException();
        if (e.getCause() != null) {
            fe.initCause(e.getCause());
        }
        fe.setStackTrace(e.getStackTrace());
        return fe;
    }
}

