/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import com.luratech.lwf.lwfDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import loci.common.services.AbstractService;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.formats.services.LuraWaveService;

public class LuraWaveServiceImpl
extends AbstractService
implements LuraWaveService {
    public static final String LICENSE_PROPERTY = "lurawave.license";
    public static final String NO_LURAWAVE_MSG = "The LuraWave decoding library, lwf_jsdk2.6.jar, is required to decode this file.\r\nPlease make sure it is present in your classpath.";
    public static final String NO_LICENSE_MSG = "No LuraWave license code was specified.\r\nPlease set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).";
    public static final String INVALID_LICENSE_MSG = "Invalid license code: ";
    public static final String STUB_FIELD = "IS_STUB";
    private transient Object delegate;
    private String license;

    public LuraWaveServiceImpl() throws DependencyException {
        this.checkClassDependency(lwfDecoder.class);
        try {
            Field isStub = lwfDecoder.class.getField(STUB_FIELD);
            if (isStub != null) {
                throw new DependencyException(NO_LURAWAVE_MSG);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    public void setLicenseCode(String license) {
        this.license = license;
    }

    @Override
    public String getLicenseCode() {
        return this.license;
    }

    @Override
    public void initialize(InputStream stream) throws IOException, DependencyException, ServiceException {
        this.initLicense();
        try {
            this.delegate = new lwfDecoder(stream, null, this.license);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public int getWidth() {
        return ((lwfDecoder)this.delegate).getWidth();
    }

    @Override
    public int getHeight() {
        return ((lwfDecoder)this.delegate).getHeight();
    }

    @Override
    public void decodeToMemoryGray8(byte[] image, int limit, int quality, int scale) throws ServiceException {
        try {
            ((lwfDecoder)this.delegate).decodeToMemoryGray8(image, limit, quality, scale);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void decodeToMemoryGray16(short[] image, int imageoffset, int limit, int quality, int scale, int pdx, int pdy, int clip_x, int clip_y, int clip_w, int clip_h) throws ServiceException {
        try {
            ((lwfDecoder)this.delegate).decodeToMemoryGray16(image, imageoffset, limit, quality, scale, pdx, pdy, clip_x, clip_y, clip_w, clip_h);
        }
        catch (SecurityException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void initLicense() throws DependencyException {
        if (this.license != null) {
            return;
        }
        this.license = System.getProperty(LICENSE_PROPERTY);
        if (this.license == null) {
            throw new DependencyException(NO_LICENSE_MSG);
        }
    }
}

