/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ReaderWrapper;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileStitcher
extends ReaderWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TileStitcher.class);
    private int tileX = 0;
    private int tileY = 0;
    private Integer[][] tileMap;

    public static TileStitcher makeTileStitcher(IFormatReader r) {
        if (r instanceof TileStitcher) {
            return (TileStitcher)r;
        }
        return new TileStitcher(r);
    }

    public TileStitcher() {
    }

    public TileStitcher(IFormatReader r) {
        super(r);
    }

    public int getSizeX() {
        return this.reader.getSizeX() * this.tileX;
    }

    public int getSizeY() {
        return this.reader.getSizeY() * this.tileY;
    }

    public int getSeriesCount() {
        if (this.tileX == 1 && this.tileY == 1) {
            return this.reader.getSeriesCount();
        }
        return 1;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int ch = this.getRGBChannelCount();
        byte[] newBuffer = DataTools.allocate((int[])new int[]{w, h, ch, bpp});
        return this.openBytes(no, newBuffer, x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        if (this.tileX == 1 && this.tileY == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        byte[] tileBuf = new byte[buf.length / this.tileX * this.tileY];
        int tw = this.reader.getSizeX();
        int th = this.reader.getSizeY();
        Region image = new Region(x, y, w, h);
        int pixelType = this.getPixelType();
        int pixel = this.getRGBChannelCount() * FormatTools.getBytesPerPixel((int)pixelType);
        int outputRowLen = w * pixel;
        int outputRow = 0;
        int outputCol = 0;
        Region intersection = null;
        for (int ty = 0; ty < this.tileY; ++ty) {
            for (int tx = 0; tx < this.tileX; ++tx) {
                Region tile = new Region(tx * tw, ty * th, tw, th);
                if (!tile.intersects(image)) continue;
                intersection = tile.intersection(image);
                int rowLen = pixel * Math.min(intersection.width, tw);
                if (this.tileMap[ty][tx] == null) {
                    outputCol += rowLen;
                    continue;
                }
                this.reader.setSeries(this.tileMap[ty][tx].intValue());
                this.reader.openBytes(no, tileBuf, 0, 0, tw, th);
                int outputOffset = outputRowLen * outputRow + outputCol;
                for (int row = 0; row < intersection.height; ++row) {
                    int realRow = row + intersection.y - tile.y;
                    int inputOffset = pixel * (realRow * tw + tx);
                    System.arraycopy(tileBuf, inputOffset, buf, outputOffset, rowLen);
                    outputOffset += outputRowLen;
                }
                outputCol += rowLen;
            }
            if (intersection == null) continue;
            outputRow += intersection.height;
            outputCol = 0;
        }
        return buf;
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        MetadataStore store = this.getMetadataStore();
        if (!(store instanceof IMetadata) || this.reader.getSeriesCount() == 1) {
            this.tileX = 1;
            this.tileY = 1;
            return;
        }
        IMetadata meta = (IMetadata)store;
        if (meta.getPlateCount() > 1 || meta.getPlateCount() == 1 && meta.getWellCount(0) > 1) {
            this.tileX = 1;
            this.tileY = 1;
            return;
        }
        boolean equalDimensions = true;
        for (int i = 1; i < meta.getImageCount(); ++i) {
            if (!meta.getPixelsSizeX(i).equals((Object)meta.getPixelsSizeX(0))) {
                equalDimensions = false;
            }
            if (!meta.getPixelsSizeY(i).equals((Object)meta.getPixelsSizeY(0))) {
                equalDimensions = false;
            }
            if (!meta.getPixelsSizeZ(i).equals((Object)meta.getPixelsSizeZ(0))) {
                equalDimensions = false;
            }
            if (!meta.getPixelsSizeC(i).equals((Object)meta.getPixelsSizeC(0))) {
                equalDimensions = false;
            }
            if (!meta.getPixelsSizeT(i).equals((Object)meta.getPixelsSizeT(0))) {
                equalDimensions = false;
            }
            if (!meta.getPixelsType(i).equals((Object)meta.getPixelsType(0))) {
                equalDimensions = false;
            }
            if (!equalDimensions) break;
        }
        if (!equalDimensions) {
            this.tileX = 1;
            this.tileY = 1;
            return;
        }
        ArrayList<TileCoordinate> tiles = new ArrayList<TileCoordinate>();
        ArrayList<Length> uniqueX = new ArrayList<Length>();
        ArrayList<Length> uniqueY = new ArrayList<Length>();
        boolean equalZs = true;
        Length firstZ = meta.getPlanePositionZ(0, meta.getPlaneCount(0) - 1);
        for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
            TileCoordinate coord = new TileCoordinate();
            coord.x = meta.getPlanePositionX(i, meta.getPlaneCount(i) - 1);
            coord.y = meta.getPlanePositionY(i, meta.getPlaneCount(i) - 1);
            tiles.add(coord);
            if (coord.x != null && !uniqueX.contains(coord.x)) {
                uniqueX.add(coord.x);
            }
            if (coord.y != null && !uniqueY.contains(coord.y)) {
                uniqueY.add(coord.y);
            }
            Length zPos = meta.getPlanePositionZ(i, meta.getPlaneCount(i) - 1);
            if (firstZ == null) {
                if (zPos == null) continue;
                equalZs = false;
                continue;
            }
            if (firstZ.equals((Object)zPos)) continue;
            equalZs = false;
        }
        this.tileX = uniqueX.size();
        this.tileY = uniqueY.size();
        if (!equalZs) {
            LOGGER.warn("Z positions not equal");
        }
        this.tileMap = new Integer[this.tileY][this.tileX];
        Object[] xCoordinates = uniqueX.toArray(new Length[this.tileX]);
        Arrays.sort(xCoordinates);
        Object[] yCoordinates = uniqueY.toArray(new Length[this.tileY]);
        Arrays.sort(yCoordinates);
        for (int row = 0; row < this.tileMap.length; ++row) {
            for (int col = 0; col < this.tileMap[row].length; ++col) {
                TileCoordinate coordinate = new TileCoordinate();
                coordinate.x = xCoordinates[col];
                coordinate.y = yCoordinates[row];
                for (int tile = 0; tile < tiles.size(); ++tile) {
                    if (!((TileCoordinate)tiles.get(tile)).equals(coordinate)) continue;
                    this.tileMap[row][col] = tile;
                }
            }
        }
    }

    public Class<?> getNativeDataType() {
        return byte[].class;
    }

    class TileCoordinate {
        public Length x;
        public Length y;

        TileCoordinate() {
        }

        public boolean equals(Object o) {
            boolean xEqual;
            if (!(o instanceof TileCoordinate)) {
                return false;
            }
            TileCoordinate tile = (TileCoordinate)o;
            boolean bl = this.x == null ? tile.x == null : (xEqual = this.x.equals((Object)tile.x));
            boolean yEqual = this.y == null ? tile.y == null : this.y.equals((Object)tile.y);
            return xEqual && yEqual;
        }
    }
}

