/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;
import ome.units.unit.Unit;

public class AliconaReader
extends FormatReader {
    public static final String AL3D_MAGIC_STRING = "Alicona";
    private int textureOffset;
    private int numBytes;

    public AliconaReader() {
        super("Alicona AL3D", "al3d");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)16, (boolean)false)) {
            return false;
        }
        return stream.readString(16).indexOf(AL3D_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int pad = (8 - this.getSizeX() % 8) % 8;
        int planeSize = (this.getSizeX() + pad) * this.getSizeY();
        if (this.getPixelType() == 6) {
            this.in.seek((long)this.textureOffset);
            this.readPlane(this.in, x, y, w, h, buf);
            return buf;
        }
        for (int i = 0; i < this.numBytes; ++i) {
            this.in.seek((long)(this.textureOffset + no * planeSize * (i + 1)));
            this.in.skipBytes(y * (this.getSizeX() + pad));
            if (this.getSizeX() == w) {
                this.in.read(buf, i * w * h, w * h);
                continue;
            }
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x);
                this.in.read(buf, i * w * h + row * w, w);
                this.in.skipBytes(this.getSizeX() + pad - x - w);
            }
        }
        if (this.numBytes > 1) {
            byte[] tmp = new byte[buf.length];
            for (int i = 0; i < planeSize; ++i) {
                for (int j = 0; j < this.numBytes; ++j) {
                    tmp[i * this.numBytes + j] = buf[planeSize * j + i];
                }
            }
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
            tmp = null;
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.numBytes = 0;
            this.textureOffset = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying Alicona format");
        String magicString = this.in.readString(17);
        if (!magicString.trim().equals("AliconaImaging")) {
            throw new FormatException("Invalid magic string : expected 'AliconaImaging', got " + magicString);
        }
        LOGGER.info("Reading tags");
        int count = 2;
        boolean hasC = false;
        String voltage = null;
        String magnification = null;
        String workingDistance = null;
        String pntX = null;
        String pntY = null;
        int depthOffset = 0;
        for (int i = 0; i < count; ++i) {
            String key = this.in.readString(20).trim();
            String value = this.in.readString(30).trim();
            this.addGlobalMeta(key, value);
            this.in.skipBytes(2);
            if (key.equals("TagCount")) {
                count += Integer.parseInt(value);
                continue;
            }
            if (key.equals("Rows")) {
                m.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("Cols")) {
                m.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("NumberOfPlanes")) {
                m.imageCount = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TextureImageOffset")) {
                this.textureOffset = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TexturePtr") && !value.equals("7")) {
                hasC = true;
                continue;
            }
            if (key.equals("Voltage")) {
                voltage = value;
                continue;
            }
            if (key.equals("Magnification")) {
                magnification = value;
                continue;
            }
            if (key.equals("PixelSizeXMeter")) {
                pntX = value;
                continue;
            }
            if (key.equals("PixelSizeYMeter")) {
                pntY = value;
                continue;
            }
            if (key.equals("WorkingDistance")) {
                workingDistance = value;
                continue;
            }
            if (!key.equals("DepthImageOffset")) continue;
            depthOffset = Integer.parseInt(value);
        }
        LOGGER.info("Populating metadata");
        if (this.textureOffset != 0) {
            this.numBytes = (int)(this.in.length() - (long)this.textureOffset) / (this.getSizeX() * this.getSizeY() * this.getImageCount());
            m.sizeC = hasC ? 3 : 1;
            m.sizeZ = 1;
            m.sizeT = this.getImageCount() / this.getSizeC();
            m.pixelType = FormatTools.pixelTypeFromBytes((int)this.numBytes, (boolean)false, (boolean)false);
        } else {
            this.textureOffset = depthOffset;
            m.pixelType = 6;
            m.sizeC = 1;
            m.sizeZ = 1;
            m.sizeT = 1;
            m.imageCount = 1;
        }
        m.rgb = false;
        m.interleaved = false;
        m.littleEndian = true;
        m.dimensionOrder = "XYCTZ";
        m.metadataComplete = true;
        m.indexed = false;
        m.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            if (voltage != null) {
                store.setDetectorSettingsVoltage(new ElectricPotential((Number)new Double(voltage), UNITS.VOLT), 0, 0);
                String detectorID = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, 0});
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorSettingsID(detectorID, 0, 0);
                store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            }
            if (magnification != null) {
                store.setObjectiveCalibratedMagnification(new Double(magnification), 0, 0);
            }
            if (workingDistance != null) {
                store.setObjectiveWorkingDistance(new Length((Number)new Double(workingDistance), UNITS.MICROMETER), 0, 0);
            }
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            String objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0});
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
            if (pntX != null && pntY != null) {
                double pixelSizeX = Double.parseDouble(pntX);
                double pixelSizeY = Double.parseDouble(pntY);
                Length sizeX = FormatTools.getPhysicalSizeX((Double)pixelSizeX, (Unit)UNITS.METER);
                Length sizeY = FormatTools.getPhysicalSizeY((Double)pixelSizeY, (Unit)UNITS.METER);
                if (sizeX != null) {
                    store.setPixelsPhysicalSizeX(sizeX, 0);
                }
                if (sizeY != null) {
                    store.setPixelsPhysicalSizeY(sizeY, 0);
                }
            }
        }
    }
}

