/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class MRWReader
extends FormatReader {
    public static final String MRW_MAGIC_STRING = "MRM";
    private static final int[] COLOR_MAP_1 = new int[]{0, 1, 1, 2};
    private static final int[] COLOR_MAP_2 = new int[]{1, 2, 0, 1};
    private int offset;
    private int sensorWidth;
    private int sensorHeight;
    private int bayerPattern;
    private int storageMethod;
    private int dataSize;
    private float[] wbg;
    private byte[] fullImage;

    public MRWReader() {
        super("Minolta MRW", "mrw");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)4, (boolean)false)) {
            return false;
        }
        return stream.readString(4).endsWith(MRW_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int[] colorMap;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int nBytes = this.sensorWidth * this.sensorHeight;
        if (this.dataSize == 12) {
            nBytes *= 3;
        } else if (this.dataSize == 16) {
            nBytes *= 4;
        }
        this.in.seek((long)this.offset);
        short[] s = new short[this.getSizeX() * this.getSizeY() * 3];
        for (int row = 0; row < this.getSizeY(); ++row) {
            boolean evenRow = row % 2 == 0;
            for (int col = 0; col < this.getSizeX(); ++col) {
                boolean evenCol = col % 2 == 0;
                short val = (short)(this.in.readBits(this.dataSize) & 0xFFFF);
                int redOffset = row * this.getSizeX() + col;
                int greenOffset = (this.getSizeY() + row) * this.getSizeX() + col;
                int blueOffset = (2 * this.getSizeY() + row) * this.getSizeX() + col;
                if (evenRow) {
                    if (evenCol) {
                        val = (short)((float)val * this.wbg[0]);
                        if (this.bayerPattern == 1) {
                            s[redOffset] = val;
                            continue;
                        }
                        s[greenOffset] = val;
                        continue;
                    }
                    val = (short)((float)val * this.wbg[1]);
                    if (this.bayerPattern == 1) {
                        s[greenOffset] = val;
                        continue;
                    }
                    s[blueOffset] = val;
                    continue;
                }
                if (evenCol) {
                    val = (short)((float)val * this.wbg[2]);
                    if (this.bayerPattern == 1) {
                        s[greenOffset] = val;
                        continue;
                    }
                    s[redOffset] = val;
                    continue;
                }
                val = (short)((float)val * this.wbg[3]);
                if (this.bayerPattern == 1) {
                    s[blueOffset] = val;
                    continue;
                }
                s[greenOffset] = val;
            }
            this.in.skipBits((long)(this.dataSize * (this.sensorWidth - this.getSizeX())));
        }
        int[] nArray = colorMap = this.bayerPattern == 1 ? COLOR_MAP_1 : COLOR_MAP_2;
        if (this.fullImage == null) {
            this.fullImage = new byte[FormatTools.getPlaneSize((IFormatReader)this)];
            this.fullImage = ImageTools.interpolate((short[])s, (byte[])this.fullImage, (int[])colorMap, (int)this.getSizeX(), (int)this.getSizeY(), (boolean)this.isLittleEndian());
        }
        RandomAccessInputStream stream = new RandomAccessInputStream(this.fullImage);
        this.readPlane(stream, x, y, w, h, buf);
        stream.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offset = 0;
            this.sensorHeight = 0;
            this.sensorWidth = 0;
            this.bayerPattern = 0;
            this.storageMethod = 0;
            this.dataSize = 0;
            this.wbg = null;
            this.fullImage = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        this.in.skipBytes(4);
        this.offset = this.in.readInt() + 8;
        while (this.in.getFilePointer() < (long)this.offset) {
            String blockName = this.in.readString(4);
            int len = this.in.readInt();
            long fp = this.in.getFilePointer();
            if (blockName.endsWith("PRD")) {
                this.in.skipBytes(8);
                this.sensorHeight = this.in.readShort();
                this.sensorWidth = this.in.readShort();
                m.sizeY = this.in.readShort();
                m.sizeX = this.in.readShort();
                this.dataSize = this.in.read();
                this.in.skipBytes(1);
                this.storageMethod = this.in.read();
                this.in.skipBytes(4);
                this.bayerPattern = this.in.read();
            } else if (blockName.endsWith("WBG")) {
                this.wbg = new float[4];
                byte[] wbScale = new byte[4];
                this.in.read(wbScale);
                for (int i = 0; i < this.wbg.length; ++i) {
                    float coeff = this.in.readShort();
                    this.wbg[i] = coeff / (float)(64 << wbScale[i]);
                }
            } else if (blockName.endsWith("TTW") && this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                byte[] b = new byte[len];
                this.in.read(b);
                RandomAccessInputStream ras = new RandomAccessInputStream(b);
                TiffParser tp = new TiffParser(ras);
                IFDList ifds = tp.getMainIFDs();
                for (IFD ifd : ifds) {
                    Integer[] keys = ifd.keySet().toArray(new Integer[0]);
                    for (int q = 0; q < keys.length; ++q) {
                        this.addGlobalMeta(IFD.getIFDTagName((int)keys[q]), ifd.get((Object)keys[q]));
                    }
                }
                IFDList exifIFDs = tp.getExifIFDs();
                for (IFD exif : exifIFDs) {
                    for (Integer key : exif.keySet()) {
                        this.addGlobalMeta(IFD.getIFDTagName((int)key), exif.get((Object)key));
                    }
                }
                ras.close();
            }
            this.in.seek(fp + (long)len);
        }
        m.pixelType = 3;
        m.rgb = true;
        m.littleEndian = false;
        m.dimensionOrder = "XYCZT";
        m.imageCount = 1;
        m.sizeC = 3;
        m.sizeZ = 1;
        m.sizeT = 1;
        m.interleaved = true;
        m.bitsPerPixel = this.dataSize;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

