/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.PackbitsCodec;
import loci.formats.meta.MetadataStore;

public class PSDReader
extends FormatReader {
    public static final String PSD_MAGIC_STRING = "8BPS";
    private byte[][] lut;
    private long offset;
    private int[][] lens;
    private boolean compressed = false;

    public PSDReader() {
        super("Adobe Photoshop", "psd");
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = PSD_MAGIC_STRING.length();
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)blockLen, (boolean)false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(PSD_MAGIC_STRING);
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(this.offset);
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int plane = this.getSizeX() * this.getSizeY() * bpp;
        if (this.compressed) {
            PackbitsCodec codec = new PackbitsCodec();
            CodecOptions options = new CodecOptions();
            options.maxBytes = this.getSizeX() * bpp;
            byte[] b = null;
            int index = 0;
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int row = 0; row < this.getSizeY(); ++row) {
                    if (row < y || row >= y + h) {
                        this.in.skipBytes(this.lens[c][row]);
                        continue;
                    }
                    b = new byte[this.lens[c][row]];
                    this.in.read(b);
                    b = codec.decompress(b, options);
                    System.arraycopy(b, x * bpp, buf, index, w * bpp);
                    index += w * bpp;
                }
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.offset = 0L;
            this.compressed = false;
            this.lens = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = false;
        if (!this.in.readString(4).equals(PSD_MAGIC_STRING)) {
            throw new FormatException("Not a valid Photoshop file.");
        }
        this.addGlobalMeta("Version", this.in.readShort());
        this.in.skipBytes(6);
        m.sizeC = this.in.readShort();
        m.sizeY = this.in.readInt();
        m.sizeX = this.in.readInt();
        short bits = this.in.readShort();
        this.addGlobalMeta("Bits per pixel", bits);
        m.pixelType = FormatTools.pixelTypeFromBytes((int)(bits / 8), (boolean)false, (boolean)false);
        short colorMode = this.in.readShort();
        String modeString = null;
        switch (colorMode) {
            case 0: {
                modeString = "monochrome";
                break;
            }
            case 1: {
                modeString = "gray-scale";
                break;
            }
            case 2: {
                modeString = "palette color";
                break;
            }
            case 3: {
                modeString = "RGB";
                break;
            }
            case 4: {
                modeString = "CMYK";
                break;
            }
            case 6: {
                modeString = "Duotone";
                break;
            }
            case 7: {
                modeString = "Multichannel color";
                break;
            }
            case 8: {
                modeString = "Duotone";
                break;
            }
            case 9: {
                modeString = "LAB color";
            }
        }
        this.addGlobalMeta("Color mode", modeString);
        int modeDataLength = this.in.readInt();
        long fp = this.in.getFilePointer();
        if (modeDataLength != 0) {
            if (colorMode == 2) {
                this.lut = new byte[3][256];
                for (int i = 0; i < this.lut.length; ++i) {
                    this.in.read(this.lut[i]);
                }
            }
            this.in.seek(fp + (long)modeDataLength);
        }
        this.in.skipBytes(4);
        while (this.in.readString(4).equals("8BIM")) {
            int size;
            short tag = this.in.readShort();
            int read = 1;
            while (this.in.read() != 0) {
                ++read;
            }
            if (read % 2 == 1) {
                this.in.skipBytes(1);
            }
            if ((size = this.in.readInt()) % 2 == 1) {
                ++size;
            }
            this.in.skipBytes(size);
        }
        this.in.seek(this.in.getFilePointer() - 4L);
        int blockLen = this.in.readInt();
        if (blockLen == 0) {
            this.offset = this.in.getFilePointer();
        } else {
            int len;
            int i;
            int layerLen = this.in.readInt();
            int layerCount = this.in.readShort();
            if (layerCount < 0) {
                throw new FormatException("Vector data is not supported.");
            }
            if (layerLen == 0 && layerCount == 0) {
                this.in.skipBytes(2);
                short check = this.in.readShort();
                this.in.seek(this.in.getFilePointer() - (long)(check == 0 ? 4 : 2));
            }
            int[] w = new int[layerCount];
            int[] h = new int[layerCount];
            int[] c = new int[layerCount];
            for (i = 0; i < layerCount; ++i) {
                int top = this.in.readInt();
                int left = this.in.readInt();
                int bottom = this.in.readInt();
                int right = this.in.readInt();
                w[i] = right - left;
                h[i] = bottom - top;
                c[i] = this.in.readShort();
                this.in.skipBytes(c[i] * 6 + 12);
                int len2 = this.in.readInt();
                if (len2 % 2 == 1) {
                    ++len2;
                }
                this.in.skipBytes(len2);
            }
            for (i = 0; i < layerCount; ++i) {
                if (h[i] < 0) continue;
                int[] lens = new int[h[i]];
                for (int cc = 0; cc < c[i]; ++cc) {
                    int y;
                    boolean compressed;
                    boolean bl = compressed = this.in.readShort() == 1;
                    if (!compressed) {
                        this.in.skipBytes(w[i] * h[i]);
                        continue;
                    }
                    for (y = 0; y < h[i]; ++y) {
                        lens[y] = this.in.readShort();
                    }
                    for (y = 0; y < h[i]; ++y) {
                        this.in.skipBytes(lens[y]);
                    }
                }
            }
            long start = this.in.getFilePointer();
            while (this.in.read() != 56) {
            }
            this.in.skipBytes(7);
            if (this.in.getFilePointer() - start > 1024L) {
                this.in.seek(start);
            }
            if ((len = this.in.readInt()) % 4 != 0) {
                len += 4 - len % 4;
            }
            if ((long)len > this.in.length() - this.in.getFilePointer() || (len & 0xFF0000) >> 16 == 1) {
                this.in.seek(start);
                len = 0;
            }
            this.in.skipBytes(len);
            String s = this.in.readString(4);
            while (s.equals("8BIM")) {
                this.in.skipBytes(4);
                len = this.in.readInt();
                if (len % 4 != 0) {
                    len += 4 - len % 4;
                }
                this.in.skipBytes(len);
                s = this.in.readString(4);
            }
            this.offset = this.in.getFilePointer() - 4L;
        }
        m.sizeZ = 1;
        m.sizeT = 1;
        m.rgb = modeString.equals("RGB") || modeString.equals("CMYK");
        m.imageCount = this.getSizeC() / (this.isRGB() ? 3 : 1);
        m.indexed = modeString.equals("palette color");
        m.falseColor = false;
        m.dimensionOrder = "XYCZT";
        m.interleaved = false;
        m.metadataComplete = true;
        this.in.seek(this.offset);
        this.compressed = this.in.readShort() == 1;
        this.lens = new int[this.getSizeC()][this.getSizeY()];
        if (this.compressed) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int row = 0; row < this.getSizeY(); ++row) {
                    this.lens[c][row] = this.in.readShort();
                }
            }
        }
        this.offset = this.in.getFilePointer();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

