/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import loci.formats.services.WlzService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PrimitiveNumber;

public class WlzReader
extends FormatReader {
    private transient WlzService wlz = null;
    public static final String NO_WLZ_MSG = "\nWoolz is required to read and write Woolz objects.\nPlease obtain the necessary JAR and native library files from:\nhttp://www.emouseatlas.org/emap/analysis_tools_resources/software/woolz.html.\nThe source code for these is also available from:\nhttps://github.com/ma-tech/Woolz.";

    public WlzReader() {
        super("Woolz", new String[]{"wlz"});
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(String file2, boolean open) {
        return super.isThisType(file2, open);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.wlz != null) {
            buf = this.wlz.readBytes(no, buf, x, y, w, h);
        } else {
            try {
                ServiceFactory factory = new ServiceFactory();
                this.wlz = (WlzService)factory.getInstance(WlzService.class);
            }
            catch (DependencyException e) {
                throw new FormatException(NO_WLZ_MSG, (Throwable)e);
            }
            if (this.wlz != null) {
                this.wlz.open(this.currentId, "r");
                buf = this.wlz.readBytes(no, buf, x, y, w, h);
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.wlz = (WlzService)factory.getInstance(WlzService.class);
        }
        catch (DependencyException e) {
            throw new FormatException(NO_WLZ_MSG, (Throwable)e);
        }
        if (this.wlz != null) {
            this.wlz.open(id, "r");
            CoreMetadata md = (CoreMetadata)this.core.get(0);
            MetadataStore store = this.makeFilterMetadata();
            md.rgb = this.wlz.isRGB();
            md.interleaved = false;
            md.indexed = false;
            md.sizeX = this.wlz.getSizeX();
            md.sizeY = this.wlz.getSizeY();
            md.sizeZ = this.wlz.getSizeZ();
            md.sizeC = this.wlz.getSizeC();
            md.sizeT = this.wlz.getSizeT();
            md.dimensionOrder = "XYZCT";
            md.imageCount = this.wlz.getSizeZ();
            md.pixelType = this.wlz.getPixelType();
            PositiveFloat x = new PositiveFloat(Double.valueOf(Math.abs(this.wlz.getVoxSzX())));
            PositiveFloat y = new PositiveFloat(Double.valueOf(Math.abs(this.wlz.getVoxSzY())));
            PositiveFloat z = new PositiveFloat(Double.valueOf(Math.abs(this.wlz.getVoxSzZ())));
            store.setPixelsPhysicalSizeX(FormatTools.createLength((PrimitiveNumber)x, (Unit)UNITS.MICROMETER), 0);
            store.setPixelsPhysicalSizeY(FormatTools.createLength((PrimitiveNumber)y, (Unit)UNITS.MICROMETER), 0);
            store.setPixelsPhysicalSizeZ(FormatTools.createLength((PrimitiveNumber)z, (Unit)UNITS.MICROMETER), 0);
            store.setStageLabelName(this.wlz.getWlzOrgLabelName(), 0);
            store.setStageLabelX(new Length((Number)this.wlz.getOrgX(), UNITS.REFERENCEFRAME), 0);
            store.setStageLabelY(new Length((Number)this.wlz.getOrgY(), UNITS.REFERENCEFRAME), 0);
            store.setStageLabelZ(new Length((Number)this.wlz.getOrgZ(), UNITS.REFERENCEFRAME), 0);
            MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        }
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly && this.wlz != null) {
            this.wlz.close();
            this.wlz = null;
        }
    }
}

