/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionInfo;
import Ice.Holder;
import Ice.IPConnectionInfo;
import Ice.LocalException;
import Ice.TCPConnectionInfo;
import Ice.WSConnectionInfo;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.StreamSocket;
import IceInternal.Transceiver;
import IceInternal.WSTransceiverDelegate;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.util.Map;

final class TcpTransceiver
implements Transceiver,
WSTransceiverDelegate {
    private final ProtocolInstance _instance;
    private final StreamSocket _stream;

    @Override
    public SelectableChannel fd() {
        assert (this._stream != null);
        return this._stream.fd();
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer, Holder<Boolean> moreData) {
        return this._stream.connect(readBuffer, writeBuffer);
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return initiator ? 1 : 0;
    }

    @Override
    public void close() {
        this._stream.close();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buf) {
        return this._stream.write(buf);
    }

    @Override
    public int read(Buffer buf, Holder<Boolean> moreData) {
        return this._stream.read(buf);
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._stream.toString();
    }

    @Override
    public String toDetailedString() {
        return this.toString();
    }

    @Override
    public ConnectionInfo getInfo() {
        TCPConnectionInfo info = new TCPConnectionInfo();
        this.fillConnectionInfo(info);
        return info;
    }

    @Override
    public ConnectionInfo getWSInfo(Map<String, String> headers) {
        WSConnectionInfo info = new WSConnectionInfo();
        this.fillConnectionInfo(info);
        info.headers = headers;
        return info;
    }

    @Override
    public void checkSendSize(Buffer buf) {
    }

    @Override
    public void setBufferSize(int rcvSize, int sndSize) {
        this._stream.setBufferSize(rcvSize, sndSize);
    }

    TcpTransceiver(ProtocolInstance instance, StreamSocket stream) {
        this._instance = instance;
        this._stream = stream;
    }

    private void fillConnectionInfo(IPConnectionInfo info) {
        if (this._stream.fd() != null) {
            Socket socket = this._stream.fd().socket();
            info.localAddress = socket.getLocalAddress().getHostAddress();
            info.localPort = socket.getLocalPort();
            if (socket.getInetAddress() != null) {
                info.remoteAddress = socket.getInetAddress().getHostAddress();
                info.remotePort = socket.getPort();
            }
            if (!socket.isClosed()) {
                info.rcvSize = Network.getRecvBufferSize(this._stream.fd());
                info.sndSize = Network.getSendBufferSize(this._stream.fd());
            }
        }
    }
}

