/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.PluginInitializationException;
import IceInternal.Connector;
import IceInternal.HashUtil;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.StreamSocket;
import IceInternal.Transceiver;
import IceSSL.Instance;
import IceSSL.TransceiverI;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;

final class ConnectorI
implements Connector {
    private Instance _instance;
    private String _host;
    private InetSocketAddress _addr;
    private NetworkProxy _proxy;
    private InetSocketAddress _sourceAddr;
    private int _timeout;
    private String _connectionId;
    private int _hashCode;

    @Override
    public Transceiver connect() {
        if (!this._instance.initialized()) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: plug-in is not initialized";
            throw ex;
        }
        StreamSocket stream = new StreamSocket(this._instance, this._proxy, this._addr, this._sourceAddr);
        try {
            SSLEngine engine = this._instance.createSSLEngine(false, this._addr);
            return new TransceiverI(this._instance, engine, stream, this._host, false);
        }
        catch (RuntimeException ex) {
            stream.close();
            throw ex;
        }
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._proxy == null ? this._addr : this._proxy.getAddress());
    }

    public int hashCode() {
        return this._hashCode;
    }

    ConnectorI(Instance instance, String host, InetSocketAddress addr, NetworkProxy proxy, InetSocketAddress sourceAddr, int timeout, String connectionId) {
        this._instance = instance;
        this._host = host;
        this._addr = addr;
        this._sourceAddr = sourceAddr;
        this._proxy = proxy;
        this._timeout = timeout;
        this._connectionId = connectionId;
        this._hashCode = 5381;
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getAddress().getHostAddress());
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getPort());
        if (this._sourceAddr != null) {
            this._hashCode = HashUtil.hashAdd(this._hashCode, this._sourceAddr.getAddress().getHostAddress());
        }
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._timeout);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._connectionId);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConnectorI)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConnectorI p = (ConnectorI)obj;
        if (this._timeout != p._timeout) {
            return false;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return false;
        }
        if (Network.compareAddress(this._sourceAddr, p._sourceAddr) != 0) {
            return false;
        }
        return Network.compareAddress(this._addr, p._addr) == 0;
    }
}

