/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import omero.model.Pixels;

public class ImportSize {
    public final String fileName;
    public final Pixels pixels;
    public final String dimOrder;
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    public final int sizeC;
    public final int sizeT;
    public final int imageCount;
    public final int zSize;
    public final int wSize;
    public final int tSize;

    public ImportSize(String fileName, Pixels pixels, String dimOrder) {
        this.fileName = fileName;
        this.pixels = pixels;
        this.dimOrder = dimOrder;
        this.sizeZ = pixels.getSizeZ().getValue();
        this.sizeC = pixels.getSizeC().getValue();
        this.sizeT = pixels.getSizeT().getValue();
        this.sizeX = pixels.getSizeX().getValue();
        this.sizeY = pixels.getSizeY().getValue();
        this.imageCount = this.sizeZ * this.sizeC * this.sizeT;
        int order = this.getSequenceNumber(dimOrder);
        int smallOffset = 1;
        switch (order) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * this.sizeZ;
                this.wSize = this.tSize * this.sizeT;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * this.sizeC;
                this.tSize = this.zSize * this.sizeZ;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * this.sizeZ;
                this.tSize = this.wSize * this.sizeC;
                break;
            }
            case 3: {
                this.tSize = smallOffset;
                this.wSize = this.tSize * this.sizeT;
                this.zSize = this.wSize * this.sizeC;
                break;
            }
            case 4: {
                this.wSize = smallOffset;
                this.tSize = this.wSize * this.sizeC;
                this.zSize = this.tSize * this.sizeT;
                break;
            }
            case 5: {
                this.tSize = smallOffset;
                this.zSize = this.tSize * this.sizeT;
                this.wSize = this.zSize * this.sizeZ;
                break;
            }
            default: {
                throw new RuntimeException("Bad order");
            }
        }
    }

    private int getSequenceNumber(String dimOrder) {
        if ("XYZTC".equals(dimOrder)) {
            return 0;
        }
        if ("XYCZT".equals(dimOrder)) {
            return 1;
        }
        if ("XYZCT".equals(dimOrder)) {
            return 2;
        }
        if ("XYTCZ".equals(dimOrder)) {
            return 3;
        }
        if ("XYCTZ".equals(dimOrder)) {
            return 4;
        }
        if ("XYTZC".equals(dimOrder)) {
            return 5;
        }
        throw new RuntimeException(dimOrder + " not represented in getSequenceNumber");
    }
}

