/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import ome.formats.importer.IObservable;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler
extends ome.formats.importer.util.ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);

    public ErrorHandler(ImportConfig config) {
        super(config);
    }

    @Override
    public void onUpdate(IObservable importLibrary, ImportEvent event) {
        if (event instanceof ImportEvent.IMPORT_DONE) {
            log.info("Number of errors: " + this.errors.size());
        } else if (event instanceof ImportCandidates.SCANNING) {
            log.debug(event.toLog());
        } else if (event instanceof ImportEvent.DEBUG_SEND) {
            boolean plate = false;
            for (ErrorContainer error : this.errors) {
                ImportContainer ic;
                error.setEmail((String)this.config.email.get());
                error.setComment("Sent from CLI");
                if (plate || (ic = (ImportContainer)this.icMap.get(error.getSelectedFile().getAbsolutePath())) == null) continue;
                Boolean b = ic.getIsSPW();
                plate = b != null && b != false;
            }
            if (this.errors.size() > 0) {
                this.sendFiles = ((ImportEvent.DEBUG_SEND)event).sendFiles;
                this.sendLogs = ((ImportEvent.DEBUG_SEND)event).sendLogs;
                if (plate) {
                    log.info("To submit HCS data, please e-mail us.");
                    this.sendFiles = false;
                }
                log.info("Sending error report (" + this.errors.size() + ")...");
                this.sendErrors();
                if (this.sendFiles) {
                    if (this.sendLogs) {
                        log.info("Sent files and log file.");
                    } else {
                        log.info("Sent files.");
                    }
                } else if (this.sendLogs) {
                    log.info("Sent log file.");
                }
            }
        }
    }
}

