/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.util.ArrayList;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientKeepAlive
implements Runnable,
IObservable {
    private static Logger log = LoggerFactory.getLogger(ClientKeepAlive.class);
    private OMEROMetadataStoreClient client;
    private final ArrayList<IObserver> observers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            OMEROMetadataStoreClient oMEROMetadataStoreClient = this.client;
            synchronized (oMEROMetadataStoreClient) {
                if (this.client != null) {
                    this.client.ping();
                }
            }
        }
        catch (Throwable t) {
            log.error("Exception while executing ping(), logging Connector out: ", t);
            try {
                this.client.logout();
                this.notifyObservers(new ImportEvent.LOGGED_OUT());
            }
            catch (Exception e) {
                log.error("Nested error on client.logout() while handling exception from ping()", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMEROMetadataStoreClient getClient() {
        OMEROMetadataStoreClient oMEROMetadataStoreClient = this.client;
        synchronized (oMEROMetadataStoreClient) {
            return this.client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClient(OMEROMetadataStoreClient client2) {
        OMEROMetadataStoreClient oMEROMetadataStoreClient = client2;
        synchronized (oMEROMetadataStoreClient) {
            this.client = client2;
        }
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            try {
                observer.update(this, event);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
    }
}

