/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import loci.formats.meta.DummyMetadata;
import ome.conditions.ApiUsageException;
import ome.formats.model.UnitsFactory;
import ome.model.core.Image;
import ome.services.db.DatabaseIdentity;
import ome.tools.hibernate.ProxyCleanupFilter;
import ome.tools.hibernate.QueryBuilder;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.util.Filterable;
import ome.xml.meta.MetadataRoot;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.model.AffineTransform;
import omero.model.Annotation;
import omero.model.BooleanAnnotation;
import omero.model.Channel;
import omero.model.CommentAnnotation;
import omero.model.ContrastMethod;
import omero.model.Details;
import omero.model.DoubleAnnotation;
import omero.model.Ellipse;
import omero.model.Event;
import omero.model.ExternalInfo;
import omero.model.ExternalInfoI;
import omero.model.IObject;
import omero.model.Illumination;
import omero.model.Label;
import omero.model.Line;
import omero.model.LongAnnotation;
import omero.model.Mask;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.PlaneInfo;
import omero.model.Point;
import omero.model.Polygon;
import omero.model.Polyline;
import omero.model.Rectangle;
import omero.model.Roi;
import omero.model.Shape;
import omero.model.TagAnnotation;
import omero.model.TermAnnotation;
import omero.model.TimestampAnnotation;
import omero.model.XmlAnnotation;
import omero.rtypes;
import omero.util.IceMapper;
import org.hibernate.Session;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroMetadata
extends DummyMetadata {
    private static final Logger log = LoggerFactory.getLogger(OmeroMetadata.class);
    private final Set<String> seenLSIDs = new HashSet<String>();
    private final List<omero.model.Image> imageList = new ArrayList<omero.model.Image>();
    private final List<XmlAnnotation> xmlAnnotationList = new ArrayList<XmlAnnotation>();
    private final List<LongAnnotation> longAnnotationList = new ArrayList<LongAnnotation>();
    private final List<BooleanAnnotation> booleanAnnotationList = new ArrayList<BooleanAnnotation>();
    private final List<DoubleAnnotation> doubleAnnotationList = new ArrayList<DoubleAnnotation>();
    private final List<CommentAnnotation> commentAnnotationList = new ArrayList<CommentAnnotation>();
    private final List<TimestampAnnotation> timestampAnnotationList = new ArrayList<TimestampAnnotation>();
    private final List<TagAnnotation> tagAnnotationList = new ArrayList<TagAnnotation>();
    private final List<TermAnnotation> termAnnotationList = new ArrayList<TermAnnotation>();
    private final List<Roi> roiList = new ArrayList<Roi>();
    private final DatabaseIdentity db;

    public OmeroMetadata(DatabaseIdentity db) {
        this.db = db;
    }

    public MetadataRoot getRoot() {
        return new OmeroMetadataRoot();
    }

    public void addImage(omero.model.Image image) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Adding image for retrieval:", image));
        }
        this.imageList.add(image);
    }

    public omero.model.Image getImage(int i) {
        return this.imageList.get(i);
    }

    public int sizeImages() {
        return this.imageList.size();
    }

    public String handleLsid(IObject obj) {
        if (obj == null) {
            return null;
        }
        Details d = obj.getDetails();
        ExternalInfo ei = d.getExternalInfo();
        Event ue = d.getUpdateEvent();
        if (ei != null && ei.getLsid() != null) {
            return ei.getLsid().getValue();
        }
        if (obj.getId() != null) {
            Long v;
            Class<Object> k = obj.getClass();
            if (Annotation.class.isAssignableFrom(k)) {
                k = Annotation.class;
            } else if (Shape.class.isAssignableFrom(k)) {
                k = Shape.class;
            }
            long id = obj.getId().getValue();
            Long l = v = ue == null ? null : Long.valueOf(ue.getId().getValue());
            if (v == null) {
                return this.db.lsid(k, id);
            }
            return this.db.lsid(k, id, v.longValue());
        }
        if (ei == null) {
            ei = new ExternalInfoI();
            d.setExternalInfo(ei);
        }
        String uuid = UUID.randomUUID().toString();
        String prefix = obj.getClass().getSimpleName();
        if (Annotation.class.isAssignableFrom(obj.getClass())) {
            prefix = Annotation.class.getSimpleName();
        } else if (Shape.class.isAssignableFrom(obj.getClass())) {
            prefix = Shape.class.getSimpleName();
        }
        String lsid = prefix + ":" + uuid;
        ei.setLsid(rtypes.rstring(lsid));
        log.warn("Assigned temporary LSID: " + lsid);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Returning LSID for object %s: %s", obj, lsid));
        }
        return ei.getLsid().getValue();
    }

    public void initialize(Session session) {
        HashMap<omero.model.Image, Image> lookups = new HashMap<omero.model.Image, Image>();
        HashMap<omero.model.Image, omero.model.Image> replacements = new HashMap<omero.model.Image, omero.model.Image>();
        for (omero.model.Image image : this.imageList) {
            if (image.isLoaded()) continue;
            long id = image.getId().getValue();
            QueryBuilder qb = new QueryBuilder();
            qb.select(new String[]{"i"});
            qb.from("Image", "i");
            qb.join("i.details.owner", "i_o", false, true);
            qb.join("i.details.group", "i_g", false, true);
            qb.join("i.pixels", "p", false, true);
            qb.join("i.annotationLinks", "i_a_link", true, true);
            qb.join("i_a_link.child", "i_a", true, true);
            qb.join("p.details.owner", "p_o", false, true);
            qb.join("p.details.group", "p_g", false, true);
            qb.join("p.pixelsType", "pt", false, true);
            qb.join("p.dimensionOrder", "do", false, true);
            qb.join("p.channels", "c", false, true);
            qb.join("p.planeInfo", "pinfo", true, true);
            qb.join("pinfo.deltaT", "deltaT", true, true);
            qb.join("pinfo.exposureTime", "expTime", true, true);
            qb.join("c.logicalChannel", "l", false, true);
            qb.join("l.mode", "a_mode", true, true);
            qb.join("l.illumination", "i_type", true, true);
            qb.join("l.contrastMethod", "c_method", true, true);
            qb.join("i.rois", "r", true, true);
            qb.join("r.details.owner", "r_o", true, true);
            qb.join("r.details.group", "r_g", true, true);
            qb.join("r.annotationLinks", "r_a_link", true, true);
            qb.join("r_a_link.child", "r_a", true, true);
            qb.join("r.shapes", "s", true, true);
            qb.join("s.details.owner", "s_o", true, true);
            qb.join("s.details.group", "s_g", true, true);
            qb.join("s.annotationLinks", "s_a_link", true, true);
            qb.join("s_a_link.child", "s_a", true, true);
            qb.where();
            qb.and("i.id = " + id);
            Image _i = (Image)qb.query(session).uniqueResult();
            if (_i == null) {
                throw new ApiUsageException("Cannot load image: " + id);
            }
            lookups.put(image, _i);
            if (_i.getInstrument() == null) continue;
            qb = new QueryBuilder();
            qb.select(new String[]{"i"});
            qb.from("Image", "i");
            qb.join("i.instrument", "n", true, true);
            qb.join("n.objective", "o", true, true);
            qb.join("o.correction", "o_cor", true, true);
            qb.join("o.immersion", "o_imm", true, true);
            qb.join("n.details.owner", "n_o", true, true);
            qb.join("n.details.group", "n_g", true, true);
            qb.where();
            qb.and("i.id = " + id);
            qb.query(session);
        }
        session.clear();
        IceMapper mapper = new IceMapper();
        for (omero.model.Image image : lookups.keySet()) {
            omero.model.Image replacement = (omero.model.Image)mapper.map(new ProxyCleanupFilter().filter("", (Filterable)lookups.get(image)));
            replacements.put(image, replacement);
        }
        ArrayList<omero.model.Image> arrayList = new ArrayList<omero.model.Image>();
        for (int i = 0; i < this.imageList.size(); ++i) {
            omero.model.Image image = this.imageList.get(i);
            omero.model.Image replacement = (omero.model.Image)replacements.get(image);
            if (!this.seenLSIDs.add(this.handleLsid(replacement))) continue;
            if (replacement != null) {
                arrayList.add(replacement);
                this.initializeAnnotations(replacement.linkedAnnotationList());
                this.initializeRois(replacement);
                continue;
            }
            arrayList.add(image);
            this.initializeAnnotations(image.linkedAnnotationList());
            this.initializeRois(image);
        }
        this.imageList.clear();
        this.imageList.addAll(arrayList);
    }

    private void initializeAnnotations(Iterable<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!this.seenLSIDs.add(this.handleLsid(annotation))) continue;
            if (annotation instanceof XmlAnnotation) {
                this.xmlAnnotationList.add((XmlAnnotation)annotation);
                continue;
            }
            if (annotation instanceof LongAnnotation) {
                this.longAnnotationList.add((LongAnnotation)annotation);
                continue;
            }
            if (annotation instanceof BooleanAnnotation) {
                this.booleanAnnotationList.add((BooleanAnnotation)annotation);
                continue;
            }
            if (annotation instanceof DoubleAnnotation) {
                this.doubleAnnotationList.add((DoubleAnnotation)annotation);
                continue;
            }
            if (annotation instanceof CommentAnnotation) {
                this.commentAnnotationList.add((CommentAnnotation)annotation);
                continue;
            }
            if (annotation instanceof TimestampAnnotation) {
                this.timestampAnnotationList.add((TimestampAnnotation)annotation);
                continue;
            }
            if (annotation instanceof TagAnnotation) {
                this.tagAnnotationList.add((TagAnnotation)annotation);
                continue;
            }
            if (annotation instanceof TermAnnotation) {
                this.termAnnotationList.add((TermAnnotation)annotation);
                continue;
            }
            log.warn(String.format("Unhandled annotation of type '%s' ID:%d", annotation.getClass(), annotation.getId().getValue()));
        }
    }

    private void initializeRois(omero.model.Image image) {
        for (Roi roi : image.copyRois()) {
            if (!this.seenLSIDs.add(this.handleLsid(roi))) continue;
            this.roiList.add(roi);
            this.initializeAnnotations(roi.linkedAnnotationList());
            for (Shape shape : roi.copyShapes()) {
                this.initializeAnnotations(shape.linkedAnnotationList());
            }
        }
    }

    private omero.model.Image _getImage(int imageIndex) {
        try {
            return this.imageList.get(imageIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private <X extends Shape> X getShape(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        if (ROIIndex < 0 || shapeIndex < 0 || ROIIndex >= this.roiList.size()) {
            return null;
        }
        Roi roi = this.roiList.get(ROIIndex);
        List<Shape> shapes = roi.copyShapes();
        if (shapeIndex >= shapes.size()) {
            return null;
        }
        Shape shape = shapes.get(shapeIndex);
        if (!expectedSubclass.isAssignableFrom(shape.getClass())) {
            return null;
        }
        return (X)((Shape)expectedSubclass.cast(shape));
    }

    private static Boolean fromRType(RBool v) {
        return v == null ? null : Boolean.valueOf(v.getValue());
    }

    private static String fromRType(RString v) {
        return v == null ? null : v.getValue();
    }

    private static Double fromRType(RDouble v) {
        return v == null ? null : Double.valueOf(v.getValue());
    }

    private static Time fromRType(omero.model.Time v) {
        if (v == null) {
            return null;
        }
        return UnitsFactory.convertTime(v);
    }

    private static Integer fromRType(RInt v) {
        return v == null ? null : Integer.valueOf(v.getValue());
    }

    private static Long fromRType(RLong v) {
        return v == null ? null : Long.valueOf(v.getValue());
    }

    private static PositiveInteger toPositiveInteger(RInt v) {
        try {
            Integer asInt = OmeroMetadata.fromRType(v);
            return asInt != null ? new PositiveInteger(asInt) : null;
        }
        catch (IllegalArgumentException e) {
            log.warn("Using new PositiveInteger(1)!", (Throwable)e);
            return new PositiveInteger(Integer.valueOf(1));
        }
    }

    private static NonNegativeInteger toNonNegativeInteger(RInt v) {
        try {
            Integer asInt = OmeroMetadata.fromRType(v);
            return asInt != null ? new NonNegativeInteger(asInt) : null;
        }
        catch (IllegalArgumentException e) {
            log.warn("Using new NonNegativeInteger(0)!", (Throwable)e);
            return new NonNegativeInteger(Integer.valueOf(0));
        }
    }

    private static ome.xml.model.AffineTransform toTransform(AffineTransform omeroTransform) {
        if (omeroTransform == null || omeroTransform.getA00() == null || omeroTransform.getA01() == null || omeroTransform.getA02() == null || omeroTransform.getA10() == null || omeroTransform.getA11() == null || omeroTransform.getA12() == null) {
            return null;
        }
        ome.xml.model.AffineTransform schemaTransform = new ome.xml.model.AffineTransform();
        schemaTransform.setA00(Double.valueOf(omeroTransform.getA00().getValue()));
        schemaTransform.setA01(Double.valueOf(omeroTransform.getA01().getValue()));
        schemaTransform.setA02(Double.valueOf(omeroTransform.getA02().getValue()));
        schemaTransform.setA10(Double.valueOf(omeroTransform.getA10().getValue()));
        schemaTransform.setA11(Double.valueOf(omeroTransform.getA11().getValue()));
        schemaTransform.setA12(Double.valueOf(omeroTransform.getA12().getValue()));
        return schemaTransform;
    }

    public Timestamp getImageAcquisitionDate(int imageIndex) {
        RTime acquisitionDate;
        omero.model.Image o = this._getImage(imageIndex);
        if (o != null && (acquisitionDate = o.getAcquisitionDate()) != null) {
            return new Timestamp(new Instant(acquisitionDate.getValue()));
        }
        return null;
    }

    public String getImageAnnotationRef(int imageIndex, int annotationRefIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        if (o == null) {
            return null;
        }
        try {
            Annotation annotation = o.linkedAnnotationList().get(annotationRefIndex);
            return this.handleLsid(annotation);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getImageAnnotationRefCount(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        if (o == null) {
            return -1;
        }
        return o.sizeOfAnnotationLinks();
    }

    public int getImageCount() {
        return this.imageList.size();
    }

    public String getImageDescription(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.fromRType(o.getDescription()) : null;
    }

    public String getImageID(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? this.handleLsid(o) : null;
    }

    public String getImageName(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.fromRType(o.getName()) : null;
    }

    public String getImageROIRef(int imageIndex, int ROIRefIndex) {
        if (imageIndex < 0 || ROIRefIndex < 0 || imageIndex >= this.imageList.size()) {
            return null;
        }
        omero.model.Image image = this.imageList.get(imageIndex);
        List<Roi> rois = image.copyRois();
        if (ROIRefIndex >= rois.size()) {
            return null;
        }
        Roi roi = rois.get(ROIRefIndex);
        return this.handleLsid(roi);
    }

    public int getImageROIRefCount(int imageIndex) {
        if (imageIndex < 0 || imageIndex >= this.imageList.size()) {
            return -1;
        }
        omero.model.Image image = this.imageList.get(imageIndex);
        return image.sizeOfRois();
    }

    public Boolean getPixelsBinDataBigEndian(int imageIndex, int binDataIndex) {
        return true;
    }

    public DimensionOrder getPixelsDimensionOrder(int imageIndex) {
        return DimensionOrder.XYZCT;
    }

    public String getPixelsID(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? this.handleLsid(o.getPrimaryPixels()) : null;
    }

    public Length getPixelsPhysicalSizeX(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? UnitsFactory.convertLength(o.getPrimaryPixels().getPhysicalSizeX()) : null;
    }

    public Length getPixelsPhysicalSizeY(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? UnitsFactory.convertLength(o.getPrimaryPixels().getPhysicalSizeY()) : null;
    }

    public Length getPixelsPhysicalSizeZ(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? UnitsFactory.convertLength(o.getPrimaryPixels().getPhysicalSizeZ()) : null;
    }

    public PositiveInteger getPixelsSizeC(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.toPositiveInteger(o.getPrimaryPixels().getSizeC()) : null;
    }

    public PositiveInteger getPixelsSizeT(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.toPositiveInteger(o.getPrimaryPixels().getSizeT()) : null;
    }

    public PositiveInteger getPixelsSizeX(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.toPositiveInteger(o.getPrimaryPixels().getSizeX()) : null;
    }

    public PositiveInteger getPixelsSizeY(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.toPositiveInteger(o.getPrimaryPixels().getSizeY()) : null;
    }

    public PositiveInteger getPixelsSizeZ(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.toPositiveInteger(o.getPrimaryPixels().getSizeZ()) : null;
    }

    public Time getPixelsTimeIncrement(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o != null ? OmeroMetadata.fromRType(o.getPrimaryPixels().getTimeIncrement()) : null;
    }

    public PixelType getPixelsType(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        if (o == null) {
            return null;
        }
        PixelsType e = o.getPrimaryPixels().getPixelsType();
        try {
            return e != null ? PixelType.fromString((String)OmeroMetadata.fromRType(e.getValue())) : null;
        }
        catch (EnumerationException ex) {
            log.error("Unable to map enumeration.", (Throwable)ex);
            return null;
        }
    }

    private Channel getChannel(int imageIndex, int channelIndex) {
        omero.model.Image i = this._getImage(imageIndex);
        if (i == null) {
            return null;
        }
        Pixels p = i.getPrimaryPixels();
        if (p == null) {
            return null;
        }
        try {
            return p.getChannel(channelIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public AcquisitionMode getChannelAcquisitionMode(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        if (o == null) {
            return null;
        }
        omero.model.AcquisitionMode e = o.getLogicalChannel().getMode();
        try {
            return e != null ? AcquisitionMode.fromString((String)OmeroMetadata.fromRType(e.getValue())) : null;
        }
        catch (EnumerationException ex) {
            log.error("Unable to map enumeration.", (Throwable)ex);
            return null;
        }
    }

    public Color getChannelColor(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        if (o == null) {
            return null;
        }
        try {
            return new Color(OmeroMetadata.fromRType(o.getRed()).intValue(), OmeroMetadata.fromRType(o.getGreen()).intValue(), OmeroMetadata.fromRType(o.getBlue()).intValue(), OmeroMetadata.fromRType(o.getAlpha()).intValue());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ome.xml.model.enums.ContrastMethod getChannelContrastMethod(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        if (o == null) {
            return null;
        }
        ContrastMethod e = o.getLogicalChannel().getContrastMethod();
        try {
            return e != null ? ome.xml.model.enums.ContrastMethod.fromString((String)OmeroMetadata.fromRType(e.getValue())) : null;
        }
        catch (EnumerationException ex) {
            log.error("Unable to map enumeration.", (Throwable)ex);
            return null;
        }
    }

    public int getChannelCount(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        if (o == null) {
            return -1;
        }
        return o.getPrimaryPixels().sizeOfChannels();
    }

    public Length getChannelEmissionWavelength(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return UnitsFactory.convertLength(o.getLogicalChannel().getEmissionWave());
    }

    public Length getChannelExcitationWavelength(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return UnitsFactory.convertLength(o.getLogicalChannel().getExcitationWave());
    }

    public String getChannelFluor(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return o != null ? OmeroMetadata.fromRType(o.getLogicalChannel().getFluor()) : null;
    }

    public String getChannelID(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return o != null ? this.handleLsid(o) : null;
    }

    public IlluminationType getChannelIlluminationType(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        if (o == null) {
            return null;
        }
        Illumination e = o.getLogicalChannel().getIllumination();
        try {
            return e != null ? IlluminationType.fromString((String)OmeroMetadata.fromRType(e.getValue())) : null;
        }
        catch (EnumerationException ex) {
            log.error("Unable to map enumeration.", (Throwable)ex);
            return null;
        }
    }

    public String getChannelName(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return o != null ? OmeroMetadata.fromRType(o.getLogicalChannel().getName()) : null;
    }

    public Double getChannelNDFilter(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return o != null ? OmeroMetadata.fromRType(o.getLogicalChannel().getNdFilter()) : null;
    }

    public Length getChannelPinholeSize(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return o != null ? UnitsFactory.convertLength(o.getLogicalChannel().getPinHoleSize()) : null;
    }

    public Integer getChannelPockelCellSetting(int imageIndex, int channelIndex) {
        Channel o = this.getChannel(imageIndex, channelIndex);
        return o != null ? OmeroMetadata.fromRType(o.getLogicalChannel().getPockelCellSetting()) : null;
    }

    public PositiveInteger getChannelSamplesPerPixel(int imageIndex, int channelIndex) {
        return new PositiveInteger(Integer.valueOf(1));
    }

    private PlaneInfo getPlane(int imageIndex, int planeIndex) {
        omero.model.Image i = this._getImage(imageIndex);
        if (i == null) {
            return null;
        }
        Pixels p = i.getPrimaryPixels();
        if (p == null) {
            return null;
        }
        try {
            return p.copyPlaneInfo().get(planeIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getPlaneCount(int imageIndex) {
        omero.model.Image o = this._getImage(imageIndex);
        return o == null ? 0 : o.getPrimaryPixels().sizeOfPlaneInfo();
    }

    public Time getPlaneDeltaT(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return o != null ? OmeroMetadata.fromRType(o.getDeltaT()) : null;
    }

    public Time getPlaneExposureTime(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return o != null ? OmeroMetadata.fromRType(o.getExposureTime()) : null;
    }

    public Length getPlanePositionX(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return o != null ? UnitsFactory.convertLength(o.getPositionX()) : null;
    }

    public Length getPlanePositionY(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return o != null ? UnitsFactory.convertLength(o.getPositionY()) : null;
    }

    public Length getPlanePositionZ(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return o != null ? UnitsFactory.convertLength(o.getPositionZ()) : null;
    }

    public NonNegativeInteger getPlaneTheC(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return OmeroMetadata.toNonNegativeInteger(o.getTheC());
    }

    public NonNegativeInteger getPlaneTheT(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return OmeroMetadata.toNonNegativeInteger(o.getTheT());
    }

    public NonNegativeInteger getPlaneTheZ(int imageIndex, int planeIndex) {
        PlaneInfo o = this.getPlane(imageIndex, planeIndex);
        return OmeroMetadata.toNonNegativeInteger(o.getTheZ());
    }

    private <T extends Annotation> T getAnnotation(Class<T> klass, int index) {
        try {
            if (klass.equals(XmlAnnotation.class)) {
                return (T)this.xmlAnnotationList.get(index);
            }
            if (klass.equals(LongAnnotation.class)) {
                return (T)this.longAnnotationList.get(index);
            }
            if (klass.equals(BooleanAnnotation.class)) {
                return (T)this.booleanAnnotationList.get(index);
            }
            if (klass.equals(DoubleAnnotation.class)) {
                return (T)this.doubleAnnotationList.get(index);
            }
            if (klass.equals(CommentAnnotation.class)) {
                return (T)this.commentAnnotationList.get(index);
            }
            if (klass.equals(TimestampAnnotation.class)) {
                return (T)this.timestampAnnotationList.get(index);
            }
            if (klass.equals(TagAnnotation.class)) {
                return (T)this.tagAnnotationList.get(index);
            }
            if (klass.equals(TermAnnotation.class)) {
                return (T)this.termAnnotationList.get(index);
            }
            log.warn(String.format("Unhandled annotation of type '%s' index:%d", klass, index));
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private String getAnnotationDescription(Class<? extends Annotation> klass, int index) {
        Annotation o = this.getAnnotation(klass, index);
        return o != null ? OmeroMetadata.fromRType(o.getDescription()) : null;
    }

    private String getAnnotationID(Class<? extends Annotation> klass, int index) {
        Annotation o = this.getAnnotation(klass, index);
        return o != null ? this.handleLsid(o) : null;
    }

    private String getAnnotationNamespace(Class<? extends Annotation> klass, int index) {
        Annotation o = this.getAnnotation(klass, index);
        return o != null ? OmeroMetadata.fromRType(o.getNs()) : null;
    }

    public int getXMLAnnotationCount() {
        return this.xmlAnnotationList.size();
    }

    public String getXMLAnnotationDescription(int XMLAnnotationIndex) {
        return this.getAnnotationDescription(XmlAnnotation.class, XMLAnnotationIndex);
    }

    public String getXMLAnnotationID(int XMLAnnotationIndex) {
        return this.getAnnotationID(XmlAnnotation.class, XMLAnnotationIndex);
    }

    public String getXMLAnnotationNamespace(int XMLAnnotationIndex) {
        return this.getAnnotationNamespace(XmlAnnotation.class, XMLAnnotationIndex);
    }

    public String getXMLAnnotationValue(int XMLAnnotationIndex) {
        XmlAnnotation o = this.getAnnotation(XmlAnnotation.class, XMLAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getTextValue()) : null;
    }

    public int getLongAnnotationCount() {
        return this.longAnnotationList.size();
    }

    public String getLongAnnotationDescription(int longAnnotationIndex) {
        return this.getAnnotationDescription(LongAnnotation.class, longAnnotationIndex);
    }

    public String getLongAnnotationID(int longAnnotationIndex) {
        return this.getAnnotationID(LongAnnotation.class, longAnnotationIndex);
    }

    public String getLongAnnotationNamespace(int longAnnotationIndex) {
        return this.getAnnotationNamespace(LongAnnotation.class, longAnnotationIndex);
    }

    public Long getLongAnnotationValue(int longAnnotationIndex) {
        LongAnnotation o = this.getAnnotation(LongAnnotation.class, longAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getLongValue()) : null;
    }

    public int getBooleanAnnotationCount() {
        return this.booleanAnnotationList.size();
    }

    public String getBooleanAnnotationDescription(int booleanAnnotationIndex) {
        return this.getAnnotationDescription(BooleanAnnotation.class, booleanAnnotationIndex);
    }

    public String getBooleanAnnotationID(int booleanAnnotationIndex) {
        return this.getAnnotationID(BooleanAnnotation.class, booleanAnnotationIndex);
    }

    public String getBooleanAnnotationNamespace(int booleanAnnotationIndex) {
        return this.getAnnotationNamespace(BooleanAnnotation.class, booleanAnnotationIndex);
    }

    public Boolean getBooleanAnnotationValue(int booleanAnnotationIndex) {
        BooleanAnnotation o = this.getAnnotation(BooleanAnnotation.class, booleanAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getBoolValue()) : null;
    }

    public int getDoubleAnnotationCount() {
        return this.doubleAnnotationList.size();
    }

    public String getDoubleAnnotationDescription(int doubleAnnotationIndex) {
        return this.getAnnotationDescription(DoubleAnnotation.class, doubleAnnotationIndex);
    }

    public String getDoubleAnnotationID(int doubleAnnotationIndex) {
        return this.getAnnotationID(DoubleAnnotation.class, doubleAnnotationIndex);
    }

    public String getDoubleAnnotationNamespace(int doubleAnnotationIndex) {
        return this.getAnnotationNamespace(DoubleAnnotation.class, doubleAnnotationIndex);
    }

    public Double getDoubleAnnotationValue(int doubleAnnotationIndex) {
        DoubleAnnotation o = this.getAnnotation(DoubleAnnotation.class, doubleAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getDoubleValue()) : null;
    }

    public int getCommentAnnotationCount() {
        return this.commentAnnotationList.size();
    }

    public String getCommentAnnotationDescription(int commentAnnotationIndex) {
        return this.getAnnotationDescription(CommentAnnotation.class, commentAnnotationIndex);
    }

    public String getCommentAnnotationID(int commentAnnotationIndex) {
        return this.getAnnotationID(CommentAnnotation.class, commentAnnotationIndex);
    }

    public String getCommentAnnotationNamespace(int commentAnnotationIndex) {
        return this.getAnnotationNamespace(CommentAnnotation.class, commentAnnotationIndex);
    }

    public String getCommentAnnotationValue(int commentAnnotationIndex) {
        CommentAnnotation o = this.getAnnotation(CommentAnnotation.class, commentAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getTextValue()) : null;
    }

    public int getTimestampAnnotationCount() {
        return this.timestampAnnotationList.size();
    }

    public String getTimestampAnnotationDescription(int timestampAnnotationIndex) {
        return this.getAnnotationDescription(TimestampAnnotation.class, timestampAnnotationIndex);
    }

    public String getTimestampAnnotationID(int timestampAnnotationIndex) {
        return this.getAnnotationID(TimestampAnnotation.class, timestampAnnotationIndex);
    }

    public String getTimestampAnnotationNamespace(int timestampAnnotationIndex) {
        return this.getAnnotationNamespace(TimestampAnnotation.class, timestampAnnotationIndex);
    }

    public Timestamp getTimestampAnnotationValue(int timestampAnnotationIndex) {
        TimestampAnnotation o = this.getAnnotation(TimestampAnnotation.class, timestampAnnotationIndex);
        return o != null ? new Timestamp(new Instant(o.getTimeValue().getValue())) : null;
    }

    public int getTagAnnotationCount() {
        return this.tagAnnotationList.size();
    }

    public String getTagAnnotationDescription(int tagAnnotationIndex) {
        return this.getAnnotationDescription(TagAnnotation.class, tagAnnotationIndex);
    }

    public String getTagAnnotationID(int tagAnnotationIndex) {
        return this.getAnnotationID(TagAnnotation.class, tagAnnotationIndex);
    }

    public String getTagAnnotationNamespace(int tagAnnotationIndex) {
        return this.getAnnotationNamespace(TagAnnotation.class, tagAnnotationIndex);
    }

    public String getTagAnnotationValue(int tagAnnotationIndex) {
        TagAnnotation o = this.getAnnotation(TagAnnotation.class, tagAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getTextValue()) : null;
    }

    public int getTermAnnotationCount() {
        return this.termAnnotationList.size();
    }

    public String getTermAnnotationDescription(int termAnnotationIndex) {
        return this.getAnnotationDescription(TermAnnotation.class, termAnnotationIndex);
    }

    public String getTermAnnotationID(int termAnnotationIndex) {
        return this.getAnnotationID(TermAnnotation.class, termAnnotationIndex);
    }

    public String getTermAnnotationNamespace(int termAnnotationIndex) {
        return this.getAnnotationNamespace(TermAnnotation.class, termAnnotationIndex);
    }

    public String getTermAnnotationValue(int termAnnotationIndex) {
        TermAnnotation o = this.getAnnotation(TermAnnotation.class, termAnnotationIndex);
        return o != null ? OmeroMetadata.fromRType(o.getTermValue()) : null;
    }

    public int getROICount() {
        return this.roiList.size();
    }

    public String getROIAnnotationRef(int ROIIndex, int annotationRefIndex) {
        if (ROIIndex < 0 || annotationRefIndex < 0 || ROIIndex >= this.roiList.size()) {
            return null;
        }
        Roi roi = this.roiList.get(ROIIndex);
        List<Annotation> annotations = roi.linkedAnnotationList();
        if (annotationRefIndex >= annotations.size()) {
            return null;
        }
        Annotation annotation = annotations.get(annotationRefIndex);
        return this.handleLsid(annotation);
    }

    public int getROIAnnotationRefCount(int ROIIndex) {
        if (ROIIndex < 0 || ROIIndex >= this.roiList.size()) {
            return -1;
        }
        Roi roi = this.roiList.get(ROIIndex);
        return roi.sizeOfAnnotationLinks();
    }

    public String getROIDescription(int ROIIndex) {
        if (ROIIndex < 0 || ROIIndex >= this.roiList.size()) {
            return null;
        }
        Roi roi = this.roiList.get(ROIIndex);
        return OmeroMetadata.fromRType(roi.getDescription());
    }

    public String getROIID(int ROIIndex) {
        if (ROIIndex < 0 || ROIIndex >= this.roiList.size()) {
            return null;
        }
        Roi roi = this.roiList.get(ROIIndex);
        return this.handleLsid(roi);
    }

    public String getROIName(int ROIIndex) {
        if (ROIIndex < 0 || ROIIndex >= this.roiList.size()) {
            return null;
        }
        Roi roi = this.roiList.get(ROIIndex);
        return OmeroMetadata.fromRType(roi.getName());
    }

    public int getShapeCount(int ROIIndex) {
        if (ROIIndex < 0 || ROIIndex >= this.roiList.size()) {
            return -1;
        }
        Roi roi = this.roiList.get(ROIIndex);
        return roi.sizeOfShapes();
    }

    public String getShapeType(int ROIIndex, int shapeIndex) {
        Shape shape = this.getShape(ROIIndex, shapeIndex, Shape.class);
        if (shape == null) {
            return null;
        }
        Class<?> shapeClass = null;
        Class<Object> currentClass = shape.getClass();
        while (currentClass != Shape.class) {
            shapeClass = currentClass;
            currentClass = currentClass.getSuperclass().asSubclass(Shape.class);
        }
        if (shapeClass == Rectangle.class) {
            return "Rectangle";
        }
        return shapeClass.getSimpleName();
    }

    public int getShapeAnnotationRefCount(int ROIIndex, int shapeIndex) {
        Shape shape = this.getShape(ROIIndex, shapeIndex, Shape.class);
        if (shape == null) {
            return -1;
        }
        return shape.sizeOfAnnotationLinks();
    }

    private <X extends Shape> String getShapeAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex, Class<X> expectedSubclass) {
        if (annotationRefIndex < 0) {
            return null;
        }
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        List<Annotation> annotations = ((Shape)shape).linkedAnnotationList();
        if (annotationRefIndex >= annotations.size()) {
            return null;
        }
        Annotation annotation = annotations.get(annotationRefIndex);
        return this.handleLsid(annotation);
    }

    private <X extends Shape> Color getShapeFillColor(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        Integer color = OmeroMetadata.fromRType(((Shape)shape).getFillColor());
        if (color == null) {
            return null;
        }
        return new Color(color);
    }

    private <X extends Shape> FillRule getShapeFillRule(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        FillRule fillRule;
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        String fillRuleName = OmeroMetadata.fromRType(((Shape)shape).getFillRule());
        if (fillRuleName == null) {
            return null;
        }
        try {
            fillRule = FillRule.fromString((String)fillRuleName);
        }
        catch (EnumerationException e) {
            return null;
        }
        return fillRule;
    }

    private <X extends Shape> FontFamily getShapeFontFamily(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        FontFamily fontFamily;
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        String fontFamilyName = OmeroMetadata.fromRType(((Shape)shape).getFontFamily());
        if (fontFamilyName == null) {
            return null;
        }
        try {
            fontFamily = FontFamily.fromString((String)fontFamilyName);
        }
        catch (EnumerationException e) {
            return null;
        }
        return fontFamily;
    }

    private <X extends Shape> Length getShapeFontSize(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return UnitsFactory.convertLength(((Shape)shape).getFontSize());
    }

    private <X extends Shape> FontStyle getShapeFontStyle(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        FontStyle fontStyle;
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        String fontStyleName = OmeroMetadata.fromRType(((Shape)shape).getFontStyle());
        if (fontStyleName == null) {
            return null;
        }
        try {
            fontStyle = FontStyle.fromString((String)fontStyleName);
        }
        catch (EnumerationException e) {
            return null;
        }
        return fontStyle;
    }

    private <X extends Shape> String getShapeID(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return this.handleLsid((IObject)shape);
    }

    private <X extends Shape> Boolean getShapeLocked(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return OmeroMetadata.fromRType(((Shape)shape).getLocked());
    }

    private <X extends Shape> Color getShapeStrokeColor(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        Integer color = OmeroMetadata.fromRType(((Shape)shape).getStrokeColor());
        if (color == null) {
            return null;
        }
        return new Color(color);
    }

    private <X extends Shape> String getShapeStrokeDashArray(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return OmeroMetadata.fromRType(((Shape)shape).getStrokeDashArray());
    }

    private <X extends Shape> Length getShapeStrokeWidth(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return UnitsFactory.convertLength(((Shape)shape).getStrokeWidth());
    }

    private <X extends Shape> NonNegativeInteger getShapeTheC(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return OmeroMetadata.toNonNegativeInteger(((Shape)shape).getTheC());
    }

    private <X extends Shape> NonNegativeInteger getShapeTheT(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return OmeroMetadata.toNonNegativeInteger(((Shape)shape).getTheT());
    }

    private <X extends Shape> NonNegativeInteger getShapeTheZ(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return OmeroMetadata.toNonNegativeInteger(((Shape)shape).getTheZ());
    }

    private <X extends Shape> ome.xml.model.AffineTransform getShapeTransform(int ROIIndex, int shapeIndex, Class<X> expectedSubclass) {
        X shape = this.getShape(ROIIndex, shapeIndex, expectedSubclass);
        if (shape == null) {
            return null;
        }
        return OmeroMetadata.toTransform(((Shape)shape).getTransform());
    }

    public String getEllipseAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Ellipse.class);
    }

    public Color getEllipseFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Ellipse.class);
    }

    public FillRule getEllipseFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Ellipse.class);
    }

    public FontFamily getEllipseFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Ellipse.class);
    }

    public Length getEllipseFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Ellipse.class);
    }

    public FontStyle getEllipseFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Ellipse.class);
    }

    public String getEllipseID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Ellipse.class);
    }

    public Boolean getEllipseLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Ellipse.class);
    }

    public Color getEllipseStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Ellipse.class);
    }

    public String getEllipseStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Ellipse.class);
    }

    public Length getEllipseStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Ellipse.class);
    }

    public NonNegativeInteger getEllipseTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Ellipse.class);
    }

    public NonNegativeInteger getEllipseTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Ellipse.class);
    }

    public NonNegativeInteger getEllipseTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Ellipse.class);
    }

    public ome.xml.model.AffineTransform getEllipseTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Ellipse.class);
    }

    public Double getEllipseRadiusX(int ROIIndex, int shapeIndex) {
        Ellipse ellipse = this.getShape(ROIIndex, shapeIndex, Ellipse.class);
        if (ellipse == null) {
            return null;
        }
        return OmeroMetadata.fromRType(ellipse.getRadiusX());
    }

    public Double getEllipseRadiusY(int ROIIndex, int shapeIndex) {
        Ellipse ellipse = this.getShape(ROIIndex, shapeIndex, Ellipse.class);
        if (ellipse == null) {
            return null;
        }
        return OmeroMetadata.fromRType(ellipse.getRadiusY());
    }

    public String getEllipseText(int ROIIndex, int shapeIndex) {
        Ellipse ellipse = this.getShape(ROIIndex, shapeIndex, Ellipse.class);
        if (ellipse == null) {
            return null;
        }
        return OmeroMetadata.fromRType(ellipse.getTextValue());
    }

    public Double getEllipseX(int ROIIndex, int shapeIndex) {
        Ellipse ellipse = this.getShape(ROIIndex, shapeIndex, Ellipse.class);
        if (ellipse == null) {
            return null;
        }
        return OmeroMetadata.fromRType(ellipse.getX());
    }

    public Double getEllipseY(int ROIIndex, int shapeIndex) {
        Ellipse ellipse = this.getShape(ROIIndex, shapeIndex, Ellipse.class);
        if (ellipse == null) {
            return null;
        }
        return OmeroMetadata.fromRType(ellipse.getY());
    }

    public String getLabelAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Label.class);
    }

    public Color getLabelFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Label.class);
    }

    public FillRule getLabelFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Label.class);
    }

    public FontFamily getLabelFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Label.class);
    }

    public Length getLabelFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Label.class);
    }

    public FontStyle getLabelFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Label.class);
    }

    public String getLabelID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Label.class);
    }

    public Boolean getLabelLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Label.class);
    }

    public Color getLabelStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Label.class);
    }

    public String getLabelStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Label.class);
    }

    public Length getLabelStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Label.class);
    }

    public NonNegativeInteger getLabelTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Label.class);
    }

    public NonNegativeInteger getLabelTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Label.class);
    }

    public NonNegativeInteger getLabelTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Label.class);
    }

    public ome.xml.model.AffineTransform getLabelTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Label.class);
    }

    public String getLabelText(int ROIIndex, int shapeIndex) {
        Label label = this.getShape(ROIIndex, shapeIndex, Label.class);
        if (label == null) {
            return null;
        }
        return OmeroMetadata.fromRType(label.getTextValue());
    }

    public Double getLabelX(int ROIIndex, int shapeIndex) {
        Label label = this.getShape(ROIIndex, shapeIndex, Label.class);
        if (label == null) {
            return null;
        }
        return OmeroMetadata.fromRType(label.getX());
    }

    public Double getLabelY(int ROIIndex, int shapeIndex) {
        Label label = this.getShape(ROIIndex, shapeIndex, Label.class);
        if (label == null) {
            return null;
        }
        return OmeroMetadata.fromRType(label.getY());
    }

    public String getLineAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Line.class);
    }

    public Color getLineFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Line.class);
    }

    public FillRule getLineFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Line.class);
    }

    public FontFamily getLineFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Line.class);
    }

    public Length getLineFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Line.class);
    }

    public FontStyle getLineFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Line.class);
    }

    public String getLineID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Line.class);
    }

    public Boolean getLineLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Line.class);
    }

    public Color getLineStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Line.class);
    }

    public String getLineStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Line.class);
    }

    public Length getLineStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Line.class);
    }

    public NonNegativeInteger getLineTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Line.class);
    }

    public NonNegativeInteger getLineTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Line.class);
    }

    public NonNegativeInteger getLineTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Line.class);
    }

    public ome.xml.model.AffineTransform getLineTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Line.class);
    }

    public Marker getLineMarkerStart(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        RString markerStart = line.getMarkerStart();
        if (markerStart == null) {
            return null;
        }
        try {
            return Marker.fromString((String)markerStart.getValue());
        }
        catch (EnumerationException ex) {
            return null;
        }
    }

    public Marker getLineMarkerEnd(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        RString markerEnd = line.getMarkerEnd();
        if (markerEnd == null) {
            return null;
        }
        try {
            return Marker.fromString((String)markerEnd.getValue());
        }
        catch (EnumerationException ex) {
            return null;
        }
    }

    public String getLineText(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        return OmeroMetadata.fromRType(line.getTextValue());
    }

    public Double getLineX1(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        return OmeroMetadata.fromRType(line.getX1());
    }

    public Double getLineX2(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        return OmeroMetadata.fromRType(line.getX2());
    }

    public Double getLineY1(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        return OmeroMetadata.fromRType(line.getY1());
    }

    public Double getLineY2(int ROIIndex, int shapeIndex) {
        Line line = this.getShape(ROIIndex, shapeIndex, Line.class);
        if (line == null) {
            return null;
        }
        return OmeroMetadata.fromRType(line.getY2());
    }

    public String getPointAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Point.class);
    }

    public Color getPointFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Point.class);
    }

    public FillRule getPointFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Point.class);
    }

    public FontFamily getPointFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Point.class);
    }

    public Length getPointFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Point.class);
    }

    public FontStyle getPointFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Point.class);
    }

    public String getPointID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Point.class);
    }

    public Boolean getPointLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Point.class);
    }

    public Color getPointStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Point.class);
    }

    public String getPointStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Point.class);
    }

    public Length getPointStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Point.class);
    }

    public NonNegativeInteger getPointTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Point.class);
    }

    public NonNegativeInteger getPointTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Point.class);
    }

    public NonNegativeInteger getPointTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Point.class);
    }

    public ome.xml.model.AffineTransform getPointTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Point.class);
    }

    public String getPointText(int ROIIndex, int shapeIndex) {
        Point point = this.getShape(ROIIndex, shapeIndex, Point.class);
        if (point == null) {
            return null;
        }
        return OmeroMetadata.fromRType(point.getTextValue());
    }

    public Double getPointX(int ROIIndex, int shapeIndex) {
        Point point = this.getShape(ROIIndex, shapeIndex, Point.class);
        if (point == null) {
            return null;
        }
        return OmeroMetadata.fromRType(point.getX());
    }

    public Double getPointY(int ROIIndex, int shapeIndex) {
        Point point = this.getShape(ROIIndex, shapeIndex, Point.class);
        if (point == null) {
            return null;
        }
        return OmeroMetadata.fromRType(point.getY());
    }

    public String getPolygonAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Polygon.class);
    }

    public Color getPolygonFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Polygon.class);
    }

    public FillRule getPolygonFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Polygon.class);
    }

    public FontFamily getPolygonFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Polygon.class);
    }

    public Length getPolygonFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Polygon.class);
    }

    public FontStyle getPolygonFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Polygon.class);
    }

    public String getPolygonID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Polygon.class);
    }

    public Boolean getPolygonLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Polygon.class);
    }

    public Color getPolygonStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Polygon.class);
    }

    public String getPolygonStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Polygon.class);
    }

    public Length getPolygonStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Polygon.class);
    }

    public NonNegativeInteger getPolygonTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Polygon.class);
    }

    public NonNegativeInteger getPolygonTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Polygon.class);
    }

    public NonNegativeInteger getPolygonTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Polygon.class);
    }

    public ome.xml.model.AffineTransform getPolygonTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Polygon.class);
    }

    public String getPolygonPoints(int ROIIndex, int shapeIndex) {
        Polygon polygon = this.getShape(ROIIndex, shapeIndex, Polygon.class);
        if (polygon == null) {
            return null;
        }
        return OmeroMetadata.fromRType(polygon.getPoints());
    }

    public String getPolygonText(int ROIIndex, int shapeIndex) {
        Polygon polygon = this.getShape(ROIIndex, shapeIndex, Polygon.class);
        if (polygon == null) {
            return null;
        }
        return OmeroMetadata.fromRType(polygon.getTextValue());
    }

    public String getPolylineAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Polyline.class);
    }

    public Color getPolylineFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Polyline.class);
    }

    public FillRule getPolylineFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Polyline.class);
    }

    public FontFamily getPolylineFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Polyline.class);
    }

    public Length getPolylineFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Polyline.class);
    }

    public FontStyle getPolylineFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Polyline.class);
    }

    public String getPolylineID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Polyline.class);
    }

    public Boolean getPolylineLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Polyline.class);
    }

    public Color getPolylineStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Polyline.class);
    }

    public String getPolylineStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Polyline.class);
    }

    public Length getPolylineStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Polyline.class);
    }

    public NonNegativeInteger getPolylineTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Polyline.class);
    }

    public NonNegativeInteger getPolylineTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Polyline.class);
    }

    public NonNegativeInteger getPolylineTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Polyline.class);
    }

    public ome.xml.model.AffineTransform getPolylineTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Polyline.class);
    }

    public Marker getPolylineMarkerStart(int ROIIndex, int shapeIndex) {
        Polyline polyline = this.getShape(ROIIndex, shapeIndex, Polyline.class);
        if (polyline == null) {
            return null;
        }
        RString markerStart = polyline.getMarkerStart();
        if (markerStart == null) {
            return null;
        }
        try {
            return Marker.fromString((String)markerStart.getValue());
        }
        catch (EnumerationException ex) {
            return null;
        }
    }

    public Marker getPolylineMarkerEnd(int ROIIndex, int shapeIndex) {
        Polyline polyline = this.getShape(ROIIndex, shapeIndex, Polyline.class);
        if (polyline == null) {
            return null;
        }
        RString markerEnd = polyline.getMarkerEnd();
        if (markerEnd == null) {
            return null;
        }
        try {
            return Marker.fromString((String)markerEnd.getValue());
        }
        catch (EnumerationException ex) {
            return null;
        }
    }

    public String getPolylinePoints(int ROIIndex, int shapeIndex) {
        Polyline polyline = this.getShape(ROIIndex, shapeIndex, Polyline.class);
        if (polyline == null) {
            return null;
        }
        return OmeroMetadata.fromRType(polyline.getPoints());
    }

    public String getPolylineText(int ROIIndex, int shapeIndex) {
        Polyline polyline = this.getShape(ROIIndex, shapeIndex, Polyline.class);
        if (polyline == null) {
            return null;
        }
        return OmeroMetadata.fromRType(polyline.getTextValue());
    }

    public String getRectangleAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Rectangle.class);
    }

    public Color getRectangleFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Rectangle.class);
    }

    public FillRule getRectangleFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Rectangle.class);
    }

    public FontFamily getRectangleFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Rectangle.class);
    }

    public Length getRectangleFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Rectangle.class);
    }

    public FontStyle getRectangleFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Rectangle.class);
    }

    public String getRectangleID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Rectangle.class);
    }

    public Boolean getRectangleLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Rectangle.class);
    }

    public Color getRectangleStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Rectangle.class);
    }

    public String getRectangleStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Rectangle.class);
    }

    public Length getRectangleStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Rectangle.class);
    }

    public NonNegativeInteger getRectangleTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Rectangle.class);
    }

    public NonNegativeInteger getRectangleTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Rectangle.class);
    }

    public NonNegativeInteger getRectangleTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Rectangle.class);
    }

    public ome.xml.model.AffineTransform getRectangleTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Rectangle.class);
    }

    public String getRectangleText(int ROIIndex, int shapeIndex) {
        Rectangle rectangle = this.getShape(ROIIndex, shapeIndex, Rectangle.class);
        if (rectangle == null) {
            return null;
        }
        return OmeroMetadata.fromRType(rectangle.getTextValue());
    }

    public Double getRectangleHeight(int ROIIndex, int shapeIndex) {
        Rectangle rectangle = this.getShape(ROIIndex, shapeIndex, Rectangle.class);
        if (rectangle == null) {
            return null;
        }
        return OmeroMetadata.fromRType(rectangle.getHeight());
    }

    public Double getRectangleWidth(int ROIIndex, int shapeIndex) {
        Rectangle rectangle = this.getShape(ROIIndex, shapeIndex, Rectangle.class);
        if (rectangle == null) {
            return null;
        }
        return OmeroMetadata.fromRType(rectangle.getWidth());
    }

    public Double getRectangleX(int ROIIndex, int shapeIndex) {
        Rectangle rectangle = this.getShape(ROIIndex, shapeIndex, Rectangle.class);
        if (rectangle == null) {
            return null;
        }
        return OmeroMetadata.fromRType(rectangle.getX());
    }

    public Double getRectangleY(int ROIIndex, int shapeIndex) {
        Rectangle rectangle = this.getShape(ROIIndex, shapeIndex, Rectangle.class);
        if (rectangle == null) {
            return null;
        }
        return OmeroMetadata.fromRType(rectangle.getY());
    }

    public String getMaskAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        return this.getShapeAnnotationRef(ROIIndex, shapeIndex, annotationRefIndex, Mask.class);
    }

    public Color getMaskFillColor(int ROIIndex, int shapeIndex) {
        return this.getShapeFillColor(ROIIndex, shapeIndex, Mask.class);
    }

    public FillRule getMaskFillRule(int ROIIndex, int shapeIndex) {
        return this.getShapeFillRule(ROIIndex, shapeIndex, Mask.class);
    }

    public FontFamily getMaskFontFamily(int ROIIndex, int shapeIndex) {
        return this.getShapeFontFamily(ROIIndex, shapeIndex, Mask.class);
    }

    public Length getMaskFontSize(int ROIIndex, int shapeIndex) {
        return this.getShapeFontSize(ROIIndex, shapeIndex, Mask.class);
    }

    public FontStyle getMaskFontStyle(int ROIIndex, int shapeIndex) {
        return this.getShapeFontStyle(ROIIndex, shapeIndex, Mask.class);
    }

    public String getMaskID(int ROIIndex, int shapeIndex) {
        return this.getShapeID(ROIIndex, shapeIndex, Mask.class);
    }

    public Boolean getMaskLocked(int ROIIndex, int shapeIndex) {
        return this.getShapeLocked(ROIIndex, shapeIndex, Mask.class);
    }

    public Color getMaskStrokeColor(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeColor(ROIIndex, shapeIndex, Mask.class);
    }

    public String getMaskStrokeDashArray(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeDashArray(ROIIndex, shapeIndex, Mask.class);
    }

    public Length getMaskStrokeWidth(int ROIIndex, int shapeIndex) {
        return this.getShapeStrokeWidth(ROIIndex, shapeIndex, Mask.class);
    }

    public NonNegativeInteger getMaskTheC(int ROIIndex, int shapeIndex) {
        return this.getShapeTheC(ROIIndex, shapeIndex, Mask.class);
    }

    public NonNegativeInteger getMaskTheT(int ROIIndex, int shapeIndex) {
        return this.getShapeTheT(ROIIndex, shapeIndex, Mask.class);
    }

    public NonNegativeInteger getMaskTheZ(int ROIIndex, int shapeIndex) {
        return this.getShapeTheZ(ROIIndex, shapeIndex, Mask.class);
    }

    public ome.xml.model.AffineTransform getMaskTransform(int ROIIndex, int shapeIndex) {
        return this.getShapeTransform(ROIIndex, shapeIndex, Mask.class);
    }

    class OmeroMetadataRoot
    implements MetadataRoot {
        OmeroMetadataRoot() {
        }
    }
}

