/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.ObjectPrx;
import Ice.TieBase;
import Ice.Util;
import java.util.HashMap;
import java.util.concurrent.Callable;
import ome.api.RawFileStore;
import ome.api.ServiceInterface;
import ome.services.blitz.impl.AbstractCloseableAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.util.Executor;
import ome.util.SqlAction;
import omero.InternalException;
import omero.RLong;
import omero.SecurityViolation;
import omero.ServerError;
import omero.api.AMD_RawFileStore_exists;
import omero.api.AMD_RawFileStore_getFileId;
import omero.api.AMD_RawFileStore_read;
import omero.api.AMD_RawFileStore_save;
import omero.api.AMD_RawFileStore_setFileId;
import omero.api.AMD_RawFileStore_size;
import omero.api.AMD_RawFileStore_truncate;
import omero.api.AMD_RawFileStore_write;
import omero.api.RawFileStorePrx;
import omero.api._RawFileStoreOperations;
import omero.api._RawFileStoreTie;
import omero.grid.RepositoryPrx;
import omero.grid.RepositoryPrxHelper;
import omero.model.OriginalFile;
import omero.util.IceMapper;
import omero.util.TieAware;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class RawFileStoreI
extends AbstractCloseableAmdServant
implements _RawFileStoreOperations,
ServiceFactoryAware,
TieAware {
    private ServiceFactoryI sf;
    private _RawFileStoreTie tie;

    public RawFileStoreI(RawFileStore service, BlitzExecutor be) {
        super((ServiceInterface)service, be);
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.sf = sf;
        this.setHolder(sf.holder);
    }

    public ServiceFactoryI getServiceFactory() throws ServerError {
        return this.sf;
    }

    @Override
    public void setTie(TieBase tie) throws ServerError {
        if (!(tie instanceof _RawFileStoreTie)) {
            throw new RuntimeException("Bad tie: " + tie);
        }
        this.tie = (_RawFileStoreTie)tie;
    }

    @Override
    public void exists_async(AMD_RawFileStore_exists __cb, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, new Object[0]);
    }

    @Override
    public void read_async(AMD_RawFileStore_read __cb, long position, int length, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, position, length);
    }

    @Override
    public void getFileId_async(AMD_RawFileStore_getFileId __cb, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, new Object[0]);
    }

    @Override
    public void setFileId_async(AMD_RawFileStore_setFileId __cb, long fileId, Current __current) throws ServerError {
        try {
            if (this.__redirect(fileId, this.tie, __current)) {
                __cb.ice_response();
            } else {
                this.callInvokerOnRawArgs(__cb, __current, fileId);
            }
        }
        catch (ome.conditions.SecurityViolation e) {
            SecurityViolation sv = new SecurityViolation();
            IceMapper.fillServerError(sv, e);
            __cb.ice_exception((Exception)((Object)sv));
        }
        catch (Exception e) {
            __cb.ice_exception(e);
        }
        catch (Throwable e) {
            InternalException ie = new InternalException();
            IceMapper.fillServerError(ie, e);
            __cb.ice_exception((Exception)((Object)ie));
        }
    }

    @Override
    public void size_async(AMD_RawFileStore_size __cb, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, new Object[0]);
    }

    @Override
    public void truncate_async(AMD_RawFileStore_truncate __cb, long length, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, length);
    }

    @Override
    public void write_async(AMD_RawFileStore_write __cb, byte[] buf, long position, int length, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, buf, position, length);
    }

    @Override
    public void save_async(AMD_RawFileStore_save __cb, Current __current) throws ServerError {
        this.callInvokerOnRawArgs(__cb, __current, new Object[0]);
    }

    @Override
    protected void preClose(Current current) throws Throwable {
    }

    @Override
    protected void postClose(Current current) {
    }

    public boolean __redirect(final long fileId, _RawFileStoreTie rfsTie, Current current) throws ServerError {
        String repo = (String)this.sf.executor.executeSql((Executor.SqlWork)new Executor.SimpleSqlWork(this, "__redirect", new Object[]{fileId}){

            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                return sql.fileRepo(fileId);
            }
        });
        if (repo == null) {
            return false;
        }
        HashMap<String, String> adjustedCtx = new HashMap<String, String>(current.ctx);
        adjustedCtx.put("omero.session.uuid", current.id.category);
        adjustedCtx.put("omero.client.uuid", (String)current.ctx.get("omero.client.uuid"));
        ObjectPrx prx = this.sf.getAdapter().createProxy(Util.stringToIdentity((String)("PublicRepository-" + repo)));
        RepositoryPrx repoPrx = RepositoryPrxHelper.checkedCast(prx);
        RawFileStorePrx rfsPrx = repoPrx.fileById(fileId, adjustedCtx);
        OpsDelegate ops = new OpsDelegate(this.be, rfsTie, this, rfsPrx);
        ops.setApplicationContext((ApplicationContext)this.ctx);
        ops.setHolder(this.holder);
        this.tie.ice_delegate(ops);
        return true;
    }

    private static class OpsDelegate
    extends AbstractCloseableAmdServant
    implements _RawFileStoreOperations {
        private final _RawFileStoreTie tie;
        private final RawFileStoreI impl;
        private final RawFileStorePrx prx;

        OpsDelegate(BlitzExecutor be, _RawFileStoreTie tie, RawFileStoreI impl, RawFileStorePrx prx) {
            super(null, be);
            this.tie = tie;
            this.impl = impl;
            this.prx = prx;
        }

        @Override
        public void exists_async(AMD_RawFileStore_exists __cb, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, false, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return OpsDelegate.this.prx.exists();
                }
            });
        }

        @Override
        public void getFileId_async(AMD_RawFileStore_getFileId __cb, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, false, new Callable<RLong>(){

                @Override
                public RLong call() throws Exception {
                    return OpsDelegate.this.prx.getFileId();
                }
            });
        }

        @Override
        public void read_async(AMD_RawFileStore_read __cb, final long position, final int length, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, false, new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return OpsDelegate.this.prx.read(position, length);
                }
            });
        }

        @Override
        public void size_async(AMD_RawFileStore_size __cb, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, false, new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return OpsDelegate.this.prx.size();
                }
            });
        }

        @Override
        public void truncate_async(AMD_RawFileStore_truncate __cb, final long length, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, false, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return OpsDelegate.this.prx.truncate(length);
                }
            });
        }

        @Override
        public void save_async(AMD_RawFileStore_save __cb, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, false, new Callable<OriginalFile>(){

                @Override
                public OriginalFile call() throws Exception {
                    return OpsDelegate.this.prx.save();
                }
            });
        }

        @Override
        public void setFileId_async(AMD_RawFileStore_setFileId __cb, long fileId, Current __current) throws ServerError {
            this.tie.ice_delegate(this.impl);
            this.tie.setFileId_async(__cb, fileId, __current);
        }

        @Override
        public void write_async(AMD_RawFileStore_write __cb, final byte[] buf, final long position, final int length, Current __current) throws ServerError {
            this.safeRunnableCall(__current, __cb, true, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    OpsDelegate.this.prx.write(buf, position, length);
                    return null;
                }
            });
        }

        @Override
        protected void preClose(Current current) throws Throwable {
            this.prx.close(current.ctx);
        }

        @Override
        protected void postClose(Current current) {
        }
    }
}

