/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.redirect;

import Glacier2.CannotCreateSessionException;
import Glacier2.SessionControlPrx;
import Glacier2.SessionManagerPrx;
import Glacier2.SessionManagerPrxHelper;
import Glacier2.SessionPrx;
import Ice.Current;
import Ice.ObjectPrx;
import ome.api.IConfig;
import ome.model.meta.Node;
import ome.parameters.Parameters;
import ome.services.blitz.redirect.Redirector;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractRedirector
implements Redirector {
    protected static final String ROUTED_FROM = "omero.routed_from";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Executor executor;

    public AbstractRedirector(Executor ex) {
        this.executor = ex;
    }

    @Override
    public SessionPrx getProxyOrNull(Redirector.Context ctx, String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        if (this.alreadyRouted(current)) {
            this.log.info("Session creation already routed once for " + userId);
            return null;
        }
        String proxyString = this.proxyForSession(ctx, userId);
        if (proxyString != null && !proxyString.equals(ctx.getDirectProxy())) {
            this.log.info(String.format("Returning remote session on %s", proxyString));
            return this.obtainProxy(proxyString, ctx, userId, control, current);
        }
        return null;
    }

    protected boolean alreadyRouted(Current current) {
        if (current != null && current.ctx != null) {
            return current.ctx.containsKey(ROUTED_FROM);
        }
        return false;
    }

    protected SessionPrx obtainProxy(String proxyString, Redirector.Context ctx, String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        if (proxyString != null) {
            current.ctx.put(ROUTED_FROM, ctx.getDirectProxy());
            ObjectPrx remote = ctx.getCommunicator().stringToProxy(proxyString);
            SessionManagerPrx sessionManagerPrx = SessionManagerPrxHelper.checkedCast((ObjectPrx)remote);
            try {
                return sessionManagerPrx.create(userId, control, current.ctx);
            }
            catch (Exception e) {
                if (e instanceof CannotCreateSessionException) {
                    throw (CannotCreateSessionException)((Object)e);
                }
                this.log.error("Error while routing to " + remote, (Throwable)e);
                throw new CannotCreateSessionException("Error while routing to remote blitz");
            }
        }
        return null;
    }

    protected String getRedirect(Redirector.Context ctx) {
        return (String)this.executor.execute(ctx.principal(), (Executor.Work)new Executor.SimpleWork(this, "getRedirect", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getConfigService().getConfigValue("omero.cluster.redirect");
            }
        });
    }

    protected boolean initializeRedirect(Redirector.Context ctx, final String managerUuid) {
        return (Boolean)this.executor.execute(ctx.principal(), (Executor.Work)new Executor.SimpleWork(this, "setRedirect", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                IConfig config = sf.getConfigService();
                if (managerUuid == null || managerUuid.length() == 0) {
                    config.setConfigValue("omero.cluster.redirect", null);
                    return true;
                }
                return config.setConfigValueIfEquals("omero.cluster.redirect", managerUuid, null);
            }
        });
    }

    protected String findProxy(Redirector.Context ctx, String redirect) {
        String query = "select node from Node node where node.uuid = :uuid";
        return this.nodeProxyQuery(ctx, redirect, "select node from Node node where node.uuid = :uuid");
    }

    protected String proxyForSession(Redirector.Context ctx, String sessionUuid) {
        String query = "select node from Node node join node.sessions as s where s.uuid = :uuid";
        return this.nodeProxyQuery(ctx, sessionUuid, "select node from Node node join node.sessions as s where s.uuid = :uuid");
    }

    protected String nodeProxyQuery(Redirector.Context ctx, final String uuid, final String query) {
        return (String)this.executor.execute(ctx.principal(), (Executor.Work)new Executor.SimpleWork(this, "nodeProxyQuery", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                Parameters p = new Parameters().addString("uuid", uuid);
                Node node = (Node)sf.getQueryService().findByQuery(query, p);
                if (node == null) {
                    return null;
                }
                return node.getConn();
            }
        });
    }
}

