/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Current;
import Ice.ObjectPrx;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import ome.services.blitz.impl.AbstractCloseableAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.ManagedImportLocationI;
import ome.services.blitz.repo.ManagedImportRequestI;
import ome.services.blitz.repo.ManagedRepositoryI;
import ome.services.blitz.repo.ProcessContainer;
import ome.services.blitz.repo.PublicRepositoryI;
import ome.services.blitz.repo.RepoRawFileStoreI;
import ome.services.blitz.repo.path.FsFile;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.util.Executor;
import omero.ApiUsageException;
import omero.ChecksumValidationException;
import omero.RString;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.api.RawFileStorePrx;
import omero.cmd.HandlePrx;
import omero.grid.ImportLocation;
import omero.grid.ImportProcessPrx;
import omero.grid.ImportProcessPrxHelper;
import omero.grid.ImportRequest;
import omero.grid.ImportSettings;
import omero.grid._ImportProcessOperations;
import omero.grid._ImportProcessTie;
import omero.model.Fileset;
import omero.model.FilesetJobLink;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.sys.ParametersI;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.aop.framework.Advised;
import org.springframework.context.ApplicationContext;

public class ManagedImportProcessI
extends AbstractCloseableAmdServant
implements _ImportProcessOperations,
ServiceFactoryAware,
ProcessContainer.Process {
    private static final Logger log = LoggerFactory.getLogger(ManagedImportProcessI.class);
    private final Current current;
    private final ManagedRepositoryI repo;
    private final ImportProcessPrx proxy;
    private final Fileset fs;
    private final ImportSettings settings;
    private final ImportLocation location;
    private ServiceFactoryI sf;
    private final Cache<Integer, UploadState> uploaders = CacheBuilder.newBuilder().build();
    private HandlePrx handle;
    private String logFilename;
    private String rootToken;

    public ManagedImportProcessI(ManagedRepositoryI repo, Fileset fs, ImportLocation location, ImportSettings settings, Current __current, String rootToken) throws ServerError {
        super(null, null);
        this.repo = repo;
        this.fs = fs;
        this.settings = settings;
        this.location = location;
        this.current = __current;
        this.rootToken = rootToken;
        this.proxy = this.registerProxy(__current);
        this.setApplicationContext((ApplicationContext)repo.context);
        CheckedPath logFile = ((ManagedImportLocationI)location).getLogFile();
        this.logFilename = logFile.getFullFsPath();
    }

    @Override
    public void setServiceFactory(ServiceFactoryI sf) throws ServerError {
        this.sf = sf;
    }

    protected ImportProcessPrx registerProxy(Current ignore) throws ServerError {
        _ImportProcessTie tie = new _ImportProcessTie(this);
        Current adjustedCurr = this.repo.makeAdjustedCurrent(this.current);
        ObjectPrx prx = this.repo.registerServant(tie, this, adjustedCurr);
        return ImportProcessPrxHelper.uncheckedCast(prx);
    }

    @Override
    public ImportProcessPrx getProxy() {
        return this.proxy;
    }

    @Override
    public Fileset getFileset() {
        return this.fs;
    }

    @Override
    public ImportSettings getImportSettings(Current __current) {
        return this.settings;
    }

    @Override
    public long getGroup() {
        return this.fs.getDetails().getGroup().getId().getValue();
    }

    @Override
    public void ping() {
        throw new RuntimeException("NYI");
    }

    @Override
    public void shutdown() {
        throw new RuntimeException("NYI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawFileStorePrx getUploader(final int i, Current current) throws ServerError {
        Slf4JStopWatch sw1 = new Slf4JStopWatch();
        try {
            MDC.put((String)"fileset", (String)this.logFilename);
            String mode = null;
            if (current != null && current.ctx != null && (mode = (String)current.ctx.get("omero.fs.mode")) == null) {
                mode = "rw";
            }
            final String applicableMode = mode;
            Callable<UploadState> rfsOpener = new Callable<UploadState>(){

                @Override
                public UploadState call() throws ServerError {
                    Slf4JStopWatch sw2 = new Slf4JStopWatch();
                    String path = ((ManagedImportProcessI)ManagedImportProcessI.this).location.sharedPath + FsFile.separatorChar + ((ManagedImportProcessI)ManagedImportProcessI.this).location.usedFiles.get(i);
                    Current adjustedCurr = ManagedImportProcessI.this.repo.makeAdjustedCurrent(ManagedImportProcessI.this.current);
                    adjustedCurr.ctx.put("omero.logfilename", ManagedImportProcessI.this.logFilename);
                    adjustedCurr.ctx.put("omero.logfilename.token", ManagedImportProcessI.this.rootToken);
                    RawFileStorePrx prx = ManagedImportProcessI.this.repo.file(path, applicableMode, adjustedCurr);
                    try {
                        ManagedImportProcessI.this.registerCallback(prx, i);
                    }
                    catch (RuntimeException re) {
                        try {
                            prx.close();
                        }
                        catch (Exception e) {
                            log.error("Failed to close RawFileStorePrx", (Throwable)e);
                        }
                        throw re;
                    }
                    finally {
                        sw2.stop("omero.import.process.opener");
                    }
                    return new UploadState(prx);
                }
            };
            try {
                RawFileStorePrx rawFileStorePrx = ((UploadState)this.uploaders.get((Object)Integer.valueOf((int)i), (Callable)rfsOpener)).prx;
                return rawFileStorePrx;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                RawFileStorePrx rawFileStorePrx = null;
                sw1.stop("omero.import.process.uploader");
                MDC.clear();
                return rawFileStorePrx;
            }
        }
        finally {
            sw1.stop("omero.import.process.uploader");
            MDC.clear();
        }
    }

    protected void registerCallback(RawFileStorePrx prx, final int idx) {
        Object servant = this.sf.getServant(prx.ice_getIdentity());
        if (servant instanceof Advised) {
            try {
                servant = ((Advised)servant).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        RepoRawFileStoreI store = (RepoRawFileStoreI)servant;
        final ManagedImportProcessI proc = this;
        store.setCallback(new RepoRawFileStoreI.NoOpCallback(){

            @Override
            public void onWrite(byte[] buf, long position, long length) {
                proc.setOffset(idx, position + length);
            }

            @Override
            public void onPreClose() {
                proc.closeCalled(idx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandlePrx verifyUpload(List<String> hashes, Current __current) throws ServerError {
        try {
            MDC.put((String)"fileset", (String)this.logFilename);
            int size = this.fs.sizeOfUsedFiles();
            if (hashes == null) {
                throw new ApiUsageException(null, null, "hashes list cannot be null");
            }
            if (hashes.size() != size) {
                throw new ApiUsageException(null, null, String.format("hashes size should be %s not %s", size, hashes.size()));
            }
            HashMap<Integer, String> failingChecksums = new HashMap<Integer, String>();
            ImmutableMap allGroupsContext = ImmutableMap.of((Object)"omero.group", (Object)"-1");
            IQueryPrx iQuery = this.sf.getQueryService(__current);
            String hql = "SELECT originalFile.hash FROM FilesetEntry WHERE fileset.id = :id AND originalFile.path || originalFile.name = :usedfile";
            for (int i = 0; i < size; ++i) {
                Slf4JStopWatch sw1 = new Slf4JStopWatch();
                String usedFile = this.location.sharedPath + FsFile.separatorChar + this.location.usedFiles.get(i);
                ParametersI params = new ParametersI().addId(this.fs.getId()).add("usedfile", rtypes.rstring(usedFile));
                String clientHash = hashes.get(i);
                String serverHash = "";
                try {
                    RString result = (RString)iQuery.projection("SELECT originalFile.hash FROM FilesetEntry WHERE fileset.id = :id AND originalFile.path || originalFile.name = :usedfile", params, (Map<String, String>)allGroupsContext).get(0).get(0);
                    serverHash = result.getValue();
                }
                catch (IndexOutOfBoundsException | NullPointerException e) {
                    log.error("no server checksum on uploaded file {}", (Object)usedFile, (Object)e);
                }
                if (serverHash.isEmpty() || !clientHash.equals(serverHash)) {
                    failingChecksums.put(i, serverHash);
                }
                sw1.stop("omero.import.process.checksum");
            }
            if (!failingChecksums.isEmpty()) {
                throw new ChecksumValidationException(null, ChecksumValidationException.class.toString(), "A checksum mismatch has occurred.", failingChecksums);
            }
            Slf4JStopWatch sw2 = new Slf4JStopWatch();
            FilesetJobLink link = this.fs.getFilesetJobLink(0);
            this.repo.repositoryDao.updateJob(link.getChild(), "Finished", "Finished", this.current);
            link = this.fs.getFilesetJobLink(1);
            CheckedPath checkedPath = ((ManagedImportLocationI)this.location).getLogFile();
            OriginalFile logFile = this.repo.findInDb(checkedPath, "r", __current);
            String reqId = ImportRequest.ice_staticId();
            ImportRequest req = (ImportRequest)this.repo.getFactory(reqId, this.current).create(reqId);
            req.clientUuid = UUID.randomUUID().toString();
            req.repoUuid = this.repo.getRepoUuid();
            req.process = this.proxy;
            req.activity = link;
            req.location = this.location;
            req.settings = this.settings;
            req.logFile = logFile;
            if (req instanceof ManagedImportRequestI && this.current.ctx != null) {
                ((ManagedImportRequestI)req).setCallContext(this.current.ctx);
            }
            PublicRepositoryI.AMD_submit submit = this.repo.submitRequest(this.sf, req, this.current, Executor.Priority.BACKGROUND);
            this.handle = submit.ret;
            ((ManagedImportRequestI)req).handle = submit.ret;
            sw2.stop("omero.import.process.submit");
            HandlePrx handlePrx = submit.ret;
            return handlePrx;
        }
        finally {
            MDC.clear();
        }
    }

    @Override
    public long getUploadOffset(int idx, Current ignore) throws ServerError {
        UploadState state = (UploadState)this.uploaders.getIfPresent((Object)idx);
        if (state == null) {
            return 0L;
        }
        return state.offset;
    }

    @Override
    public HandlePrx getHandle(Current ignore) {
        return this.handle;
    }

    public void setOffset(int idx, long offset) {
        UploadState state = (UploadState)this.uploaders.getIfPresent((Object)idx);
        if (state == null) {
            log.warn(String.format("setOffset(%s, %s) - no such object", idx, offset));
        } else {
            state.setOffset(offset);
            log.debug(String.format("setOffset(%s, %s) successfully", idx, offset));
        }
    }

    public void closeCalled(int idx) {
        UploadState state = (UploadState)this.uploaders.getIfPresent((Object)idx);
        if (state == null) {
            log.warn(String.format("closeCalled(%s) - no such object", idx));
        } else {
            this.uploaders.invalidate((Object)idx);
            log.debug(String.format("closeCalled(%s) successfully", idx));
        }
    }

    @Override
    protected void preClose(Current current) throws Throwable {
    }

    @Override
    protected void postClose(Current current) {
    }

    static class UploadState {
        final RawFileStorePrx prx;
        long offset = 0L;

        UploadState(RawFileStorePrx prx) {
            if (prx == null) {
                throw new RuntimeException("Null not allowed!");
            }
            this.prx = prx;
        }

        void setOffset(long offset) {
            this.offset = offset;
        }
    }
}

