/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.Object;
import Ice.ObjectFactory;
import Ice.ObjectPrx;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ome.api.IQuery;
import ome.api.RawFileStore;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.OMEROWrapper;
import ome.model.IObject;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.repo.BfPixelsStoreI;
import ome.services.blitz.repo.CheckedPath;
import ome.services.blitz.repo.FileMaker;
import ome.services.blitz.repo.RepoRawFileStoreI;
import ome.services.blitz.repo.RepositoryDao;
import ome.services.blitz.repo.path.FilePathRestrictionInstance;
import ome.services.blitz.repo.path.FilePathRestrictions;
import ome.services.blitz.repo.path.FsFile;
import ome.services.blitz.repo.path.MakePathComponentSafe;
import ome.services.blitz.repo.path.ServerFilePathTransformer;
import ome.services.blitz.util.BlitzExecutor;
import ome.services.blitz.util.ChecksumAlgorithmMapper;
import ome.services.blitz.util.FindServiceFactoryMessage;
import ome.services.blitz.util.RegisterServantMessage;
import ome.services.util.Executor;
import ome.services.util.SleepTimer;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import ome.util.SqlAction;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.messages.InternalMessage;
import omero.InternalException;
import omero.RLong;
import omero.RMap;
import omero.RString;
import omero.RType;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.ServerError;
import omero.ValidationException;
import omero.api.RawFileStorePrx;
import omero.api.RawFileStorePrxHelper;
import omero.api.RawPixelsStorePrx;
import omero.api.RawPixelsStorePrxHelper;
import omero.api._RawFileStoreTie;
import omero.api._RawPixelsStoreTie;
import omero.cmd.AMD_Session_submit;
import omero.cmd.Delete2;
import omero.cmd.HandlePrx;
import omero.cmd.Request;
import omero.grid.UnregisteredFileException;
import omero.grid._RepositoryOperations;
import omero.grid._RepositoryTie;
import omero.model.ChecksumAlgorithm;
import omero.model.OriginalFile;
import omero.util.IceMapper;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Transactional;

public class PublicRepositoryI
implements _RepositoryOperations,
ApplicationContextAware {
    static final String SUDO_REAL_SESSIONUUID = "omero.internal.sudo.real:omero.session.uuid";
    static final String SUDO_REAL_GROUP_NAME = "omero.internal.sudo.real:omero.group";
    private static final Logger log = LoggerFactory.getLogger(PublicRepositoryI.class);
    private static final IOFileFilter DEFAULT_SKIP = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.orFileFilter((IOFileFilter)new NameFileFilter(".omero"), (IOFileFilter)new NameFileFilter(".git")));
    public static final String DIRECTORY_MIMETYPE = "Directory";
    public static final String IMPORT_LOG_MIMETYPE = "application/omero-log-file";
    private long id;
    protected ServerFilePathTransformer serverPaths;
    protected final RepositoryDao repositoryDao;
    protected final ChecksumProviderFactory checksumProviderFactory;
    protected final ImmutableList<ChecksumAlgorithm> checksumAlgorithms;
    protected FilePathRestrictions filePathRestrictions;
    protected OmeroContext context;
    private String repoUuid;

    public PublicRepositoryI(RepositoryDao repositoryDao, ChecksumProviderFactory checksumProviderFactory, String checksumAlgorithmSupported, String pathRules) throws ServerError {
        this.repositoryDao = repositoryDao;
        this.checksumProviderFactory = checksumProviderFactory;
        this.repoUuid = null;
        ImmutableList.Builder checksumAlgorithmsBuilder = ImmutableList.builder();
        for (String term : checksumAlgorithmSupported.split(",")) {
            if (!StringUtils.isNotBlank((String)term)) continue;
            checksumAlgorithmsBuilder.add((java.lang.Object)ChecksumAlgorithmMapper.getChecksumAlgorithm(term.trim()));
        }
        this.checksumAlgorithms = checksumAlgorithmsBuilder.build();
        if (this.checksumAlgorithms.isEmpty()) {
            throw new IllegalArgumentException("a checksum algorithm must be supported");
        }
        HashSet<String> terms = new HashSet<String>();
        for (String term : pathRules.split(",")) {
            if (!StringUtils.isNotBlank((String)term)) continue;
            terms.add(term.trim());
        }
        String[] termArray = terms.toArray(new String[terms.size()]);
        try {
            this.filePathRestrictions = FilePathRestrictionInstance.getFilePathRestrictions(termArray);
        }
        catch (NullPointerException e) {
            throw new ServerError(null, null, "unknown rule set named in: " + pathRules);
        }
    }

    public void initialize(FileMaker fileMaker, Long id, String repoUuid) throws ValidationException {
        this.id = id;
        File root = new File(fileMaker.getDir());
        if (!root.isDirectory()) {
            throw new ValidationException(null, null, "Root directory must be a existing, readable directory.");
        }
        this.repoUuid = repoUuid;
        this.serverPaths = new ServerFilePathTransformer();
        this.serverPaths.setBaseDirFile(root);
        this.serverPaths.setPathSanitizer(new MakePathComponentSafe(this.filePathRestrictions));
    }

    public Object tie() {
        return new _RepositoryTie(this);
    }

    public String getRepoUuid() {
        return this.repoUuid;
    }

    @Override
    public OriginalFile root(Current __current) throws ServerError {
        return this.repositoryDao.getOriginalFile(this.id, __current);
    }

    @Override
    public boolean fileExists(String path, Current __current) throws ServerError {
        CheckedPath checked = this.checkPath(path, null, __current);
        OriginalFile ofile = this.repositoryDao.findRepoFile(this.repoUuid, checked, null, __current);
        return ofile != null;
    }

    @Override
    public List<String> list(String path, Current __current) throws ServerError {
        List<OriginalFile> ofiles = this.listFiles(path, __current);
        ArrayList<String> contents = new ArrayList<String>(ofiles.size());
        for (OriginalFile ofile : ofiles) {
            contents.add(ofile.getPath().getValue() + ofile.getName().getValue());
        }
        return contents;
    }

    @Override
    public List<OriginalFile> listFiles(String path, Current __current) throws ServerError {
        CheckedPath checked = this.checkPath(path, null, __current).mustExist();
        return this.repositoryDao.getOriginalFiles(this.repoUuid, checked, __current);
    }

    @Override
    public RMap treeList(String path, Current __current) throws ServerError {
        CheckedPath checked = this.checkPath(path, null, __current);
        return this.repositoryDao.treeList(this.repoUuid, checked, __current);
    }

    @Override
    public OriginalFile register(String path, RString mimetype, Current __current) throws ServerError {
        CheckedPath checked = this.checkPath(path, null, __current);
        return this.repositoryDao.register(this.repoUuid, checked, mimetype == null ? null : mimetype.getValue(), __current);
    }

    @Override
    public HandlePrx deletePaths(String[] files, boolean recursive, boolean force, Current __current) throws ServerError {
        Current adjustedCurr = this.makeAdjustedCurrent(__current);
        String delId = Delete2.ice_staticId();
        Delete2 deleteRequest = (Delete2)this.getFactory(delId, adjustedCurr).create(delId);
        ArrayList<Long> fileIds = new ArrayList<Long>();
        deleteRequest.targetObjects = new HashMap();
        deleteRequest.targetObjects.put("OriginalFile", fileIds);
        for (String path : files) {
            RMap map = this.treeList(path, __current);
            this._deletePaths(map, fileIds);
        }
        FindServiceFactoryMessage msg = new FindServiceFactoryMessage((java.lang.Object)this, adjustedCurr);
        this.publishMessage(msg);
        ServiceFactoryI sf = msg.getServiceFactory();
        AMD_submit submit = this.submitRequest(sf, deleteRequest, adjustedCurr);
        return submit.ret;
    }

    private void _deletePaths(RMap map, List<Long> fileIds) {
        if (map != null && map.getValue() != null) {
            for (RType value : map.getValue().values()) {
                RMap val = (RMap)value;
                if (val == null || val.getValue() == null) continue;
                if (val.getValue().containsKey("files")) {
                    RMap files = (RMap)val.getValue().get("files");
                    this._deletePaths(files, fileIds);
                }
                RLong id = (RLong)val.getValue().get("id");
                fileIds.add(id.getValue());
            }
        }
    }

    @Override
    public String mimetype(String path, Current __current) throws ServerError {
        return this.checkPath(path, null, __current).mustExist().getMimetype();
    }

    @Override
    @Deprecated
    public RawPixelsStorePrx pixels(String path, Current __current) throws ServerError {
        BfPixelsStoreI rps;
        CheckedPath checked = this.checkPath(path, null, __current);
        Current adjustedCurr = this.makeAdjustedCurrent(__current);
        this.findInDb(checked, "r", adjustedCurr);
        try {
            rps = new BfPixelsStoreI(path, new OMEROWrapper(new ImportConfig()).getImageReader());
        }
        catch (Throwable t) {
            if (t instanceof ServerError) {
                throw (ServerError)((java.lang.Object)t);
            }
            InternalException ie = new InternalException();
            IceMapper.fillServerError(ie, t);
            throw ie;
        }
        _RawPixelsStoreTie tie = new _RawPixelsStoreTie(rps);
        RegisterServantMessage msg = new RegisterServantMessage(this, tie, adjustedCurr);
        this.publishMessage(msg);
        ObjectPrx prx = msg.getProxy();
        if (prx == null) {
            throw new InternalException(null, null, "No ServantHolder for proxy.");
        }
        return RawPixelsStorePrxHelper.uncheckedCast(prx);
    }

    @Override
    public RawFileStorePrx file(String path, String mode, Current __current) throws ServerError {
        CheckedPath check = this.checkPath(path, null, __current);
        this.findOrCreateInDb(check, mode, __current);
        return this.createRepoRFS(check, mode, __current);
    }

    @Override
    public RawFileStorePrx fileById(long fileId, Current __current) throws ServerError {
        CheckedPath checked = this.checkId(fileId, __current);
        return this.createRepoRFS(checked, "r", __current);
    }

    protected OriginalFile findInDb(CheckedPath checked, String mode, Current current) throws ServerError {
        OriginalFile ofile = this.repositoryDao.findRepoFile(this.repoUuid, checked, null, current);
        if (ofile == null) {
            return null;
        }
        boolean requiresWrite = true;
        if ("r".equals(mode)) {
            requiresWrite = false;
        }
        checked.setId(ofile.getId().getValue());
        boolean canUpdate = this.repositoryDao.canUpdate(ofile, current);
        if (requiresWrite && !canUpdate) {
            throw new SecurityViolation(null, null, "requiresWrite is true but cannot modify");
        }
        return ofile;
    }

    @Deprecated
    private void setOriginalFileHasherToSHA1(final long id, Current current) throws ServerError {
        Executor executor = (Executor)this.context.getBean("executor", Executor.class);
        Map ctx = current.ctx;
        String session = (String)ctx.get("omero.session.uuid");
        String group = (String)ctx.get("omero.group");
        Principal principal = new Principal(session, group, null);
        try {
            executor.execute(ctx, principal, (Executor.Work)new Executor.SimpleWork(this, "setOriginalFileHasherToSHA1", new java.lang.Object[]{id}){

                @Transactional
                public java.lang.Object doWork(Session session, ServiceFactory sf) {
                    IQuery iQuery = sf.getQueryService();
                    ome.model.core.OriginalFile originalFile = (ome.model.core.OriginalFile)iQuery.find(ome.model.core.OriginalFile.class, id);
                    ome.model.enums.ChecksumAlgorithm sha1 = (ome.model.enums.ChecksumAlgorithm)iQuery.findByString(ome.model.enums.ChecksumAlgorithm.class, "value", "SHA1-160");
                    originalFile.setHash(null);
                    originalFile.setHasher(sha1);
                    sf.getUpdateService().saveObject((IObject)originalFile);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw (ServerError)new IceMapper().handleException(e, executor.getContext());
        }
    }

    @Deprecated
    protected ome.model.core.OriginalFile persistLogFile(final ome.model.core.OriginalFile originalFile, Current current) throws ServerError {
        Executor executor = (Executor)this.context.getBean("executor", Executor.class);
        Map ctx = current.ctx;
        String session = (String)ctx.get("omero.session.uuid");
        String group = (String)ctx.get("omero.group");
        Principal principal = new Principal(session, group, null);
        try {
            return (ome.model.core.OriginalFile)executor.execute(ctx, principal, (Executor.Work)new Executor.SimpleWork(this, "persistLogFile", new java.lang.Object[]{this.id}){

                @Transactional(readOnly=false)
                public ome.model.core.OriginalFile doWork(Session session, ServiceFactory sf) {
                    ome.model.core.OriginalFile persisted = (ome.model.core.OriginalFile)sf.getUpdateService().saveAndReturnObject((IObject)originalFile);
                    this.getSqlAction().setFileRepo(Collections.singleton(persisted.getId()), PublicRepositoryI.this.repoUuid);
                    session.refresh((java.lang.Object)persisted);
                    return persisted;
                }
            });
        }
        catch (Exception e) {
            throw (ServerError)new IceMapper().handleException(e, executor.getContext());
        }
    }

    protected OriginalFile findOrCreateInDb(CheckedPath checked, String mode, Current curr) throws ServerError {
        return this.findOrCreateInDb(checked, mode, null, curr);
    }

    protected OriginalFile findOrCreateInDb(CheckedPath checked, String mode, String mimetype, Current curr) throws ServerError {
        OriginalFile ofile = this.findInDb(checked, mode, curr);
        if (ofile != null) {
            return ofile;
        }
        if (checked.exists()) {
            UnregisteredFileException ufe = new UnregisteredFileException();
            ufe.file = ofile = (OriginalFile)new IceMapper().map((Filterable)checked.asOriginalFile(mimetype));
            throw ufe;
        }
        ofile = this.repositoryDao.register(this.repoUuid, checked, null, curr);
        long originalFileId = ofile.getId().getValue();
        this.setOriginalFileHasherToSHA1(originalFileId, curr);
        checked.setId(originalFileId);
        return ofile;
    }

    protected Current makeAdjustedCurrent(Current __current) {
        String sessionUuid = (String)__current.ctx.get("omero.session.uuid");
        Current adjustedCurr = new Current();
        adjustedCurr.ctx = __current.ctx;
        adjustedCurr.adapter = __current.adapter;
        adjustedCurr.operation = __current.operation;
        adjustedCurr.id = new Identity(__current.id.name, sessionUuid);
        return adjustedCurr;
    }

    protected Current sudo(Current current, String sessionUuid) {
        Current sudoCurrent = this.makeAdjustedCurrent(current);
        sudoCurrent.ctx = new HashMap(current.ctx);
        sudoCurrent.ctx.put(SUDO_REAL_SESSIONUUID, current.ctx.get("omero.session.uuid"));
        sudoCurrent.ctx.put(SUDO_REAL_GROUP_NAME, current.ctx.get("omero.group"));
        sudoCurrent.ctx.put("omero.session.uuid", sessionUuid);
        return sudoCurrent;
    }

    protected RawFileStorePrx createRepoRFS(CheckedPath checked, String mode, Current __current) throws ServerError, InternalException {
        RepoRawFileStoreI rfs;
        Current adjustedCurr = this.makeAdjustedCurrent(__current);
        BlitzExecutor be = (BlitzExecutor)this.context.getBean("throttlingStrategy", BlitzExecutor.class);
        try {
            RawFileStore service = this.repositoryDao.getRawFileStore(checked.getId(), checked, mode, __current);
            rfs = new RepoRawFileStoreI(be, service, adjustedCurr);
            rfs.setApplicationContext((ApplicationContext)this.context);
        }
        catch (Throwable t) {
            if (t instanceof ServerError) {
                throw (ServerError)((java.lang.Object)t);
            }
            InternalException ie = new InternalException();
            IceMapper.fillServerError(ie, t);
            throw ie;
        }
        _RawFileStoreTie tie = new _RawFileStoreTie(rfs);
        ObjectPrx prx = this.registerServant(tie, rfs, adjustedCurr);
        return RawFileStorePrxHelper.uncheckedCast(prx);
    }

    ObjectPrx registerServant(Object tie, AbstractAmdServant servant, Current current) throws ServerError {
        RegisterServantMessage msg = new RegisterServantMessage(this, tie, servant.getClass().getSimpleName(), current);
        this.publishMessage(msg);
        ObjectPrx prx = msg.getProxy();
        if (prx == null) {
            throw new InternalException(null, null, "No ServantHolder for proxy.");
        }
        return prx;
    }

    protected void publishMessage(InternalMessage msg) throws ServerError, InternalException {
        try {
            this.context.publishMessage(msg);
        }
        catch (Throwable t) {
            if (t instanceof ServerError) {
                throw (ServerError)((java.lang.Object)t);
            }
            InternalException ie = new InternalException();
            IceMapper.fillServerError(ie, t);
            throw ie;
        }
    }

    protected AMD_submit submitRequest(ServiceFactoryI sf, Request req, Current current) throws ServerError, InternalException {
        return this.submitRequest(sf, req, current, null);
    }

    protected AMD_submit submitRequest(ServiceFactoryI sf, Request req, Current current, Executor.Priority priority) throws ServerError, InternalException {
        AMD_submit submit = new AMD_submit();
        sf.submit_async(submit, req, current, priority);
        if (submit.ex != null) {
            IceMapper mapper = new IceMapper();
            throw mapper.handleServerError(submit.ex, this.context);
        }
        if (submit.ret == null) {
            throw new InternalException(null, null, "No handle proxy found for: " + (java.lang.Object)((java.lang.Object)req));
        }
        return submit;
    }

    protected ObjectFactory getFactory(String id, Current current) {
        Communicator ic = current.adapter.getCommunicator();
        return ic.findObjectFactory(id);
    }

    @Override
    public void makeDir(String path, boolean parents, Current current) throws ServerError {
        CheckedPath checked = this.checkPath(path, null, current);
        this.repositoryDao.makeDirs(this, Arrays.asList(checked), parents, current);
    }

    public void makeDir(CheckedPath checked, boolean parents, Session s, ServiceFactory sf, SqlAction sql, EventContext effectiveEventContext) throws ServerError {
        LinkedList<CheckedPath> paths = new LinkedList<CheckedPath>();
        while (!checked.isRoot) {
            paths.addFirst(checked);
            checked = checked.parent();
            if (parents) continue;
        }
        if (paths.size() == 0) {
            if (parents) {
                throw new ResourceError(null, null, "Cannot re-create root!");
            }
            log.debug("Ignoring re-creation of root");
            return;
        }
        this.makeCheckedDirs(paths, parents, s, sf, sql, effectiveEventContext);
    }

    protected void makeCheckedDirs(LinkedList<CheckedPath> paths, boolean parents, Session s, ServiceFactory sf, SqlAction sql, EventContext effectiveEventContext) throws ServerError {
        CheckedPath checked;
        while (paths.size() > 1) {
            checked = paths.removeFirst();
            if (checked.exists()) {
                if (!checked.isDirectory()) {
                    throw new ResourceError(null, null, "Path is not a directory.");
                }
                if (!checked.canRead()) {
                    throw new ResourceError(null, null, "Directory is not readable");
                }
                this.assertFindDir(checked, s, sf, sql);
                continue;
            }
            try {
                this.repositoryDao.register(this.repoUuid, checked, DIRECTORY_MIMETYPE, sf, sql, s);
            }
            catch (ValidationException ve) {
                if (ve.getCause() instanceof PSQLException) {
                    SleepTimer.sleepFor((long)1000L);
                    if (checked.exists()) {
                        log.warn("retrying after exception in registering directory " + checked + ": " + ve.getCause());
                        paths.add(0, checked);
                        continue;
                    }
                }
                throw ve;
            }
        }
        checked = paths.removeFirst();
        if (checked.exists()) {
            if (parents) {
                this.assertFindDir(checked, s, sf, sql);
            } else {
                throw new ResourceError(null, null, "Path exists on disk: " + checked.fsFile);
            }
        }
        this.repositoryDao.register(this.repoUuid, checked, DIRECTORY_MIMETYPE, sf, sql, s);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (OmeroContext)applicationContext;
    }

    protected CheckedPath checkPath(String path, ChecksumAlgorithm checksumAlgorithm, Current curr) throws ValidationException {
        return new CheckedPath(this.serverPaths, path, this.checksumProviderFactory, checksumAlgorithm);
    }

    private CheckedPath checkId(long id, Current curr) throws SecurityViolation, ValidationException {
        FsFile file = this.repositoryDao.getFile(id, curr, this.repoUuid);
        if (file == null) {
            throw new SecurityViolation(null, null, "FileNotFound: " + id);
        }
        OriginalFile originalFile = this.repositoryDao.getOriginalFile(id, curr);
        if (originalFile == null) {
            throw new SecurityViolation(null, null, "FileNotAccessible: " + id);
        }
        CheckedPath checked = new CheckedPath(this.serverPaths, file.toString(), this.checksumProviderFactory, originalFile.getHasher());
        checked.setId(id);
        return checked;
    }

    private void assertFindDir(CheckedPath checked, Session s, ServiceFactory sf, SqlAction sql) throws ServerError {
        if (null == this.repositoryDao.findRepoFile(sf, sql, this.repoUuid, checked, null)) {
            ResourceError re = new ResourceError();
            IceMapper.fillServerError(re, new RuntimeException("Directory exists but is not registered: " + checked));
            throw re;
        }
    }

    protected String stackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static class AMD_submit
    implements AMD_Session_submit {
        HandlePrx ret;
        Exception ex;

        @Override
        public void ice_response(HandlePrx __ret) {
            this.ret = __ret;
        }

        public void ice_exception(Exception ex) {
            this.ex = ex;
        }
    }
}

